/*
 * Decompiled with CFR 0.152.
 */
package scala.maven;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import scala.maven.BasicArtifact;
import scala.maven.JavaCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ScalaMojoSupport
extends AbstractMojo {
    protected MavenProject project;
    protected ArtifactFactory factory;
    protected ArtifactResolver resolver;
    protected ArtifactRepository localRepo;
    protected List<?> remoteRepos;
    protected BasicArtifact[] scalaJars;
    protected String[] jvmArgs;
    protected String[] args;
    protected String scalaClassName;
    protected String scalaVersion;
    protected boolean displayCmd;
    protected MavenProjectBuilder mavenProjectBuilder;

    ScalaMojoSupport() {
    }

    protected Set<Artifact> resolveDependencyArtifacts(MavenProject theProject) throws Exception {
        AndArtifactFilter filter = new AndArtifactFilter();
        filter.add((ArtifactFilter)new ScopeArtifactFilter("test"));
        filter.add(new ArtifactFilter(){

            public boolean include(Artifact artifact) {
                return !artifact.isOptional();
            }
        });
        Set artifacts = theProject.createArtifacts(this.factory, "runtime", (ArtifactFilter)filter);
        for (Artifact artifact : artifacts) {
            this.resolver.resolve(artifact, this.remoteRepos, this.localRepo);
        }
        return artifacts;
    }

    protected Set<Artifact> resolveArtifactDependencies(Artifact artifact) throws Exception {
        Artifact pomArtifact = this.factory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "", "pom");
        MavenProject pomProject = this.mavenProjectBuilder.buildFromRepository(pomArtifact, this.remoteRepos, this.localRepo);
        return this.resolveDependencyArtifacts(pomProject);
    }

    protected void addToClasspath(String groupId, String artifactId, String version, Set<String> classpath) throws Exception {
        this.addToClasspath(this.factory.createArtifact(groupId, artifactId, version, "runtime", "jar"), classpath);
    }

    protected void addToClasspath(Artifact artifact, Set<String> classpath) throws Exception {
        this.resolver.resolve(artifact, this.remoteRepos, this.localRepo);
        classpath.add(artifact.getFile().getCanonicalPath());
        for (Artifact dep : this.resolveArtifactDependencies(artifact)) {
            classpath.add(dep.getFile().getCanonicalPath());
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.doExecute();
        }
        catch (MojoExecutionException exc) {
            throw exc;
        }
        catch (MojoFailureException exc) {
            throw exc;
        }
        catch (RuntimeException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new MojoExecutionException("wrap: " + exc, exc);
        }
    }

    protected abstract void doExecute() throws Exception;

    protected JavaCommand getScalaCommand() throws Exception {
        JavaCommand cmd = this.getEmptyScalaCommand(this.scalaClassName);
        cmd.addArgs(this.args);
        cmd.addJvmArgs(this.jvmArgs);
        return cmd;
    }

    protected JavaCommand getEmptyScalaCommand(String mainClass) throws Exception {
        JavaCommand cmd = new JavaCommand(this, mainClass, this.getToolClasspath(), null, null);
        cmd.addJvmArgs("-Xbootclasspath/a:" + this.getBootClasspath());
        return cmd;
    }

    private String getToolClasspath() throws Exception {
        HashSet<String> classpath = new HashSet<String>();
        this.addToClasspath("org.scala-lang", "scala-compiler", this.scalaVersion, classpath);
        this.addToClasspath("org.scala-lang", "scala-decoder", this.scalaVersion, classpath);
        this.addToClasspath("org.scala-lang", "scala-dbc", this.scalaVersion, classpath);
        if (this.scalaJars != null) {
            for (BasicArtifact artifact : this.scalaJars) {
                this.addToClasspath(artifact.groupId, artifact.artifactId, artifact.version, classpath);
            }
        }
        return JavaCommand.toMultiPath(classpath.toArray(new String[classpath.size()]));
    }

    private String getBootClasspath() throws Exception {
        HashSet<String> classpath = new HashSet<String>();
        this.addToClasspath("org.scala-lang", "scala-library", this.scalaVersion, classpath);
        return JavaCommand.toMultiPath(classpath.toArray(new String[classpath.size()]));
    }
}

