/*
 * Decompiled with CFR 0.152.
 */
package org.scala_tools.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.scala_tools.maven.JavaCommand;
import org.scala_tools.maven.ScalaMojoSupport;
import org.scala_tools.maven.model.MavenProjectAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalaScriptMojo
extends ScalaMojoSupport {
    protected File outputDir;
    protected File scriptFile;
    protected String script;
    protected boolean keepGeneratedScript;
    protected String includeScopes;
    protected String excludeScopes;
    protected String addToClasspath;
    protected String removeFromClasspath;
    private static int currentScriptIndex = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute() throws Exception {
        if (this.script == null && this.scriptFile == null) {
            throw new MojoFailureException("Either script or scriptFile must be defined");
        }
        if (this.script != null && this.scriptFile != null) {
            throw new MojoFailureException("Only one of script or scriptFile can be defined");
        }
        ++currentScriptIndex;
        File scriptDir = new File(this.outputDir, ".scalaScriptGen");
        scriptDir.mkdirs();
        File destFile = new File(scriptDir + "/" + this.scriptBaseName() + ".scala");
        HashSet<String> classpath = new HashSet<String>();
        this.configureClasspath(classpath);
        URLClassLoader loader = this.createScriptClassloader(scriptDir, classpath);
        boolean mavenProjectDependency = this.hasMavenProjectDependency(classpath);
        this.wrapScript(destFile, mavenProjectDependency);
        try {
            this.compileScript(scriptDir, destFile, classpath);
            this.runScript(mavenProjectDependency, loader);
        }
        finally {
            if (!this.keepGeneratedScript) {
                this.delete(scriptDir);
            }
        }
    }

    private boolean hasMavenProjectDependency(Set<String> classpath) throws MalformedURLException {
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String string : classpath) {
                urls.add(new URL("file://" + string));
            }
            URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()]));
            loader.loadClass(MavenProjectAdapter.class.getCanonicalName());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void runScript(boolean mavenProjectDependency, URLClassLoader loader) throws Exception {
        Class<?> compiledScript = loader.loadClass(this.scriptBaseName());
        try {
            try {
                Object instance;
                if (mavenProjectDependency) {
                    Constructor<?> constructor = compiledScript.getConstructor(MavenProjectAdapter.class, Log.class);
                    instance = constructor.newInstance(new MavenProjectAdapter(this.project), this.getLog());
                } else {
                    instance = compiledScript.newInstance();
                }
                try {
                    compiledScript.getMethod("run", new Class[0]).invoke(instance, new Object[0]);
                }
                catch (NoSuchMethodException e) {}
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() != null) {
                    throw e.getTargetException();
                }
                if (e.getCause() != null) {
                    throw e.getCause();
                }
                throw e;
            }
            catch (ExceptionInInitializerError e) {
                if (e.getException() != null) {
                    throw e.getException();
                }
                if (e.getCause() != null) {
                    throw e.getCause();
                }
                throw e;
            }
        }
        catch (Throwable e) {
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw new Exception("A " + e.getClass().getSimpleName() + " exception was thrown", e);
        }
    }

    private URLClassLoader createScriptClassloader(File scriptDir, Set<String> classpath) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(scriptDir.toURI().toURL());
        for (String string : classpath) {
            urls.add(new URL("file://" + string));
        }
        URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
        return loader;
    }

    private void compileScript(File scriptDir, File destFile, Set<String> classpath) throws Exception {
        JavaCommand jcmd = this.getScalaCommand();
        jcmd.addArgs("-classpath", JavaCommand.toMultiPath(new ArrayList<String>(classpath)));
        jcmd.addArgs("-d", scriptDir.getAbsolutePath());
        jcmd.addArgs("-sourcepath", scriptDir.getAbsolutePath());
        jcmd.addArgs(destFile.getAbsolutePath());
        jcmd.run(this.displayCmd);
    }

    private void configureClasspath(Set<String> classpath) throws Exception, DependencyResolutionRequiredException {
        String outputDirectory;
        Scopes scope;
        MavenProjectAdapter projectAdapter = new MavenProjectAdapter(this.project);
        ArrayList<Dependency> toInclude = new ArrayList<Dependency>();
        if (this.includeScopes == null || this.includeScopes.length() == 0) {
            this.getLog().warn((CharSequence)"No scopes were included");
        } else {
            String[] include;
            for (String string : include = this.includeScopes.split(",")) {
                scope = Scopes.lookup(string.toUpperCase());
                if (scope != null) {
                    toInclude.addAll(scope.elements(projectAdapter));
                    continue;
                }
                this.getLog().warn((CharSequence)("Included Scope: " + string + " is not one of: " + Arrays.asList(Scopes.values())));
            }
        }
        if (this.excludeScopes != null && this.excludeScopes.length() > 0) {
            String[] exclude;
            for (String string : exclude = this.excludeScopes.split(",")) {
                scope = Scopes.lookup(string.toUpperCase());
                if (scope != null) {
                    toInclude.removeAll(scope.elements(projectAdapter));
                    continue;
                }
                this.getLog().warn((CharSequence)("Excluded Scope: " + string + " is not one of: " + Arrays.asList(Scopes.values())));
            }
        }
        for (Dependency dependency : toInclude) {
            this.addToClasspath(this.factory.createDependencyArtifact(dependency.getGroupId(), dependency.getArtifactId(), VersionRange.createFromVersion((String)dependency.getVersion()), dependency.getType(), dependency.getClassifier(), dependency.getScope(), dependency.isOptional()), classpath);
        }
        if (this.addToClasspath != null) {
            classpath.addAll(Arrays.asList(this.addToClasspath.split(",")));
        }
        if (this.removeFromClasspath != null) {
            ArrayList<String> toRemove = new ArrayList<String>();
            String[] jars = this.removeFromClasspath.trim().split(",");
            for (String string : classpath) {
                for (String jar : jars) {
                    if (!string.contains(jar.trim())) continue;
                    toRemove.add(string);
                }
            }
            classpath.removeAll(toRemove);
        }
        if (!(outputDirectory = this.project.getBuild().getOutputDirectory()).endsWith("/")) {
            outputDirectory = outputDirectory + "/";
        }
        classpath.add(outputDirectory);
        this.addToClasspath("org.scala-lang", "scala-compiler", this.scalaVersion, classpath);
        this.addToClasspath("org.scala-lang", "scala-library", this.scalaVersion, classpath);
        this.getLog().debug((CharSequence)("Using the following classpath for running and compiling scripts: " + classpath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wrapScript(File destFile, boolean mavenProjectDependency) throws IOException {
        destFile.delete();
        FileOutputStream fileOutputStream = new FileOutputStream(destFile);
        PrintStream out = new PrintStream(fileOutputStream);
        try {
            BufferedReader reader = this.scriptFile != null ? new BufferedReader(new FileReader(this.scriptFile)) : new BufferedReader(new StringReader(this.script));
            if (mavenProjectDependency) {
                out.println("import scala.collection.jcl.Conversions._");
                out.println("class " + this.scriptBaseName() + "(project:" + MavenProjectAdapter.class.getCanonicalName() + ",log:" + Log.class.getCanonicalName() + ") {");
            } else {
                out.println("class " + this.scriptBaseName() + " {");
            }
            String line = reader.readLine();
            while (line != null) {
                out.print("  ");
                out.println(line);
                line = reader.readLine();
            }
            out.println("}");
        }
        finally {
            out.close();
            fileOutputStream.close();
        }
    }

    private String scriptBaseName() {
        if (this.scriptFile == null) {
            return "embeddedScript_" + currentScriptIndex;
        }
        int dot = this.scriptFile.getName().lastIndexOf(46);
        if (dot == -1) {
            return this.scriptFile.getName() + "_" + currentScriptIndex;
        }
        return this.scriptFile.getName().substring(0, dot) + "_" + currentScriptIndex;
    }

    private void delete(File scriptDir) {
        if (scriptDir.isDirectory()) {
            for (File file : scriptDir.listFiles()) {
                this.delete(file);
            }
        }
        scriptDir.deleteOnExit();
        scriptDir.delete();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Scopes {
        COMPILE{

            @Override
            public Collection<Dependency> elements(MavenProjectAdapter project) throws DependencyResolutionRequiredException {
                return project.getCompileDependencies();
            }
        }
        ,
        RUNTIME{

            @Override
            public Collection<Dependency> elements(MavenProjectAdapter project) throws DependencyResolutionRequiredException {
                return project.getRuntimeDependencies();
            }
        }
        ,
        TEST{

            @Override
            public Collection<Dependency> elements(MavenProjectAdapter project) throws DependencyResolutionRequiredException {
                return project.getTestDependencies();
            }
        }
        ,
        SYSTEM{

            @Override
            public Collection<Dependency> elements(MavenProjectAdapter project) throws DependencyResolutionRequiredException {
                return project.getSystemDependencies();
            }
        };


        public abstract Collection<Dependency> elements(MavenProjectAdapter var1) throws DependencyResolutionRequiredException;

        public static Scopes lookup(String name) {
            for (Scopes scope : Scopes.values()) {
                if (!scope.name().trim().equalsIgnoreCase(name.trim())) continue;
                return scope;
            }
            return null;
        }
    }
}

