/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.stm.ccstm;

import java.util.concurrent.TimeUnit;
import scala.concurrent.stm.ccstm.CCSTM$;
import scala.concurrent.stm.ccstm.Handle;
import scala.concurrent.stm.ccstm.Stats$;
import scala.concurrent.stm.ccstm.WakeupManager;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c!B\u0001\u0003\u0001\tQ!\u0001\u0003*fiJL8+\u001a;\u000b\u0005\r!\u0011!B2dgRl'BA\u0003\u0007\u0003\r\u0019H/\u001c\u0006\u0003\u000f!\t!bY8oGV\u0014(/\u001a8u\u0015\u0005I\u0011!B:dC2\f7C\u0001\u0001\f!\ta\u0011#D\u0001\u000e\u0015\tqq\"\u0001\u0003mC:<'\"\u0001\t\u0002\t)\fg/Y\u0005\u0003%5\u0011aa\u00142kK\u000e$\b\u0002\u0003\u000b\u0001\u0005\u000b\u0007I\u0011\u0001\f\u0002\tML'0Z\u0002\u0001+\u00059\u0002C\u0001\r\u001a\u001b\u0005A\u0011B\u0001\u000e\t\u0005\rIe\u000e\u001e\u0005\t9\u0001\u0011\t\u0011)A\u0005/\u0005)1/\u001b>fA!Aa\u0004\u0001B\u0001B\u0003%q$A\u0004iC:$G.Z:\u0011\u0007a\u0001#%\u0003\u0002\"\u0011\t)\u0011I\u001d:bsB\u00121%\u000b\t\u0004I\u0015:S\"\u0001\u0002\n\u0005\u0019\u0012!A\u0002%b]\u0012dW\r\u0005\u0002)S1\u0001A!\u0003\u0016\u0001\u0003\u0003\u0005\tQ!\u0001,\u0005\ryF%M\t\u0003Y=\u0002\"\u0001G\u0017\n\u00059B!a\u0002(pi\"Lgn\u001a\t\u00031AJ!!\r\u0005\u0003\u0007\u0005s\u0017\u0010\u0003\u00054\u0001\t\u0005\t\u0015!\u00035\u0003!1XM]:j_:\u001c\bc\u0001\r!kA\u0011a'\u000f\b\u0003I]J!\u0001\u000f\u0002\u0002\u000b\r\u001b5\u000bV'\n\u0005iZ$a\u0002,feNLwN\u001c\u0006\u0003q\tAQ!\u0010\u0001\u0005\u0002y\na\u0001P5oSRtD\u0003B A\u0003\u001e\u0003\"\u0001\n\u0001\t\u000bQa\u0004\u0019A\f\t\u000bya\u0004\u0019\u0001\"\u0011\u0007a\u00013\t\r\u0002E\rB\u0019A%J#\u0011\u0005!2E!\u0003\u0016=\u0003\u0003\u0005\tQ!\u0001,\u0011\u0015\u0019D\b1\u00015\u0011\u0015I\u0005\u0001\"\u0001K\u0003)\tw/Y5u%\u0016$(/\u001f\u000b\u0003\u0017:\u0003\"\u0001\u0007'\n\u00055C!\u0001\u0002'p]\u001eDQa\u0014%A\u0002-\u000bA\u0002^5nK>,HOT1o_ND3\u0001S)U!\tA\"+\u0003\u0002T\u0011\t1A\u000f\u001b:poN\u001c\u0013!\u0016\t\u0003-zs!a\u0016/\u000f\u0005a[V\"A-\u000b\u0005i+\u0012A\u0002\u001fs_>$h(C\u0001\n\u0013\ti\u0006\"A\u0004qC\u000e\\\u0017mZ3\n\u0005}\u0003'\u0001F%oi\u0016\u0014(/\u001e9uK\u0012,\u0005pY3qi&|gN\u0003\u0002^\u0011!)!\r\u0001C\u0005G\u0006a\u0011\r\u001e;f[B$\u0018i^1jiR\u0011Am\u001a\t\u00031\u0015L!A\u001a\u0005\u0003\u000f\t{w\u000e\\3b]\")\u0001.\u0019a\u0001\u0017\u0006aa.\u00198p\t\u0016\fG\r\\5oK\"\u001a\u0011-\u0015+\t\u000b-\u0004A\u0011\u00027\u0002)\tdwnY6j]\u001e\fE\u000f^3naR\fu/Y5u)\u0011!WN\\<\t\u000b!T\u0007\u0019A&\t\u000f=T\u0007\u0013!a\u0001a\u0006)QM^3oiB\u0011\u0011\u000f\u001e\b\u0003IIL!a\u001d\u0002\u0002\u001b]\u000b7.Z;q\u001b\u0006t\u0017mZ3s\u0013\t)hOA\u0003Fm\u0016tGO\u0003\u0002t\u0005!9\u0001P\u001bI\u0001\u0002\u00049\u0012!A5)\u0005)T\bCA>\u007f\u001b\u0005a(BA?\t\u0003)\tgN\\8uCRLwN\\\u0005\u0003\u007fr\u0014q\u0001^1jYJ,7\rK\u0002k#RCq!!\u0002\u0001\t\u0013\t9!\u0001\tbI\u0012\u0004VM\u001c3j]\u001e<\u0016m[3vaR)A-!\u0003\u0002\u0018!A\u00111BA\u0002\u0001\u0004\ti!\u0001\u0004iC:$G.\u001a\u0019\u0005\u0003\u001f\t\u0019\u0002\u0005\u0003%K\u0005E\u0001c\u0001\u0015\u0002\u0014\u0011Y\u0011QCA\u0002\u0003\u0003\u0005\tQ!\u0001,\u0005\ryFE\r\u0005\b\u00033\t\u0019\u00011\u00016\u0003\r1XM\u001d\u0015\u0004\u0003\u0007Q\bbBA\u0010\u0001\u0011%\u0011\u0011E\u0001\bG\"\fgnZ3e+\u0005!\u0007\"CA\u0013\u0001E\u0005I\u0011BA\u0014\u0003y\u0011Gn\\2lS:<\u0017\t\u001e;f[B$\u0018i^1ji\u0012\"WMZ1vYR$#'\u0006\u0002\u0002*)\u001a\u0001/a\u000b,\u0005\u00055\u0002\u0003BA\u0018\u0003ki!!!\r\u000b\u0007\u0005MB0A\u0005v]\u000eDWmY6fI&!\u0011qGA\u0019\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003w\u0001\u0011\u0013!C\u0005\u0003{\taD\u00197pG.LgnZ!ui\u0016l\u0007\u000f^!xC&$H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005}\"fA\f\u0002,\u0001")
public class RetrySet {
    private final int size;
    private final Handle<?>[] handles;
    private final long[] versions;

    public int size() {
        return this.size;
    }

    public long awaitRetry(long timeoutNanos) throws InterruptedException {
        if (this.size() == 0 && timeoutNanos == Long.MAX_VALUE) {
            throw new IllegalStateException("explicit retries cannot succeed because cumulative read set is empty");
        }
        long begin = System.nanoTime();
        long d = begin + timeoutNanos;
        long deadline = d < 0L ? Long.MAX_VALUE : d;
        boolean timeoutExceeded = !this.attemptAwait(deadline);
        long actualElapsed = System.nanoTime() - begin;
        if (Stats$.MODULE$.top() != null) {
            Stats$.MODULE$.top().retrySet().$plus$eq(this.size());
            long millis = TimeUnit.NANOSECONDS.toMillis(actualElapsed);
            Stats$.MODULE$.top().retryWaitElapsed().$plus$eq((int)millis);
        }
        return package$.MODULE$.min(actualElapsed, deadline - begin);
    }

    private boolean attemptAwait(long nanoDeadline) throws InterruptedException {
        int spins = 0;
        while (this.size() > 0 && spins < CCSTM$.MODULE$.SpinCount() + CCSTM$.MODULE$.YieldCount()) {
            if (this.changed()) {
                return true;
            }
            if ((spins += this.size()) <= CCSTM$.MODULE$.SpinCount()) continue;
            Thread.yield();
            if (nanoDeadline == Long.MAX_VALUE || System.nanoTime() <= nanoDeadline) continue;
            return false;
        }
        return this.blockingAttemptAwait(nanoDeadline, this.blockingAttemptAwait$default$2(), this.blockingAttemptAwait$default$3());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean blockingAttemptAwait(long nanoDeadline, WakeupManager.Event event, int i) throws InterruptedException {
        while (true) {
            if (i < 0) {
                if (!event.tryAwaitUntil(nanoDeadline)) return false;
                if (this.changed()) {
                    return true;
                }
                i = this.blockingAttemptAwait$default$3();
                event = this.blockingAttemptAwait$default$2();
                continue;
            }
            Handle<?> h = this.handles[i];
            if (event.addSource(h)) {
                if (!this.addPendingWakeup(h, this.versions[i])) return true;
                --i;
                continue;
            }
            if (this.changed()) {
                return true;
            }
            i = this.blockingAttemptAwait$default$3();
            event = this.blockingAttemptAwait$default$2();
        }
    }

    private WakeupManager.Event blockingAttemptAwait$default$2() {
        return CCSTM$.MODULE$.wakeupManager().subscribe();
    }

    private int blockingAttemptAwait$default$3() {
        return this.size() - 1;
    }

    private boolean addPendingWakeup(Handle<?> handle, long ver) {
        boolean bl;
        block1: {
            long m;
            do {
                if (!CCSTM$.MODULE$.changing(m = handle.meta()) && CCSTM$.MODULE$.version(m) == ver) continue;
                bl = false;
                break block1;
            } while (!CCSTM$.MODULE$.pendingWakeups(m) && !handle.metaCAS(m, CCSTM$.MODULE$.withPendingWakeups(m)));
            bl = true;
        }
        return bl;
    }

    private boolean changed() {
        for (int i = this.size() - 1; i >= 0; --i) {
            long m = this.handles[i].meta();
            if (!CCSTM$.MODULE$.changing(m) && CCSTM$.MODULE$.version(m) == this.versions[i]) continue;
            return true;
        }
        return false;
    }

    public RetrySet(int size, Handle<?>[] handles, long[] versions) {
        this.size = size;
        this.handles = handles;
        this.versions = versions;
    }
}

