/*
 * Decompiled with CFR 0.152.
 */
package org.scalafmt.cli;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import java.util.Date;
import org.scalafmt.Versions$;
import org.scalafmt.cli.CliArgParser;
import org.scalafmt.cli.CliArgParser$;
import org.scalafmt.cli.CliOptions;
import org.scalafmt.cli.CommonOptions;
import org.scalafmt.cli.DiffFiles;
import org.scalafmt.cli.FileFetchMode;
import org.scalafmt.cli.FileFetchMode$;
import org.scalafmt.cli.WriteMode;
import org.scalafmt.cli.WriteMode$List$;
import org.scalafmt.cli.WriteMode$Override$;
import org.scalafmt.cli.WriteMode$Stdout$;
import org.scalafmt.cli.WriteMode$Test$;
import org.scalafmt.util.AbsoluteFile;
import org.scalafmt.util.AbsoluteFile$;
import org.scalafmt.util.GitOps;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scopt.OptionParser;
import scopt.Read$;

public final class CliArgParser$ {
    public static final CliArgParser$ MODULE$ = new CliArgParser$();
    private static final String usageExamples = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|scalafmt # Format all files in the current project, configuration is determined in this order:\n      |         # 1. .scalafmt.conf file in current directory\n      |         # 2. .scalafmt.conf inside root directory of current git repo\n      |         # 3. no configuration, default style\n      |scalafmt --test # throw exception on mis-formatted files, won't write to files.\n      |scalafmt --mode diff # Format all files that were edited in git diff against master branch.\n      |scalafmt --mode changed # Format files listed in `git status` (latest changes against previous commit.\n      |scalafmt --diff-branch 2.x # same as --diff, except against branch 2.x\n      |scalafmt --stdin # read from stdin and print to stdout\n      |scalafmt --stdin --assume-filename foo.sbt < foo.sbt # required when using --stdin to format .sbt files.\n      |scalafmt Code1.scala A.scala       # write formatted contents to file.\n      |scalafmt --stdout Code.scala       # print formatted contents to stdout.\n      |scalafmt --exclude target          # format all files in directory excluding target\n      |scalafmt --config .scalafmt.conf   # read custom style from file.\n      |scalafmt --config-str \"style=IntelliJ\" # define custom style as a flag, must be quoted."));
    private static final OptionParser<CliOptions> scoptParser = new OptionParser<CliOptions>(){

        public boolean showUsageOnError() {
            return false;
        }

        private CliOptions printAndExit(boolean inludeUsage, BoxedUnit ignore, CliOptions c) {
            if (inludeUsage) {
                this.showUsage();
            } else {
                this.showHeader();
            }
            throw scala.sys.package$.MODULE$.exit();
        }

        private CliOptions readConfig(String contents, CliOptions c) {
            Some x$1 = new Some((Object)contents);
            Option<Path> x$2 = c.copy$default$1();
            Set<Range> x$3 = c.copy$default$3();
            Seq<AbsoluteFile> x$4 = c.copy$default$4();
            Seq<String> x$5 = c.copy$default$5();
            boolean x$6 = c.copy$default$6();
            Option<Object> x$7 = c.copy$default$7();
            boolean x$8 = c.copy$default$8();
            Option<FileFetchMode> x$9 = c.copy$default$9();
            String x$10 = c.copy$default$10();
            Option<AbsoluteFile> x$11 = c.copy$default$11();
            CommonOptions x$12 = c.copy$default$12();
            Function1<AbsoluteFile, GitOps> x$13 = c.copy$default$13();
            Option<WriteMode> x$14 = c.copy$default$14();
            boolean x$15 = c.copy$default$15();
            boolean x$16 = c.copy$default$16();
            boolean x$17 = c.copy$default$17();
            boolean x$18 = c.copy$default$18();
            boolean x$19 = c.copy$default$19();
            boolean x$20 = c.copy$default$20();
            return c.copy(x$2, (Option<String>)x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        }

        private CliOptions readConfigFromFile(String file, CliOptions c) {
            AbsoluteFile configFile = AbsoluteFile$.MODULE$.fromFile(new File(file), c.common().workingDirectory());
            return c.copy((Option<Path>)new Some((Object)configFile.jfile().toPath()), c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8(), c.copy$default$9(), c.copy$default$10(), c.copy$default$11(), c.copy$default$12(), c.copy$default$13(), c.copy$default$14(), c.copy$default$15(), c.copy$default$16(), c.copy$default$17(), c.copy$default$18(), c.copy$default$19(), c.copy$default$20());
        }

        private CliOptions addFile(File file, CliOptions c) {
            AbsoluteFile absFile = AbsoluteFile$.MODULE$.fromFile(file, c.common().workingDirectory());
            Seq x$1 = (Seq)c.customFiles().$colon$plus((Object)absFile);
            Option<Path> x$2 = c.copy$default$1();
            Option<String> x$3 = c.copy$default$2();
            Set<Range> x$4 = c.copy$default$3();
            Seq<String> x$5 = c.copy$default$5();
            boolean x$6 = c.copy$default$6();
            Option<Object> x$7 = c.copy$default$7();
            boolean x$8 = c.copy$default$8();
            Option<FileFetchMode> x$9 = c.copy$default$9();
            String x$10 = c.copy$default$10();
            Option<AbsoluteFile> x$11 = c.copy$default$11();
            CommonOptions x$12 = c.copy$default$12();
            Function1<AbsoluteFile, GitOps> x$13 = c.copy$default$13();
            Option<WriteMode> x$14 = c.copy$default$14();
            boolean x$15 = c.copy$default$15();
            boolean x$16 = c.copy$default$16();
            boolean x$17 = c.copy$default$17();
            boolean x$18 = c.copy$default$18();
            boolean x$19 = c.copy$default$19();
            boolean x$20 = c.copy$default$20();
            return c.copy(x$2, x$3, x$4, (Seq<AbsoluteFile>)x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        }

        public static final /* synthetic */ CliOptions $anonfun$new$7(boolean opt, CliOptions c) {
            Some x$21 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)opt));
            Option<Path> x$22 = c.copy$default$1();
            Option<String> x$23 = c.copy$default$2();
            Set<Range> x$24 = c.copy$default$3();
            Seq<AbsoluteFile> x$25 = c.copy$default$4();
            Seq<String> x$26 = c.copy$default$5();
            boolean x$27 = c.copy$default$6();
            boolean x$28 = c.copy$default$8();
            Option<FileFetchMode> x$29 = c.copy$default$9();
            String x$30 = c.copy$default$10();
            Option<AbsoluteFile> x$31 = c.copy$default$11();
            CommonOptions x$32 = c.copy$default$12();
            Function1<AbsoluteFile, GitOps> x$33 = c.copy$default$13();
            Option<WriteMode> x$34 = c.copy$default$14();
            boolean x$35 = c.copy$default$15();
            boolean x$36 = c.copy$default$16();
            boolean x$37 = c.copy$default$17();
            boolean x$38 = c.copy$default$18();
            boolean x$39 = c.copy$default$19();
            boolean x$40 = c.copy$default$20();
            return c.copy(x$22, x$23, x$24, x$25, x$26, x$27, (Option<Object>)x$21, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40);
        }
        {
            this.head((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"scalafmt", Versions$.MODULE$.nightly()}));
            this.opt('h', "help", Read$.MODULE$.unitRead()).action((Function2 & Serializable)(ignore, c) -> this.printAndExit(true, (BoxedUnit)ignore, (CliOptions)c)).text("prints this usage text");
            this.opt('v', "version", Read$.MODULE$.unitRead()).action((Function2 & Serializable)(ignore, c) -> this.printAndExit(false, (BoxedUnit)ignore, (CliOptions)c)).text("print version ");
            this.arg("<file>...", Read$.MODULE$.fileRead()).optional().unbounded().action((Function2 & Serializable)(file, c) -> this.addFile((File)file, (CliOptions)c)).text(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("file, or directory (in which all *.scala files are to be formatted);\n            |if starts with '@', refers to path listing files to be formatted\n            |(with \"@-\" referring to standard input as a special case)")));
            this.opt('f', "files", Read$.MODULE$.immutableSeqRead(Read$.MODULE$.fileRead())).action((Function2 & Serializable)(files, c) -> {
                Seq x$1 = AbsoluteFile$.MODULE$.fromFiles(files, c.common().workingDirectory());
                Option<Path> x$2 = c.copy$default$1();
                Option<String> x$3 = c.copy$default$2();
                Set<Range> x$4 = c.copy$default$3();
                Seq<String> x$5 = c.copy$default$5();
                boolean x$6 = c.copy$default$6();
                Option<Object> x$7 = c.copy$default$7();
                boolean x$8 = c.copy$default$8();
                Option<FileFetchMode> x$9 = c.copy$default$9();
                String x$10 = c.copy$default$10();
                Option<AbsoluteFile> x$11 = c.copy$default$11();
                CommonOptions x$12 = c.copy$default$12();
                Function1<AbsoluteFile, GitOps> x$13 = c.copy$default$13();
                Option<WriteMode> x$14 = c.copy$default$14();
                boolean x$15 = c.copy$default$15();
                boolean x$16 = c.copy$default$16();
                boolean x$17 = c.copy$default$17();
                boolean x$18 = c.copy$default$18();
                boolean x$19 = c.copy$default$19();
                boolean x$20 = c.copy$default$20();
                return c.copy(x$2, x$3, x$4, (Seq<AbsoluteFile>)x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
            }).hidden().text("file or directory, in which case all *.scala files are formatted. Deprecated: pass files as arguments");
            this.opt('i', "in-place", Read$.MODULE$.unitRead()).action((Function2 & Serializable)(x$1, c) -> CliArgParser$.MODULE$.org$scalafmt$cli$CliArgParser$$writeMode((CliOptions)c, WriteMode$Override$.MODULE$)).hidden().text("format files in-place (default)");
            this.opt("stdout", Read$.MODULE$.unitRead()).action((Function2 & Serializable)(x$2, c) -> CliArgParser$.MODULE$.org$scalafmt$cli$CliArgParser$$writeMode((CliOptions)c, WriteMode$Stdout$.MODULE$)).text("write formatted files to stdout");
            this.opt("git", Read$.MODULE$.booleanRead()).action((Function2 & Serializable)(opt, c) -> anon.1.$anonfun$new$7(BoxesRunTime.unboxToBoolean((Object)opt), c)).text("if true, ignore files in .gitignore (default false)");
            this.opt("exclude", Read$.MODULE$.immutableSeqRead(Read$.MODULE$.stringRead())).unbounded().action((Function2 & Serializable)(excludes, c) -> {
                Seq x$41 = excludes;
                Option<Path> x$42 = c.copy$default$1();
                Option<String> x$43 = c.copy$default$2();
                Set<Range> x$44 = c.copy$default$3();
                Seq<AbsoluteFile> x$45 = c.copy$default$4();
                boolean x$46 = c.copy$default$6();
                Option<Object> x$47 = c.copy$default$7();
                boolean x$48 = c.copy$default$8();
                Option<FileFetchMode> x$49 = c.copy$default$9();
                String x$50 = c.copy$default$10();
                Option<AbsoluteFile> x$51 = c.copy$default$11();
                CommonOptions x$52 = c.copy$default$12();
                Function1<AbsoluteFile, GitOps> x$53 = c.copy$default$13();
                Option<WriteMode> x$54 = c.copy$default$14();
                boolean x$55 = c.copy$default$15();
                boolean x$56 = c.copy$default$16();
                boolean x$57 = c.copy$default$17();
                boolean x$58 = c.copy$default$18();
                boolean x$59 = c.copy$default$19();
                boolean x$60 = c.copy$default$20();
                return c.copy(x$42, x$43, x$44, x$45, (Seq<String>)x$41, x$46, x$47, x$48, x$49, x$50, x$51, x$52, x$53, x$54, x$55, x$56, x$57, x$58, x$59, x$60);
            }).text("file or directory, when missing all *.scala files are formatted.");
            this.opt("respect-project-filters", Read$.MODULE$.unitRead()).action((Function2 & Serializable)(x$3, c) -> {
                boolean x$61 = true;
                Option<Path> x$62 = c.copy$default$1();
                Option<String> x$63 = c.copy$default$2();
                Set<Range> x$64 = c.copy$default$3();
                Seq<AbsoluteFile> x$65 = c.copy$default$4();
                Seq<String> x$66 = c.copy$default$5();
                Option<Object> x$67 = c.copy$default$7();
                boolean x$68 = c.copy$default$8();
                Option<FileFetchMode> x$69 = c.copy$default$9();
                String x$70 = c.copy$default$10();
                Option<AbsoluteFile> x$71 = c.copy$default$11();
                CommonOptions x$72 = c.copy$default$12();
                Function1<AbsoluteFile, GitOps> x$73 = c.copy$default$13();
                Option<WriteMode> x$74 = c.copy$default$14();
                boolean x$75 = c.copy$default$15();
                boolean x$76 = c.copy$default$16();
                boolean x$77 = c.copy$default$17();
                boolean x$78 = c.copy$default$18();
                boolean x$79 = c.copy$default$19();
                boolean x$80 = c.copy$default$20();
                return c.copy(x$62, x$63, x$64, x$65, x$66, true, x$67, x$68, x$69, x$70, x$71, x$72, x$73, x$74, x$75, x$76, x$77, x$78, x$79, x$80);
            }).text("use project filters even when specific files to format are provided");
            this.opt('c', "config", Read$.MODULE$.stringRead()).action((Function2 & Serializable)(file, c) -> this.readConfigFromFile((String)file, (CliOptions)c)).text("a file path to .scalafmt.conf.");
            this.opt("config-str", Read$.MODULE$.stringRead()).action((Function2 & Serializable)(contents, c) -> this.readConfig((String)contents, (CliOptions)c)).text("configuration defined as a string");
            this.opt("stdin", Read$.MODULE$.unitRead()).action((Function2 & Serializable)(x$4, c) -> {
                boolean x$81 = true;
                Option<Path> x$82 = c.copy$default$1();
                Option<String> x$83 = c.copy$default$2();
                Set<Range> x$84 = c.copy$default$3();
                Seq<AbsoluteFile> x$85 = c.copy$default$4();
                Seq<String> x$86 = c.copy$default$5();
                boolean x$87 = c.copy$default$6();
                Option<Object> x$88 = c.copy$default$7();
                boolean x$89 = c.copy$default$8();
                Option<FileFetchMode> x$90 = c.copy$default$9();
                String x$91 = c.copy$default$10();
                Option<AbsoluteFile> x$92 = c.copy$default$11();
                CommonOptions x$93 = c.copy$default$12();
                Function1<AbsoluteFile, GitOps> x$94 = c.copy$default$13();
                Option<WriteMode> x$95 = c.copy$default$14();
                boolean x$96 = c.copy$default$15();
                boolean x$97 = c.copy$default$16();
                boolean x$98 = c.copy$default$18();
                boolean x$99 = c.copy$default$19();
                boolean x$100 = c.copy$default$20();
                return c.copy(x$82, x$83, x$84, x$85, x$86, x$87, x$88, x$89, x$90, x$91, x$92, x$93, x$94, x$95, x$96, x$97, true, x$98, x$99, x$100);
            }).text("read from stdin and print to stdout");
            this.opt("no-stderr", Read$.MODULE$.unitRead()).action((Function2 & Serializable)(x$5, c) -> {
                boolean x$101 = true;
                Option<Path> x$102 = c.copy$default$1();
                Option<String> x$103 = c.copy$default$2();
                Set<Range> x$104 = c.copy$default$3();
                Seq<AbsoluteFile> x$105 = c.copy$default$4();
                Seq<String> x$106 = c.copy$default$5();
                boolean x$107 = c.copy$default$6();
                Option<Object> x$108 = c.copy$default$7();
                boolean x$109 = c.copy$default$8();
                Option<FileFetchMode> x$110 = c.copy$default$9();
                String x$111 = c.copy$default$10();
                Option<AbsoluteFile> x$112 = c.copy$default$11();
                CommonOptions x$113 = c.copy$default$12();
                Function1<AbsoluteFile, GitOps> x$114 = c.copy$default$13();
                Option<WriteMode> x$115 = c.copy$default$14();
                boolean x$116 = c.copy$default$15();
                boolean x$117 = c.copy$default$16();
                boolean x$118 = c.copy$default$17();
                boolean x$119 = c.copy$default$19();
                boolean x$120 = c.copy$default$20();
                return c.copy(x$102, x$103, x$104, x$105, x$106, x$107, x$108, x$109, x$110, x$111, x$112, x$113, x$114, x$115, x$116, x$117, x$118, true, x$119, x$120);
            }).text("don't use strerr for messages, output to stdout");
            this.opt("assume-filename", Read$.MODULE$.stringRead()).action((Function2 & Serializable)(filename, c) -> {
                String x$121 = filename;
                Option<Path> x$122 = c.copy$default$1();
                Option<String> x$123 = c.copy$default$2();
                Set<Range> x$124 = c.copy$default$3();
                Seq<AbsoluteFile> x$125 = c.copy$default$4();
                Seq<String> x$126 = c.copy$default$5();
                boolean x$127 = c.copy$default$6();
                Option<Object> x$128 = c.copy$default$7();
                boolean x$129 = c.copy$default$8();
                Option<FileFetchMode> x$130 = c.copy$default$9();
                Option<AbsoluteFile> x$131 = c.copy$default$11();
                CommonOptions x$132 = c.copy$default$12();
                Function1<AbsoluteFile, GitOps> x$133 = c.copy$default$13();
                Option<WriteMode> x$134 = c.copy$default$14();
                boolean x$135 = c.copy$default$15();
                boolean x$136 = c.copy$default$16();
                boolean x$137 = c.copy$default$17();
                boolean x$138 = c.copy$default$18();
                boolean x$139 = c.copy$default$19();
                boolean x$140 = c.copy$default$20();
                return c.copy(x$122, x$123, x$124, x$125, x$126, x$127, x$128, x$129, x$130, x$121, x$131, x$132, x$133, x$134, x$135, x$136, x$137, x$138, x$139, x$140);
            }).text("when using --stdin, use --assume-filename to hint to scalafmt that the input is an .sbt file.");
            this.opt("reportError", Read$.MODULE$.unitRead()).action((Function2 & Serializable)(x$6, c) -> {
                boolean x$141 = true;
                Option<Path> x$142 = c.copy$default$1();
                Option<String> x$143 = c.copy$default$2();
                Set<Range> x$144 = c.copy$default$3();
                Seq<AbsoluteFile> x$145 = c.copy$default$4();
                Seq<String> x$146 = c.copy$default$5();
                boolean x$147 = c.copy$default$6();
                Option<Object> x$148 = c.copy$default$7();
                boolean x$149 = c.copy$default$8();
                Option<FileFetchMode> x$150 = c.copy$default$9();
                String x$151 = c.copy$default$10();
                Option<AbsoluteFile> x$152 = c.copy$default$11();
                CommonOptions x$153 = c.copy$default$12();
                Function1<AbsoluteFile, GitOps> x$154 = c.copy$default$13();
                Option<WriteMode> x$155 = c.copy$default$14();
                boolean x$156 = c.copy$default$15();
                boolean x$157 = c.copy$default$16();
                boolean x$158 = c.copy$default$17();
                boolean x$159 = c.copy$default$18();
                boolean x$160 = c.copy$default$20();
                return c.copy(x$142, x$143, x$144, x$145, x$146, x$147, x$148, x$149, x$150, x$151, x$152, x$153, x$154, x$155, x$156, x$157, x$158, x$159, true, x$160);
            }).text("exit with status 1 if any mis-formatted code found.");
            this.opt("test", Read$.MODULE$.unitRead()).action((Function2 & Serializable)(x$7, c) -> {
                CliOptions qual$1 = CliArgParser$.MODULE$.org$scalafmt$cli$CliArgParser$$writeMode((CliOptions)c, WriteMode$Test$.MODULE$);
                boolean x$161 = true;
                Option<Path> x$162 = qual$1.copy$default$1();
                Option<String> x$163 = qual$1.copy$default$2();
                Set<Range> x$164 = qual$1.copy$default$3();
                Seq<AbsoluteFile> x$165 = qual$1.copy$default$4();
                Seq<String> x$166 = qual$1.copy$default$5();
                boolean x$167 = qual$1.copy$default$6();
                Option<Object> x$168 = qual$1.copy$default$7();
                boolean x$169 = qual$1.copy$default$8();
                Option<FileFetchMode> x$170 = qual$1.copy$default$9();
                String x$171 = qual$1.copy$default$10();
                Option<AbsoluteFile> x$172 = qual$1.copy$default$11();
                CommonOptions x$173 = qual$1.copy$default$12();
                Function1<AbsoluteFile, GitOps> x$174 = qual$1.copy$default$13();
                Option<WriteMode> x$175 = qual$1.copy$default$14();
                boolean x$176 = qual$1.copy$default$15();
                boolean x$177 = qual$1.copy$default$16();
                boolean x$178 = qual$1.copy$default$17();
                boolean x$179 = qual$1.copy$default$18();
                boolean x$180 = qual$1.copy$default$20();
                return qual$1.copy(x$162, x$163, x$164, x$165, x$166, x$167, x$168, x$169, x$170, x$171, x$172, x$173, x$174, x$175, x$176, x$177, x$178, x$179, true, x$180);
            }).text("test for mis-formatted code only, exits with status 1 on failure.");
            this.opt("check", Read$.MODULE$.unitRead()).action((Function2 & Serializable)(x$8, c) -> {
                CliOptions qual$2 = CliArgParser$.MODULE$.org$scalafmt$cli$CliArgParser$$writeMode((CliOptions)c, WriteMode$Test$.MODULE$);
                boolean x$181 = true;
                boolean x$182 = true;
                Option<Path> x$183 = qual$2.copy$default$1();
                Option<String> x$184 = qual$2.copy$default$2();
                Set<Range> x$185 = qual$2.copy$default$3();
                Seq<AbsoluteFile> x$186 = qual$2.copy$default$4();
                Seq<String> x$187 = qual$2.copy$default$5();
                boolean x$188 = qual$2.copy$default$6();
                Option<Object> x$189 = qual$2.copy$default$7();
                boolean x$190 = qual$2.copy$default$8();
                Option<FileFetchMode> x$191 = qual$2.copy$default$9();
                String x$192 = qual$2.copy$default$10();
                Option<AbsoluteFile> x$193 = qual$2.copy$default$11();
                CommonOptions x$194 = qual$2.copy$default$12();
                Function1<AbsoluteFile, GitOps> x$195 = qual$2.copy$default$13();
                Option<WriteMode> x$196 = qual$2.copy$default$14();
                boolean x$197 = qual$2.copy$default$15();
                boolean x$198 = qual$2.copy$default$16();
                boolean x$199 = qual$2.copy$default$17();
                boolean x$200 = qual$2.copy$default$18();
                return qual$2.copy(x$183, x$184, x$185, x$186, x$187, x$188, x$189, x$190, x$191, x$192, x$193, x$194, x$195, x$196, x$197, x$198, x$199, x$200, true, true);
            }).text("test for mis-formatted code only, exits with status 1 on first failure.");
            this.opt("migrate2hocon", Read$.MODULE$.fileRead()).action((Function2 & Serializable)(file, c) -> {
                Some x$201 = new Some((Object)AbsoluteFile$.MODULE$.fromFile(file, c.common().workingDirectory()));
                Option<Path> x$202 = c.copy$default$1();
                Option<String> x$203 = c.copy$default$2();
                Set<Range> x$204 = c.copy$default$3();
                Seq<AbsoluteFile> x$205 = c.copy$default$4();
                Seq<String> x$206 = c.copy$default$5();
                boolean x$207 = c.copy$default$6();
                Option<Object> x$208 = c.copy$default$7();
                boolean x$209 = c.copy$default$8();
                Option<FileFetchMode> x$210 = c.copy$default$9();
                String x$211 = c.copy$default$10();
                CommonOptions x$212 = c.copy$default$12();
                Function1<AbsoluteFile, GitOps> x$213 = c.copy$default$13();
                Option<WriteMode> x$214 = c.copy$default$14();
                boolean x$215 = c.copy$default$15();
                boolean x$216 = c.copy$default$16();
                boolean x$217 = c.copy$default$17();
                boolean x$218 = c.copy$default$18();
                boolean x$219 = c.copy$default$19();
                boolean x$220 = c.copy$default$20();
                return c.copy(x$202, x$203, x$204, x$205, x$206, x$207, x$208, x$209, x$210, x$211, (Option<AbsoluteFile>)x$201, x$212, x$213, x$214, x$215, x$216, x$217, x$218, x$219, x$220);
            }).text("migrate .scalafmt CLI style configuration to hocon style configuration in .scalafmt.conf");
            this.opt("diff", Read$.MODULE$.unitRead()).action((Function2 & Serializable)(x$9, c) -> {
                Option x$221 = Option$.MODULE$.apply((Object)new DiffFiles("master"));
                Option<Path> x$222 = c.copy$default$1();
                Option<String> x$223 = c.copy$default$2();
                Set<Range> x$224 = c.copy$default$3();
                Seq<AbsoluteFile> x$225 = c.copy$default$4();
                Seq<String> x$226 = c.copy$default$5();
                boolean x$227 = c.copy$default$6();
                Option<Object> x$228 = c.copy$default$7();
                boolean x$229 = c.copy$default$8();
                String x$230 = c.copy$default$10();
                Option<AbsoluteFile> x$231 = c.copy$default$11();
                CommonOptions x$232 = c.copy$default$12();
                Function1<AbsoluteFile, GitOps> x$233 = c.copy$default$13();
                Option<WriteMode> x$234 = c.copy$default$14();
                boolean x$235 = c.copy$default$15();
                boolean x$236 = c.copy$default$16();
                boolean x$237 = c.copy$default$17();
                boolean x$238 = c.copy$default$18();
                boolean x$239 = c.copy$default$19();
                boolean x$240 = c.copy$default$20();
                return c.copy(x$222, x$223, x$224, x$225, x$226, x$227, x$228, x$229, (Option<FileFetchMode>)x$221, x$230, x$231, x$232, x$233, x$234, x$235, x$236, x$237, x$238, x$239, x$240);
            }).text(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Format files listed in `git diff` against master.\n            |Deprecated: use --mode diff instead")));
            this.opt("mode", FileFetchMode$.MODULE$.read()).action((Function2 & Serializable)(m, c) -> {
                Option x$241 = Option$.MODULE$.apply(m);
                Option<Path> x$242 = c.copy$default$1();
                Option<String> x$243 = c.copy$default$2();
                Set<Range> x$244 = c.copy$default$3();
                Seq<AbsoluteFile> x$245 = c.copy$default$4();
                Seq<String> x$246 = c.copy$default$5();
                boolean x$247 = c.copy$default$6();
                Option<Object> x$248 = c.copy$default$7();
                boolean x$249 = c.copy$default$8();
                String x$250 = c.copy$default$10();
                Option<AbsoluteFile> x$251 = c.copy$default$11();
                CommonOptions x$252 = c.copy$default$12();
                Function1<AbsoluteFile, GitOps> x$253 = c.copy$default$13();
                Option<WriteMode> x$254 = c.copy$default$14();
                boolean x$255 = c.copy$default$15();
                boolean x$256 = c.copy$default$16();
                boolean x$257 = c.copy$default$17();
                boolean x$258 = c.copy$default$18();
                boolean x$259 = c.copy$default$19();
                boolean x$260 = c.copy$default$20();
                return c.copy(x$242, x$243, x$244, x$245, x$246, x$247, x$248, x$249, (Option<FileFetchMode>)x$241, x$250, x$251, x$252, x$253, x$254, x$255, x$256, x$257, x$258, x$259, x$260);
            }).text(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Sets the files to be formatted fetching mode.\n            |Options:\n            |        diff - format files listed in `git diff` against master\n            |        changed - format files listed in `git status` (latest changes against previous commit)")));
            this.opt("diff-branch", Read$.MODULE$.stringRead()).action((Function2 & Serializable)(branch, c) -> {
                Option x$261 = Option$.MODULE$.apply((Object)new DiffFiles((String)branch));
                Option<Path> x$262 = c.copy$default$1();
                Option<String> x$263 = c.copy$default$2();
                Set<Range> x$264 = c.copy$default$3();
                Seq<AbsoluteFile> x$265 = c.copy$default$4();
                Seq<String> x$266 = c.copy$default$5();
                boolean x$267 = c.copy$default$6();
                Option<Object> x$268 = c.copy$default$7();
                boolean x$269 = c.copy$default$8();
                String x$270 = c.copy$default$10();
                Option<AbsoluteFile> x$271 = c.copy$default$11();
                CommonOptions x$272 = c.copy$default$12();
                Function1<AbsoluteFile, GitOps> x$273 = c.copy$default$13();
                Option<WriteMode> x$274 = c.copy$default$14();
                boolean x$275 = c.copy$default$15();
                boolean x$276 = c.copy$default$16();
                boolean x$277 = c.copy$default$17();
                boolean x$278 = c.copy$default$18();
                boolean x$279 = c.copy$default$19();
                boolean x$280 = c.copy$default$20();
                return c.copy(x$262, x$263, x$264, x$265, x$266, x$267, x$268, x$269, (Option<FileFetchMode>)x$261, x$270, x$271, x$272, x$273, x$274, x$275, x$276, x$277, x$278, x$279, x$280);
            }).text("If set, only format edited files in git diff against provided branch. Has no effect if mode set to `changed`.");
            this.opt("build-info", Read$.MODULE$.unitRead()).action((Function2 & Serializable)(x$10, x$11) -> {
                Predef$.MODULE$.println((Object)CliArgParser$.MODULE$.buildInfo());
                return scala.sys.package$.MODULE$.exit();
            }).text("prints build information");
            this.opt("quiet", Read$.MODULE$.unitRead()).action((Function2 & Serializable)(x$12, c) -> {
                boolean x$281 = true;
                Option<Path> x$282 = c.copy$default$1();
                Option<String> x$283 = c.copy$default$2();
                Set<Range> x$284 = c.copy$default$3();
                Seq<AbsoluteFile> x$285 = c.copy$default$4();
                Seq<String> x$286 = c.copy$default$5();
                boolean x$287 = c.copy$default$6();
                Option<Object> x$288 = c.copy$default$7();
                boolean x$289 = c.copy$default$8();
                Option<FileFetchMode> x$290 = c.copy$default$9();
                String x$291 = c.copy$default$10();
                Option<AbsoluteFile> x$292 = c.copy$default$11();
                CommonOptions x$293 = c.copy$default$12();
                Function1<AbsoluteFile, GitOps> x$294 = c.copy$default$13();
                Option<WriteMode> x$295 = c.copy$default$14();
                boolean x$296 = c.copy$default$15();
                boolean x$297 = c.copy$default$17();
                boolean x$298 = c.copy$default$18();
                boolean x$299 = c.copy$default$19();
                boolean x$300 = c.copy$default$20();
                return c.copy(x$282, x$283, x$284, x$285, x$286, x$287, x$288, x$289, x$290, x$291, x$292, x$293, x$294, x$295, x$296, true, x$297, x$298, x$299, x$300);
            }).text("don't print out stuff to console.");
            this.opt("debug", Read$.MODULE$.unitRead()).action((Function2 & Serializable)(x$13, c) -> {
                boolean x$301 = true;
                Option<Path> x$302 = c.copy$default$1();
                Option<String> x$303 = c.copy$default$2();
                Set<Range> x$304 = c.copy$default$3();
                Seq<AbsoluteFile> x$305 = c.copy$default$4();
                Seq<String> x$306 = c.copy$default$5();
                boolean x$307 = c.copy$default$6();
                Option<Object> x$308 = c.copy$default$7();
                boolean x$309 = c.copy$default$8();
                Option<FileFetchMode> x$310 = c.copy$default$9();
                String x$311 = c.copy$default$10();
                Option<AbsoluteFile> x$312 = c.copy$default$11();
                CommonOptions x$313 = c.copy$default$12();
                Function1<AbsoluteFile, GitOps> x$314 = c.copy$default$13();
                Option<WriteMode> x$315 = c.copy$default$14();
                boolean x$316 = c.copy$default$16();
                boolean x$317 = c.copy$default$17();
                boolean x$318 = c.copy$default$18();
                boolean x$319 = c.copy$default$19();
                boolean x$320 = c.copy$default$20();
                return c.copy(x$302, x$303, x$304, x$305, x$306, x$307, x$308, x$309, x$310, x$311, x$312, x$313, x$314, x$315, true, x$316, x$317, x$318, x$319, x$320);
            }).text("print out diagnostics to console.");
            this.opt("non-interactive", Read$.MODULE$.unitRead()).action((Function2 & Serializable)(x$14, c) -> {
                boolean x$321 = true;
                Option<Path> x$322 = c.copy$default$1();
                Option<String> x$323 = c.copy$default$2();
                Set<Range> x$324 = c.copy$default$3();
                Seq<AbsoluteFile> x$325 = c.copy$default$4();
                Seq<String> x$326 = c.copy$default$5();
                boolean x$327 = c.copy$default$6();
                Option<Object> x$328 = c.copy$default$7();
                Option<FileFetchMode> x$329 = c.copy$default$9();
                String x$330 = c.copy$default$10();
                Option<AbsoluteFile> x$331 = c.copy$default$11();
                CommonOptions x$332 = c.copy$default$12();
                Function1<AbsoluteFile, GitOps> x$333 = c.copy$default$13();
                Option<WriteMode> x$334 = c.copy$default$14();
                boolean x$335 = c.copy$default$15();
                boolean x$336 = c.copy$default$16();
                boolean x$337 = c.copy$default$17();
                boolean x$338 = c.copy$default$18();
                boolean x$339 = c.copy$default$19();
                boolean x$340 = c.copy$default$20();
                return c.copy(x$322, x$323, x$324, x$325, x$326, x$327, x$328, true, x$329, x$330, x$331, x$332, x$333, x$334, x$335, x$336, x$337, x$338, x$339, x$340);
            }).text("disable fancy progress bar, useful in ci or sbt plugin.");
            this.opt("list", Read$.MODULE$.unitRead()).action((Function2 & Serializable)(x$15, c) -> {
                CliOptions qual$3 = CliArgParser$.MODULE$.org$scalafmt$cli$CliArgParser$$writeMode((CliOptions)c, WriteMode$List$.MODULE$);
                boolean x$341 = true;
                Option<Path> x$342 = qual$3.copy$default$1();
                Option<String> x$343 = qual$3.copy$default$2();
                Set<Range> x$344 = qual$3.copy$default$3();
                Seq<AbsoluteFile> x$345 = qual$3.copy$default$4();
                Seq<String> x$346 = qual$3.copy$default$5();
                boolean x$347 = qual$3.copy$default$6();
                Option<Object> x$348 = qual$3.copy$default$7();
                boolean x$349 = qual$3.copy$default$8();
                Option<FileFetchMode> x$350 = qual$3.copy$default$9();
                String x$351 = qual$3.copy$default$10();
                Option<AbsoluteFile> x$352 = qual$3.copy$default$11();
                CommonOptions x$353 = qual$3.copy$default$12();
                Function1<AbsoluteFile, GitOps> x$354 = qual$3.copy$default$13();
                Option<WriteMode> x$355 = qual$3.copy$default$14();
                boolean x$356 = qual$3.copy$default$15();
                boolean x$357 = qual$3.copy$default$16();
                boolean x$358 = qual$3.copy$default$17();
                boolean x$359 = qual$3.copy$default$18();
                boolean x$360 = qual$3.copy$default$20();
                return qual$3.copy(x$342, x$343, x$344, x$345, x$346, x$347, x$348, x$349, x$350, x$351, x$352, x$353, x$354, x$355, x$356, x$357, x$358, x$359, true, x$360);
            }).text("list files that are different from scalafmt formatting");
            this.opt("range", Read$.MODULE$.tupleRead(Read$.MODULE$.intRead(), Read$.MODULE$.intRead())).hidden().action((Function2 & Serializable)(x0$1, x1$1) -> {
                int to;
                CliOptions c;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = new Tuple2(x0$1, x1$1);
                        if (tuple22 == null) break block2;
                        tuple2 = (Tuple2)tuple22._1();
                        c = (CliOptions)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                int from = tuple2._1$mcI$sp();
                int offset = from == (to = tuple2._2$mcI$sp()) ? 0 : -1;
                Set x$361 = (Set)c.range().$plus((Object)package$.MODULE$.Range().apply(from - 1, to + offset));
                Option<Path> x$362 = c.copy$default$1();
                Option<String> x$363 = c.copy$default$2();
                Seq<AbsoluteFile> x$364 = c.copy$default$4();
                Seq<String> x$365 = c.copy$default$5();
                boolean x$366 = c.copy$default$6();
                Option<Object> x$367 = c.copy$default$7();
                boolean x$368 = c.copy$default$8();
                Option<FileFetchMode> x$369 = c.copy$default$9();
                String x$370 = c.copy$default$10();
                Option<AbsoluteFile> x$371 = c.copy$default$11();
                CommonOptions x$372 = c.copy$default$12();
                Function1<AbsoluteFile, GitOps> x$373 = c.copy$default$13();
                Option<WriteMode> x$374 = c.copy$default$14();
                boolean x$375 = c.copy$default$15();
                boolean x$376 = c.copy$default$16();
                boolean x$377 = c.copy$default$17();
                boolean x$378 = c.copy$default$18();
                boolean x$379 = c.copy$default$19();
                boolean x$380 = c.copy$default$20();
                CliOptions cliOptions = c.copy(x$362, x$363, (Set<Range>)x$361, x$364, x$365, x$366, x$367, x$368, x$369, x$370, x$371, x$372, x$373, x$374, x$375, x$376, x$377, x$378, x$379, x$380);
                return cliOptions;
            }).text("(experimental) only format line range from=to");
            this.note(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(101).append("|Examples:\n        |").append(CliArgParser$.MODULE$.usageExamples()).append("\n        |Please file bugs to https://github.com/scalameta/scalafmt/issues\n      ").toString())));
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1(org.scalafmt.cli.CliArgParser$$anon$1 scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$10(org.scalafmt.cli.CliArgParser$$anon$1 java.lang.String org.scalafmt.cli.CliOptions ), $anonfun$new$11(org.scalafmt.cli.CliArgParser$$anon$1 java.lang.String org.scalafmt.cli.CliOptions ), $anonfun$new$12(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$13(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$14(java.lang.String org.scalafmt.cli.CliOptions ), $anonfun$new$15(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$16(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$17(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$18(java.io.File org.scalafmt.cli.CliOptions ), $anonfun$new$19(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$2(org.scalafmt.cli.CliArgParser$$anon$1 scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$20(org.scalafmt.cli.FileFetchMode org.scalafmt.cli.CliOptions ), $anonfun$new$21(java.lang.String org.scalafmt.cli.CliOptions ), $anonfun$new$22(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$23(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$24(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$25(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$26(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$27(scala.Tuple2 org.scalafmt.cli.CliOptions ), $anonfun$new$3(org.scalafmt.cli.CliArgParser$$anon$1 java.io.File org.scalafmt.cli.CliOptions ), $anonfun$new$4(scala.collection.immutable.Seq org.scalafmt.cli.CliOptions ), $anonfun$new$5(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$6(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$7$adapted(java.lang.Object org.scalafmt.cli.CliOptions ), $anonfun$new$8(scala.collection.immutable.Seq org.scalafmt.cli.CliOptions ), $anonfun$new$9(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions )}, serializedLambda);
        }
    };

    public String usageExamples() {
        return usageExamples;
    }

    public OptionParser<CliOptions> scoptParser() {
        return scoptParser;
    }

    public String buildInfo() {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(34).append("build commit: ").append(Versions$.MODULE$.commit()).append("\n      |build time: ").append(new Date(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(Versions$.MODULE$.timestamp())))).toString()));
    }

    public CliOptions org$scalafmt$cli$CliArgParser$$writeMode(CliOptions c, WriteMode writeMode) {
        return (CliOptions)c.writeModeOpt().fold((Function0 & Serializable)() -> {
            Some x$1 = new Some((Object)writeMode);
            Option<Path> x$2 = c.copy$default$1();
            Option<String> x$3 = c.copy$default$2();
            Set<Range> x$4 = c.copy$default$3();
            Seq<AbsoluteFile> x$5 = c.copy$default$4();
            Seq<String> x$6 = c.copy$default$5();
            boolean x$7 = c.copy$default$6();
            Option<Object> x$8 = c.copy$default$7();
            boolean x$9 = c.copy$default$8();
            Option<FileFetchMode> x$10 = c.copy$default$9();
            String x$11 = c.copy$default$10();
            Option<AbsoluteFile> x$12 = c.copy$default$11();
            CommonOptions x$13 = c.copy$default$12();
            Function1<AbsoluteFile, GitOps> x$14 = c.copy$default$13();
            boolean x$15 = c.copy$default$15();
            boolean x$16 = c.copy$default$16();
            boolean x$17 = c.copy$default$17();
            boolean x$18 = c.copy$default$18();
            boolean x$19 = c.copy$default$19();
            boolean x$20 = c.copy$default$20();
            return c.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<WriteMode>)x$1, x$15, x$16, x$17, x$18, x$19, x$20);
        }, (Function1 & Serializable)x -> {
            WriteMode writeMode = x;
            WriteMode writeMode2 = writeMode;
            if (writeMode == null ? writeMode2 != null : !writeMode.equals(writeMode2)) {
                throw new CliArgParser.Conflict(new StringBuilder(28).append("writeMode changing from ").append(x).append(" to ").append(writeMode).toString());
            }
            return c;
        });
    }

    private CliArgParser$() {
    }
}

