/*
 * Decompiled with CFR 0.152.
 */
package org.scalafmt.util;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.scalafmt.util.AbsoluteFile;
import org.scalafmt.util.AbsoluteFile$;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayOps;
import scala.io.Codec;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class FileOps$ {
    public static FileOps$ MODULE$;

    static {
        new FileOps$();
    }

    public File makeAbsolute(File workingDir, File file) {
        return file.isAbsolute() ? file : new File(workingDir, file.getPath());
    }

    public Vector<String> listFiles(String path) {
        return this.listFiles(new File(path));
    }

    public Vector<AbsoluteFile> listFiles(AbsoluteFile file) {
        return (Vector)this.listFiles(file.jfile()).map((Function1 & Serializable & scala.Serializable)x -> AbsoluteFile$.MODULE$.fromFile(new File((String)x), file), Vector$.MODULE$.canBuildFrom());
    }

    public Vector<String> listFiles(File file) {
        return file.isFile() ? (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{file.getAbsolutePath()})) : (Vector)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)FileOps$.listFilesIter$1(file))).toVector().flatMap((Function1 & Serializable & scala.Serializable)f0 -> (Iterable)f0.map((Function1 & Serializable & scala.Serializable)filename -> filename, Iterable$.MODULE$.canBuildFrom()), Vector$.MODULE$.canBuildFrom());
    }

    public String readFile(String filename, Codec codec) {
        return filename.matches("https?://.*") ? Source$.MODULE$.fromURL(filename, Codec$.MODULE$.string2codec("UTF-8")).getLines().mkString("\n") : this.readFile(new File(filename), codec);
    }

    public String readFile(AbsoluteFile file, Codec codec) {
        return this.readFile(file.jfile(), codec);
    }

    public String readFile(File file, Codec codec) {
        return new String(Files.readAllBytes(file.toPath()), codec.charSet());
    }

    public File getFile(Seq<String> path) {
        return new File(path.mkString(File.separator));
    }

    public void writeFile(AbsoluteFile file, String content, Codec codec) {
        this.writeFile(file.jfile(), content, codec);
    }

    public void writeFile(File file, String content, Codec codec) {
        this.writeFile(file.toPath(), content, codec);
    }

    public void writeFile(Path path, String content, Codec codec) {
        byte[] bytes = content.getBytes(codec.charSet());
        Files.write(path, bytes, new OpenOption[0]);
    }

    public void writeFile(String filename, String content, Codec codec) {
        this.writeFile(Paths.get(filename, new String[0]), content, codec);
    }

    private static final Iterable listFilesIter$1(File s2) {
        Tuple2 tuple2 = ((TraversableLike)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)s2.listFiles())).toIterable().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$1)).toIterator(), Iterable$.MODULE$.canBuildFrom())).partition((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isDirectory()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterable dirs = (Iterable)tuple2._1();
        Iterable files = (Iterable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)dirs, (Object)files);
        Tuple2 tuple23 = tuple22;
        Iterable dirs2 = (Iterable)tuple23._1();
        Iterable files2 = (Iterable)tuple23._2();
        return (Iterable)((TraversableLike)files2.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getPath(), Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)dirs2.flatMap((Function1 & Serializable & scala.Serializable)s -> FileOps$.listFilesIter$1(s), Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    private FileOps$() {
        MODULE$ = this;
    }
}

