/*
 * Decompiled with CFR 0.152.
 */
package org.scalafmt.internal;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.scalafmt.config.ScalafmtConfig;
import org.scalafmt.internal.ActualIndent;
import org.scalafmt.internal.FormatToken;
import org.scalafmt.internal.PolicySummary;
import org.scalafmt.internal.PolicySummary$;
import org.scalafmt.internal.Split;
import org.scalafmt.internal.State;
import org.scalafmt.util.TreeOps$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple11;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.math.package$;
import scala.meta.Term;
import scala.meta.Tree;
import scala.meta.Tree$;
import scala.meta.tokens.Token;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class State$
implements Serializable {
    public static final State$ MODULE$ = new State$();
    private static final State start = new State(0, PolicySummary$.MODULE$.empty(), null, 0, null, 0, (Seq<ActualIndent>)((Seq)Seq$.MODULE$.empty()), 0, false, 0, false);
    private static final Pattern stripMarginPattern = Pattern.compile("\n(\\h*+\\|)?([^\n]*+)");

    public State start() {
        return start;
    }

    private Pattern stripMarginPattern() {
        return stripMarginPattern;
    }

    public Tuple2<Object, Object> getColumns(FormatToken ft, int indent, Option<Object> noBreakColumn, ScalafmtConfig style) {
        Tuple2.mcII.sp sp2;
        int firstLineOffset = BoxesRunTime.unboxToInt((Object)noBreakColumn.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> indent));
        String syntax = ft.meta().right().text();
        int firstNewline = ft.meta().right().firstNL();
        if (firstNewline == -1) {
            int firstLineLength = firstLineOffset + syntax.length();
            sp2 = new Tuple2.mcII.sp(firstLineLength, firstLineLength);
        } else {
            Tuple2.mcII.sp sp3;
            Token token = ft.right();
            if (token instanceof Token.Constant$.String) {
                sp3 = this.getColumnsWithStripMargin(syntax, firstNewline, indent, noBreakColumn, style);
            } else {
                int lastNewline = syntax.length() - syntax.lastIndexOf(10) - 1;
                sp3 = new Tuple2.mcII.sp(firstLineOffset + firstNewline, lastNewline);
            }
            sp2 = sp3;
        }
        return sp2;
    }

    private Tuple2<Object, Object> getColumnsWithStripMargin(String syntax, int firstNewline, int indent, Option<Object> noBreakColumn, ScalafmtConfig style) {
        Tuple2.mcII.sp sp2;
        int column = BoxesRunTime.unboxToInt((Object)noBreakColumn.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> indent));
        Matcher matcher = this.stripMarginPattern().matcher(syntax);
        matcher.region(firstNewline, syntax.length());
        int firstLineLength = column + firstNewline;
        if (!matcher.find()) {
            sp2 = new Tuple2.mcII.sp(firstLineLength, firstLineLength);
        } else {
            Function1<Matcher, Object> matcherToLength = this.getMatcherToLength(column, indent, style);
            sp2 = this.iter$1(firstLineLength, matcherToLength, matcher);
        }
        return sp2;
    }

    private Function1<Matcher, Object> getMatcherToLength(int column, int indent, ScalafmtConfig style) {
        JFunction1.mcII.sp & Serializable intersect;
        if (!style.assumeStandardLibraryStripMargin()) {
            intersect = (JFunction1.mcII.sp & Serializable)x -> BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToInteger((int)x)));
        } else {
            int adjusted = 3 + (style.align().stripMargin() ? column : indent);
            intersect = (JFunction1.mcII.sp & Serializable)x$6 -> adjusted;
        }
        JFunction1.mcII.sp & Serializable adjustMargin = intersect;
        return arg_0 -> State$.$anonfun$getMatcherToLength$3$adapted((Function1)adjustMargin, arg_0);
    }

    public boolean org$scalafmt$internal$State$$allowSplitForLineStart(Split split, FormatToken ft, boolean isComment) {
        return (split.length() == 0 || isComment || scala.meta.package$.MODULE$.XtensionClassifiable((Object)ft.meta().leftOwner(), Tree$.MODULE$.classifiable()).is(Term.Assign$.MODULE$.ClassifierClass())) && !split.modExt().indents().exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.hasStateColumn()));
    }

    public boolean org$scalafmt$internal$State$$isInterpolation(Tree tree) {
        return scala.meta.package$.MODULE$.XtensionClassifiable((Object)tree, Tree$.MODULE$.classifiable()).is(Term.Interpolate$.MODULE$.ClassifierClass());
    }

    public boolean org$scalafmt$internal$State$$isWithinInterpolation(Tree tree2) {
        return TreeOps$.MODULE$.findTreeOrParentSimple(tree2, TreeOps$.MODULE$.findTreeOrParentSimple$default$2(), (Function1<Tree, Object>)(Function1 & Serializable)tree -> BoxesRunTime.boxToBoolean((boolean)State$.MODULE$.org$scalafmt$internal$State$$isInterpolation(tree))).isDefined();
    }

    public State apply(int cost, PolicySummary policy2, Split split, int depth, State prev, int indentation, Seq<ActualIndent> pushes, int column, boolean allAltAreNL, int delayedPenalty, boolean formatOff) {
        return new State(cost, policy2, split, depth, prev, indentation, pushes, column, allAltAreNL, delayedPenalty, formatOff);
    }

    public Option<Tuple11<Object, PolicySummary, Split, Object, State, Object, Seq<ActualIndent>, Object, Object, Object, Object>> unapply(State x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple11((Object)BoxesRunTime.boxToInteger((int)x$0.cost()), (Object)x$0.policy(), (Object)x$0.split(), (Object)BoxesRunTime.boxToInteger((int)x$0.depth()), (Object)x$0.prev(), (Object)BoxesRunTime.boxToInteger((int)x$0.indentation()), x$0.pushes(), (Object)BoxesRunTime.boxToInteger((int)x$0.column()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.allAltAreNL()), (Object)BoxesRunTime.boxToInteger((int)x$0.delayedPenalty()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.formatOff())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(State$.class);
    }

    private final Tuple2 iter$1(int prevMaxLength, Function1 matcherToLength$1, Matcher matcher$1) {
        int maxLength;
        int length;
        while (true) {
            length = BoxesRunTime.unboxToInt((Object)matcherToLength$1.apply((Object)matcher$1));
            maxLength = package$.MODULE$.max(prevMaxLength, length);
            if (!matcher$1.find()) break;
            prevMaxLength = maxLength;
        }
        return new Tuple2.mcII.sp(maxLength, length);
    }

    public static final /* synthetic */ int $anonfun$getMatcherToLength$3(Function1 adjustMargin$1, Matcher matcher) {
        int margin = matcher.end(1) - matcher.start(1);
        int textLength = matcher.end(2) - matcher.start(2);
        return 0 == margin ? textLength : textLength + adjustMargin$1.apply$mcII$sp(margin);
    }

    private State$() {
    }

    public static final /* synthetic */ Object $anonfun$getMatcherToLength$3$adapted(Function1 adjustMargin$1, Matcher matcher) {
        return BoxesRunTime.boxToInteger((int)State$.$anonfun$getMatcherToLength$3(adjustMargin$1, matcher));
    }
}

