/*
 * Decompiled with CFR 0.152.
 */
package org.scalafmt.internal;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.scalafmt.CompatCollections$;
import org.scalafmt.internal.FormatToken;
import org.scalafmt.internal.FormatWriter;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.meta.Ctor;
import scala.meta.Defn;
import scala.meta.Pat;
import scala.meta.Pkg;
import scala.meta.Term;
import scala.meta.Tree;
import scala.meta.Type;
import scala.meta.tokens.Token;
import scala.meta.tokens.Token$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class FormatWriter$ {
    public static final FormatWriter$ MODULE$ = new FormatWriter$();
    private static final IndexedSeq<String> indentations;
    private static final IndexedSeq<String> extraNewlines;
    private static final Pattern trailingSpace;
    private static final Pattern org$scalafmt$internal$FormatWriter$$slcDelim;
    private static final Pattern org$scalafmt$internal$FormatWriter$$mlcHeader;
    private static final Pattern org$scalafmt$internal$FormatWriter$$mlcLineDelim;
    private static final Pattern org$scalafmt$internal$FormatWriter$$mlcParagraphEnd;
    private static final Pattern org$scalafmt$internal$FormatWriter$$mlcParagraphBeg;
    private static final Pattern org$scalafmt$internal$FormatWriter$$leadingAsteriskSpace;
    private static final Pattern org$scalafmt$internal$FormatWriter$$docstringLine;
    private static final Pattern org$scalafmt$internal$FormatWriter$$onelineDocstring;
    private static final Pattern org$scalafmt$internal$FormatWriter$$docstringLeadingSpace;
    private static final Pattern org$scalafmt$internal$FormatWriter$$leadingPipeSpace;

    static {
        int size = 64;
        ArrayBuffer buf = new ArrayBuffer(size);
        buf.$plus$eq((Object)"");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), size).foreach((Function1 & Serializable)x$32 -> FormatWriter$.$anonfun$indentations$1(buf, BoxesRunTime.unboxToInt((Object)x$32)));
        indentations = buf.toIndexedSeq();
        int size2 = 4;
        ArrayBuffer buf2 = new ArrayBuffer(size2);
        buf2.$plus$eq((Object)"\n");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), size2).foreach((Function1 & Serializable)x$33 -> FormatWriter$.$anonfun$extraNewlines$1(buf2, BoxesRunTime.unboxToInt((Object)x$33)));
        extraNewlines = buf2.toIndexedSeq();
        trailingSpace = Pattern.compile("\\h++$", 8);
        org$scalafmt$internal$FormatWriter$$slcDelim = Pattern.compile("\\h++");
        org$scalafmt$internal$FormatWriter$$mlcHeader = Pattern.compile("^/\\*\\h*+(?:\n\\h*+[*]*+\\h*+)?");
        org$scalafmt$internal$FormatWriter$$mlcLineDelim = Pattern.compile("\\h*+\n\\h*+[*]*+\\h*+");
        org$scalafmt$internal$FormatWriter$$mlcParagraphEnd = Pattern.compile("[.:!?=]$");
        org$scalafmt$internal$FormatWriter$$mlcParagraphBeg = Pattern.compile("^(?:[-*@=]|\\d++[.:])");
        org$scalafmt$internal$FormatWriter$$leadingAsteriskSpace = Pattern.compile("(?<=\n)\\h*+(?=[*][^*])");
        org$scalafmt$internal$FormatWriter$$docstringLine = Pattern.compile("^(?:\\h*+\\*)?(\\h*+)(.*?)\\h*+$", 8);
        String empty = "\\h*+(\n\\h*+\\*?\\h*+)*";
        org$scalafmt$internal$FormatWriter$$onelineDocstring = Pattern.compile(new StringBuilder(35).append("^/\\*\\*").append(empty).append("([^*\n\\h](?:[^\n]*[^\n\\h])?)").append(empty).append("\\*/$").toString());
        org$scalafmt$internal$FormatWriter$$docstringLeadingSpace = Pattern.compile("^\\h++");
        org$scalafmt$internal$FormatWriter$$leadingPipeSpace = MODULE$.org$scalafmt$internal$FormatWriter$$compileStripMarginPattern('|');
    }

    public int getAlignColumn(FormatWriter.FormatLocation floc) {
        boolean useLeft = scala.meta.package$.MODULE$.XtensionClassifiable((Object)floc.formatToken().right(), Token$.MODULE$.classifiable()).is(Token.Comment$.MODULE$.classifier());
        return useLeft ? floc.state().prev().column() : floc.state().column();
    }

    private IndexedSeq<String> indentations() {
        return indentations;
    }

    public String org$scalafmt$internal$FormatWriter$$getIndentation(int len) {
        return len < this.indentations().length() ? (String)this.indentations().apply(len) : StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), len);
    }

    private IndexedSeq<String> extraNewlines() {
        return extraNewlines;
    }

    public String org$scalafmt$internal$FormatWriter$$getNewlines(int extra) {
        return extra < this.extraNewlines().length() ? (String)this.extraNewlines().apply(extra) : StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("\n"), 1 + extra);
    }

    private Pattern trailingSpace() {
        return trailingSpace;
    }

    public String org$scalafmt$internal$FormatWriter$$removeTrailingWhiteSpace(String str) {
        return this.trailingSpace().matcher(str).replaceAll("");
    }

    public Iterator<String> org$scalafmt$internal$FormatWriter$$splitAsIterator(Pattern regex, String value) {
        return CompatCollections$.MODULE$.JavaConverters().IteratorHasAsScala(regex.splitAsStream(value).iterator()).asScala();
    }

    public Pattern org$scalafmt$internal$FormatWriter$$slcDelim() {
        return org$scalafmt$internal$FormatWriter$$slcDelim;
    }

    public Pattern org$scalafmt$internal$FormatWriter$$mlcHeader() {
        return org$scalafmt$internal$FormatWriter$$mlcHeader;
    }

    public Pattern org$scalafmt$internal$FormatWriter$$mlcLineDelim() {
        return org$scalafmt$internal$FormatWriter$$mlcLineDelim;
    }

    public Pattern org$scalafmt$internal$FormatWriter$$mlcParagraphEnd() {
        return org$scalafmt$internal$FormatWriter$$mlcParagraphEnd;
    }

    public Pattern org$scalafmt$internal$FormatWriter$$mlcParagraphBeg() {
        return org$scalafmt$internal$FormatWriter$$mlcParagraphBeg;
    }

    public Pattern org$scalafmt$internal$FormatWriter$$leadingAsteriskSpace() {
        return org$scalafmt$internal$FormatWriter$$leadingAsteriskSpace;
    }

    public Pattern org$scalafmt$internal$FormatWriter$$docstringLine() {
        return org$scalafmt$internal$FormatWriter$$docstringLine;
    }

    public Pattern org$scalafmt$internal$FormatWriter$$onelineDocstring() {
        return org$scalafmt$internal$FormatWriter$$onelineDocstring;
    }

    public Pattern org$scalafmt$internal$FormatWriter$$docstringLeadingSpace() {
        return org$scalafmt$internal$FormatWriter$$docstringLeadingSpace;
    }

    public Pattern org$scalafmt$internal$FormatWriter$$getStripMarginPattern(char pipe) {
        return pipe == '|' ? this.org$scalafmt$internal$FormatWriter$$leadingPipeSpace() : this.org$scalafmt$internal$FormatWriter$$compileStripMarginPattern(pipe);
    }

    public Pattern org$scalafmt$internal$FormatWriter$$compileStripMarginPattern(char pipe) {
        return Pattern.compile(new StringBuilder(15).append("(?<=\n)\\h*+(?=\\").append(pipe).append(")").toString());
    }

    public Pattern org$scalafmt$internal$FormatWriter$$leadingPipeSpace() {
        return org$scalafmt$internal$FormatWriter$$leadingPipeSpace;
    }

    public String org$scalafmt$internal$FormatWriter$$getEndMarkerLabel(Tree tree) {
        String string;
        Tree tree2 = tree;
        if (tree2 instanceof Term.NewAnonymous) {
            string = "new";
        } else if (tree2 instanceof Defn.Class) {
            Defn.Class clazz = (Defn.Class)tree2;
            string = clazz.name().value();
        } else if (tree2 instanceof Defn.Object) {
            Defn.Object object = (Defn.Object)tree2;
            string = object.name().value();
        } else if (tree2 instanceof Defn.Trait) {
            Defn.Trait trait = (Defn.Trait)tree2;
            string = trait.name().value();
        } else if (tree2 instanceof Defn.Enum) {
            Defn.Enum enum_ = (Defn.Enum)tree2;
            string = enum_.name().value();
        } else if (tree2 instanceof Defn.Given) {
            Defn.Given given = (Defn.Given)tree2;
            String label = given.name().value();
            string = label.isEmpty() ? "given" : label;
        } else if (tree2 instanceof Pkg.Object) {
            Pkg.Object object = (Pkg.Object)tree2;
            string = object.name().value();
        } else if (tree2 instanceof Defn.Def) {
            Defn.Def def = (Defn.Def)tree2;
            string = def.name().value();
        } else if (tree2 instanceof Defn.GivenAlias) {
            Defn.GivenAlias givenAlias = (Defn.GivenAlias)tree2;
            String label = givenAlias.name().value();
            string = label.isEmpty() ? "given" : label;
        } else if (tree2 instanceof Defn.Type) {
            Defn.Type type = (Defn.Type)tree2;
            string = type.name().value();
        } else if (tree2 instanceof Defn.Val) {
            String string2;
            Pat.Var var;
            Option option;
            Pat pat;
            SeqOps seqOps;
            Defn.Val val = (Defn.Val)tree2;
            List list = val.pats();
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.List().unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (pat = (Pat)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof Pat.Var && !(option = Pat.Var$.MODULE$.unapply(var = (Pat.Var)pat)).isEmpty()) {
                Term.Name n = (Term.Name)option.get();
                string2 = n.value();
            } else {
                string2 = "val";
            }
            string = string2;
        } else if (tree2 instanceof Defn.Var) {
            String string3;
            Pat.Var var;
            Option option;
            Pat pat;
            SeqOps seqOps;
            Defn.Var var2 = (Defn.Var)tree2;
            List list = var2.pats();
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.List().unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (pat = (Pat)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof Pat.Var && !(option = Pat.Var$.MODULE$.unapply(var = (Pat.Var)pat)).isEmpty()) {
                Term.Name n = (Term.Name)option.get();
                string3 = n.value();
            } else {
                string3 = "var";
            }
            string = string3;
        } else if (tree2 instanceof Pkg) {
            String string4;
            Pkg pkg = (Pkg)tree2;
            Term.Ref ref = pkg.ref();
            if (ref instanceof Term.Name) {
                Term.Name name = (Term.Name)ref;
                string4 = name.value();
            } else if (ref instanceof Term.Select) {
                Term.Select select = (Term.Select)ref;
                string4 = select.name().value();
            } else {
                string4 = null;
            }
            string = string4;
        } else {
            boolean bl;
            boolean bl2;
            boolean bl3;
            string = tree2 instanceof Ctor.Secondary ? "this" : (tree2 instanceof Defn.ExtensionGroup ? "extension" : (tree2 instanceof Term.If ? "if" : (tree2 instanceof Term.Do ? "do" : (tree2 instanceof Term.While ? "while" : ((bl3 = tree2 instanceof Term.Match ? true : tree2 instanceof Type.Match) ? "match" : ((bl2 = tree2 instanceof Term.For ? true : tree2 instanceof Term.ForYield) ? "for" : ((bl = tree2 instanceof Term.Try ? true : tree2 instanceof Term.TryWithHandler) ? "try" : null)))))));
        }
        return string;
    }

    public int org$scalafmt$internal$FormatWriter$$getLineDiff(FormatWriter.FormatLocation beg, FormatWriter.FormatLocation end) {
        return beg.leftLineId() - end.leftLineId();
    }

    private int getLineDiff(FormatWriter.FormatLocation[] toks, FormatToken beg, FormatToken end) {
        return this.org$scalafmt$internal$FormatWriter$$getLineDiff(toks[beg.meta().idx()], toks[end.meta().idx()]);
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$indentations$1(ArrayBuffer buf$1, int x$32) {
        return (ArrayBuffer)buf$1.$plus$eq((Object)new StringBuilder(1).append(" ").append(buf$1.last()).toString());
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$extraNewlines$1(ArrayBuffer buf$2, int x$33) {
        return (ArrayBuffer)buf$2.$plus$eq((Object)new StringBuilder(1).append("\n").append(buf$2.last()).toString());
    }

    private FormatWriter$() {
    }
}

