/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Internal;
import com.google.protobuf.ManifestSchemaFactory;
import com.google.protobuf.MessageSchema;
import com.google.protobuf.Reader;
import com.google.protobuf.Schema;
import com.google.protobuf.SchemaFactory;
import com.google.protobuf.Writer;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class Protobuf {
    private static final Protobuf INSTANCE = new Protobuf();
    private final SchemaFactory schemaFactory;
    private final ConcurrentMap<Class<?>, Schema<?>> schemaCache = new ConcurrentHashMap();

    public static Protobuf getInstance() {
        return INSTANCE;
    }

    public <T> void writeTo(T message2, Writer writer) throws IOException {
        this.schemaFor(message2).writeTo(message2, writer);
    }

    public <T> void mergeFrom(T message2, Reader reader) throws IOException {
        this.mergeFrom(message2, reader, ExtensionRegistryLite.getEmptyRegistry());
    }

    public <T> void mergeFrom(T message2, Reader reader, ExtensionRegistryLite extensionRegistry) throws IOException {
        this.schemaFor(message2).mergeFrom(message2, reader, extensionRegistry);
    }

    public <T> void makeImmutable(T message2) {
        this.schemaFor(message2).makeImmutable(message2);
    }

    public <T> boolean isInitialized(T message2) {
        return this.schemaFor(message2).isInitialized(message2);
    }

    public <T> Schema<T> schemaFor(Class<T> messageType2) {
        Schema<?> previous;
        Internal.checkNotNull(messageType2, "messageType");
        Schema<Object> schema2 = (Schema<T>)this.schemaCache.get(messageType2);
        if (schema2 == null && (previous = this.registerSchema(messageType2, schema2 = this.schemaFactory.createSchema(messageType2))) != null) {
            schema2 = previous;
        }
        return schema2;
    }

    public <T> Schema<T> schemaFor(T message2) {
        return this.schemaFor((T)message2.getClass());
    }

    public Schema<?> registerSchema(Class<?> messageType2, Schema<?> schema2) {
        Internal.checkNotNull(messageType2, "messageType");
        Internal.checkNotNull(schema2, "schema");
        return this.schemaCache.putIfAbsent(messageType2, schema2);
    }

    public Schema<?> registerSchemaOverride(Class<?> messageType2, Schema<?> schema2) {
        Internal.checkNotNull(messageType2, "messageType");
        Internal.checkNotNull(schema2, "schema");
        return this.schemaCache.put(messageType2, schema2);
    }

    private Protobuf() {
        this.schemaFactory = new ManifestSchemaFactory();
    }

    int getTotalSchemaSize() {
        int result2 = 0;
        for (Schema schema2 : this.schemaCache.values()) {
            if (!(schema2 instanceof MessageSchema)) continue;
            result2 += ((MessageSchema)schema2).getSchemaSize();
        }
        return result2;
    }
}

