/*
 * Decompiled with CFR 0.152.
 */
package geny;

import geny.Internal$;
import geny.Writable$class;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rbaB\u0001\u0003!\u0003\r\t!\u0002\u0002\t/JLG/\u00192mK*\t1!\u0001\u0003hK:L8\u0001A\n\u0003\u0001\u0019\u0001\"a\u0002\u0006\u000e\u0003!Q\u0011!C\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0017!\u00111!\u00118z\u0011\u0015i\u0001\u0001\"\u0001\u000f\u0003\u0019!\u0013N\\5uIQ\tq\u0002\u0005\u0002\b!%\u0011\u0011\u0003\u0003\u0002\u0005+:LG\u000fC\u0003\u0014\u0001\u0019\u0005A#\u0001\u0007xe&$XMQ=uKN$v\u000e\u0006\u0002\u0010+!)aC\u0005a\u0001/\u0005\u0019q.\u001e;\u0011\u0005aiR\"A\r\u000b\u0005iY\u0012AA5p\u0015\u0005a\u0012\u0001\u00026bm\u0006L!AH\r\u0003\u0019=+H\u000f];u'R\u0014X-Y7\t\u000b\u0001\u0002A\u0011A\u0011\u0002\u001f!$H\u000f]\"p]R,g\u000e\u001e+za\u0016,\u0012A\t\t\u0004\u000f\r*\u0013B\u0001\u0013\t\u0005\u0019y\u0005\u000f^5p]B\u0011a%\u000b\b\u0003\u000f\u001dJ!\u0001\u000b\u0005\u0002\rA\u0013X\rZ3g\u0013\tQ3F\u0001\u0004TiJLgn\u001a\u0006\u0003Q!AQ!\f\u0001\u0005\u00029\nQbY8oi\u0016tG\u000fT3oORDW#A\u0018\u0011\u0007\u001d\u0019\u0003\u0007\u0005\u0002\bc%\u0011!\u0007\u0003\u0002\u0005\u0019>twmB\u00035\u0005!\u0005Q'\u0001\u0005Xe&$\u0018M\u00197f!\t1t'D\u0001\u0003\r\u0015\t!\u0001#\u00019'\r9\u0014\b\u0010\t\u0003\u000fiJ!a\u000f\u0005\u0003\r\u0005s\u0017PU3g!\t1T(\u0003\u0002?\u0005\tqAj\\<Qe&<&/\u001b;bE2,\u0007\"\u0002!8\t\u0003\t\u0015A\u0002\u001fj]&$h\bF\u00016\r\u0011\u0019u'\u0001#\u0003\u001dM#(/\u001b8h/JLG/\u00192mKN\u0019!)O#\u0011\u0005Y\u0002\u0001\u0002C$C\u0005\u0003\u0005\u000b\u0011B\u0013\u0002\u0003MDQ\u0001\u0011\"\u0005\u0002%#\"A\u0013'\u0011\u0005-\u0013U\"A\u001c\t\u000b\u001dC\u0005\u0019A\u0013\t\u000bM\u0011E\u0011\u0001(\u0015\u0005=y\u0005\"\u0002\fN\u0001\u00049\u0002\"\u0002\u0011C\t\u0003\nV#\u0001*\u0011\u0007\u001d\u0019V+\u0003\u0002U\u0011\t!1k\\7f!\t1\u0016,D\u0001X\u0015\tA6$\u0001\u0003mC:<\u0017B\u0001\u0016X\u0011\u0015i#\t\"\u0011\\+\u0005a\u0006cA\u0004Ta!9alNA\u0001\n\u0007y\u0016AD*ue&twm\u0016:ji\u0006\u0014G.\u001a\u000b\u0003\u0015\u0002DQaR/A\u0002\u00152AAY\u001c\u0002G\n\t\")\u001f;f\u0003J\u0014\u0018-_,sSR\f'\r\\3\u0014\u0007\u0005LT\t\u0003\u0005fC\n\u0005\t\u0015!\u0003g\u0003\u0005\t\u0007cA\u0004hS&\u0011\u0001\u000e\u0003\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u000f)L!a\u001b\u0005\u0003\t\tKH/\u001a\u0005\u0006\u0001\u0006$\t!\u001c\u000b\u0003]>\u0004\"aS1\t\u000b\u0015d\u0007\u0019\u00014\t\u000bM\tG\u0011A9\u0015\u0005=\u0011\b\"\u0002\fq\u0001\u00049\u0002\"\u0002\u0011b\t\u0003\n\u0006\"B\u0017b\t\u0003Z\u0006b\u0002<8\u0003\u0003%\u0019a^\u0001\u0012\u0005f$X-\u0011:sCf<&/\u001b;bE2,GC\u00018y\u0011\u0015)W\u000f1\u0001g\r\u0011Qx'A>\u0003%\tKH/\u001a\"vM\u001a,'o\u0016:ji\u0006\u0014G.Z\n\u0004sf*\u0005\u0002C?z\u0005\u0003\u0005\u000b\u0011\u0002@\u0002\r\t,hMZ3s!\ry\u0018QA\u0007\u0003\u0003\u0003Q1!a\u0001\u001c\u0003\rq\u0017n\\\u0005\u0005\u0003\u000f\t\tA\u0001\u0006CsR,')\u001e4gKJDa\u0001Q=\u0005\u0002\u0005-A\u0003BA\u0007\u0003\u001f\u0001\"aS=\t\ru\fI\u00011\u0001\u007f\u0011\u0019\u0019\u0012\u0010\"\u0001\u0002\u0014Q\u0019q\"!\u0006\t\rY\t\t\u00021\u0001\u0018\u0011\u0015\u0001\u0013\u0010\"\u0011R\u0011\u0015i\u0013\u0010\"\u0011\\\u0011%\tibNA\u0001\n\u0007\ty\"\u0001\nCsR,')\u001e4gKJ<&/\u001b;bE2,G\u0003BA\u0007\u0003CAa!`A\u000e\u0001\u0004q\b")
public interface Writable {
    public void writeBytesTo(OutputStream var1);

    public Option<String> httpContentType();

    public Option<Object> contentLength();

    public static class StringWritable
    implements Writable {
        private final String s;

        @Override
        public void writeBytesTo(OutputStream out) {
            new StringOps(Predef$.MODULE$.augmentString(this.s)).grouped(8192).foreach((Function1)new Serializable(this, out){
                public static final long serialVersionUID = 0L;
                private final OutputStream out$1;

                public final void apply(String ss) {
                    this.out$1.write(ss.getBytes(StandardCharsets.UTF_8));
                }
                {
                    this.out$1 = out$1;
                }
            });
        }

        public Some<String> httpContentType() {
            return new Some((Object)"text/plain; charset=utf-8");
        }

        public Some<Object> contentLength() {
            return new Some((Object)BoxesRunTime.boxToLong((long)Internal$.MODULE$.encodedLength(this.s)));
        }

        public StringWritable(String s) {
            this.s = s;
            Writable$class.$init$(this);
        }
    }

    public static class ByteArrayWritable
    implements Writable {
        private final byte[] a;

        @Override
        public void writeBytesTo(OutputStream out) {
            out.write(this.a);
        }

        public Some<String> httpContentType() {
            return new Some((Object)"application/octet-stream");
        }

        public Some<Object> contentLength() {
            return new Some((Object)BoxesRunTime.boxToLong((long)this.a.length));
        }

        public ByteArrayWritable(byte[] a) {
            this.a = a;
            Writable$class.$init$(this);
        }
    }

    public static class ByteBufferWritable
    implements Writable {
        private final ByteBuffer buffer;

        @Override
        public void writeBytesTo(OutputStream out) {
            int l;
            ByteBuffer bb = this.buffer.duplicate().order(this.buffer.order());
            byte[] tmp = new byte[8192];
            int length = bb.remaining();
            for (int count2 = 0; count2 < length; count2 += l) {
                l = package$.MODULE$.min(Predef$.MODULE$.byteArrayOps(tmp).size(), length - count2);
                bb.get(tmp, 0, l);
                out.write(tmp, 0, l);
            }
        }

        public Some<String> httpContentType() {
            return new Some((Object)"application/octet-stream");
        }

        public Some<Object> contentLength() {
            return new Some((Object)BoxesRunTime.boxToLong((long)this.buffer.remaining()));
        }

        public ByteBufferWritable(ByteBuffer buffer) {
            this.buffer = buffer;
            Writable$class.$init$(this);
        }
    }
}

