/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.scalate.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.fusesource.scalate.util.FileResource;
import org.fusesource.scalate.util.IOUtil;
import org.fusesource.scalate.util.Log;
import org.fusesource.scalate.util.Log$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;
import scala.util.parsing.input.OffsetPosition;
import scala.util.parsing.input.Position;

public final class IOUtil$ {
    public static IOUtil$ MODULE$;
    private final Log log;
    private final Regex includeRegEx;

    static {
        new IOUtil$();
    }

    public Log log() {
        return this.log;
    }

    public FileResource toResource(File file) {
        return new FileResource(file, file.getPath());
    }

    public File toFile(FileResource resource) {
        return resource.asFile();
    }

    public void makeParentDirs(String fileName) {
        this.makeParentDirs(new File(fileName));
    }

    public void makeParentDirs(File file) {
        block0: {
            File parent = file.getParentFile();
            if (parent == null) break block0;
            parent.mkdirs();
        }
    }

    public boolean recursiveDelete(File file) {
        block0: {
            File[] children;
            if (!file.isDirectory() || (children = file.listFiles()) == null) break block0;
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])children)).foreach((Function1 & Serializable & scala.Serializable)child -> BoxesRunTime.boxToBoolean((boolean)this.recursiveDelete(child)));
        }
        return file.delete();
    }

    public Regex includeRegEx() {
        return this.includeRegEx;
    }

    public String mergeIncludes(String sourceCode, String encoding) {
        Regex.MatchIterator matches = this.includeRegEx().findAllIn((CharSequence)sourceCode);
        return !matches.hasNext() ? sourceCode : (String)matches.foldLeft((Object)sourceCode, (Function2 & Serializable & scala.Serializable)(result, include) -> {
            String string;
            try {
                String fileName;
                String string2 = include;
                Option option = this.includeRegEx().unapplySeq((CharSequence)string2);
                if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) {
                    throw new MatchError((Object)string2);
                }
                String string3 = fileName = (String)((LinearSeqOptimized)option.get()).apply(0);
                String fileName2 = string3;
                string = this.loadTextFile(new File(fileName2), encoding);
            }
            catch (MatchError m) {
                throw new IOUtil.InvalidDirectiveException("include", (Position)new OffsetPosition((CharSequence)include, 0));
            }
            catch (FileNotFoundException n) {
                throw n;
            }
            String includeSource = string;
            return result.replace((CharSequence)include, includeSource);
        });
    }

    public String mergeIncludes$default$2() {
        return "UTF-8";
    }

    public String loadText(InputStream in, String encoding) {
        String sourceCode = new String(this.loadBytes(in), encoding);
        return this.mergeIncludes(sourceCode, encoding);
    }

    public String loadText$default$2() {
        return "UTF-8";
    }

    public String loadTextFile(File path, String encoding) {
        String sourceCode = new String(this.loadBinaryFile(path), encoding);
        return this.mergeIncludes(sourceCode, encoding);
    }

    public String loadTextFile$default$2() {
        return "UTF-8";
    }

    public byte[] loadBinaryFile(File path) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (FileInputStream in = new FileInputStream(path);){
            this.copy((InputStream)in, (OutputStream)baos);
        }
        return baos.toByteArray();
    }

    public byte[] loadBytes(InputStream in) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.copy(in, (OutputStream)baos);
        }
        finally {
            in.close();
        }
        return baos.toByteArray();
    }

    public void writeText(String path, String text) {
        this.writeText(new File(path), text);
    }

    public void writeText(File path, String text) {
        this.writeText(new FileWriter(path), text);
    }

    public void writeText(OutputStream stream, String text) {
        this.writeText(new OutputStreamWriter(stream), text);
    }

    public void writeText(Writer out, String text) {
        try {
            out.write(text);
        }
        finally {
            out.close();
        }
    }

    public void writeBinaryFile(String path, byte[] contents) {
        this.writeBinaryFile(new File(path), contents);
    }

    public void writeBinaryFile(File path, byte[] contents) {
        try (FileOutputStream out = new FileOutputStream(path);){
            out.write(contents);
        }
    }

    public long copy(File in, File out) {
        out.getParentFile().mkdirs();
        return this.copy((InputStream)new FileInputStream(in), (OutputStream)new FileOutputStream(out));
    }

    public long copy(File file, OutputStream out) {
        return this.copy((InputStream)new BufferedInputStream(new FileInputStream(file)), out);
    }

    public long copy(InputStream in, File file) {
        long l;
        try (FileOutputStream out = new FileOutputStream(file);){
            l = this.copy(in, (OutputStream)out);
        }
        return l;
    }

    public long copy(URL url, File file) {
        long l;
        try (InputStream in = url.openStream();){
            l = this.copy(in, file);
        }
        return l;
    }

    public <R, C extends Closeable> R using(C c, Function1<C, R> func) {
        Object object;
        try {
            object = func.apply(c);
        }
        catch (Throwable throwable) {
            try {
                c.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        Object object2 = object;
        try {
            c.close();
        }
        catch (Exception exception) {}
        return (R)object2;
    }

    /*
     * WARNING - void declaration
     */
    public long copy(InputStream in, OutputStream out) {
        void var3_3;
        long bytesCopied = 0L;
        byte[] buffer = new byte[8192];
        int bytes = in.read(buffer);
        while (bytes >= 0) {
            out.write(buffer, 0, bytes);
            bytesCopied += (long)bytes;
            bytes = in.read(buffer);
        }
        return (long)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public long copy(Reader in, Writer out) {
        void var3_3;
        long charsCopied = 0L;
        char[] buffer = new char[8192];
        int chars = in.read(buffer);
        while (chars >= 0) {
            out.write(buffer, 0, chars);
            charsCopied += (long)chars;
            chars = in.read(buffer);
        }
        return (long)var3_3;
    }

    public void unjar(File outputDir, InputStream input, Function1<ZipEntry, Object> filter) {
        try (ZipInputStream zip = new ZipInputStream(input);){
            byte[] buffer = new byte[65536];
            boolean ok = true;
            while (ok) {
                ZipEntry entry = zip.getNextEntry();
                if (entry == null) {
                    ok = false;
                    continue;
                }
                String name = entry.getName();
                if (!entry.isDirectory() && BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)entry))) {
                    this.log().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "processing resource: %s", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name}));
                    File file = new File(outputDir.getCanonicalPath() + "/" + name);
                    file.getParentFile().mkdirs();
                    try (FileOutputStream bos = new FileOutputStream(file);){
                        int bytes = 1;
                        while (bytes > 0) {
                            bytes = zip.read(buffer);
                            if (bytes <= 0) continue;
                            bos.write(buffer, 0, bytes);
                        }
                    }
                }
                zip.closeEntry();
            }
        }
    }

    public Function1<ZipEntry, Object> unjar$default$3() {
        return (Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)this.allZipEntries(entry));
    }

    public void recursiveDelete(File file, Function1<File, Object> filter) {
        block2: {
            if (!file.exists()) break block2;
            if (file.isDirectory()) {
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])file.listFiles())).foreach((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)this.recursiveDelete(c)));
            }
            if (BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)file))) {
                file.delete();
            }
        }
    }

    public Function1<File, Object> recursiveDelete$default$2() {
        return (Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)this.allFiles(file));
    }

    public boolean allZipEntries(ZipEntry entry) {
        return true;
    }

    public boolean allFiles(File file) {
        return true;
    }

    private IOUtil$() {
        MODULE$ = this;
        this.log = Log$.MODULE$.apply(this.getClass());
        this.includeRegEx = new StringOps(Predef$.MODULE$.augmentString("@@include\\(\\\"(.+)\\\"\\)")).r();
    }
}

