/*
 * Decompiled with CFR 0.152.
 */
package org.scalaxb.maven;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.scalaxb:scalaxb-maven-plugin:0.6.8", 0);
        this.append(sb, "", 0);
        this.append(sb, "scalaxb Maven Plugin", 0);
        this.append(sb, "(no description available)", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 2 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "generate".equals(this.goal)) {
            this.append(sb, "scalaxb:generate", 0);
            this.append(sb, "(no description available)", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "attributePrefix", 2);
                this.append(sb, "Prefix to prepend to the names of generated parameters for XML attributes.\nThis option sets a prefix to be used in the names of parameters for XML attributes. It is useful when a schema defines both an element and an attribute of the same name within a complex type.", 3);
                this.append(sb, "", 0);
                this.append(sb, "chunkSize", 2);
                this.append(sb, "Maximum number of parameters to use in generated case class constructors. This allows parameters sequences to be separated into chunks of the given size.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classPrefix", 2);
                this.append(sb, "The prefix to use on generated classes.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateRuntime (Default: true)", 2);
                this.append(sb, "Generate the scalaxb classes required to use the generated bindings. This option is useful for preventing duplicate copies of the scalaxb runtime being present on the classpath when more than one jar contains scalaxb bindings. To prevent the scalaxb runtime sources being generated, this option should be set to false.", 3);
                this.append(sb, "", 0);
                this.append(sb, "laxAny (Default: false)", 2);
                this.append(sb, "Relaxes namespace constraints of xs:any.\nThis option allows xs:any elements declared with a namespace attribute of ##local to contain qualified XML elements. According to the W3C XML Schema recommendation, an XML element that is declared to be in a namespace is not permitted content for an xs:any element with a namespace of ##local. By default, this option is false, thus enforcing this requirement. Setting this option to true allows namespaced content to be used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory}/generated-sources/scalaxb)", 2);
                this.append(sb, "The output directory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packageDir (Default: true)", 2);
                this.append(sb, "Determines whether generated Scala files will be written into a directory corresponding to their package name. By default, the generated files are written in the output directory under a sub-directory that corresponds to the package name. For example, if the generated classes are in package 'foo', they will be generated in ${scalaxb.outputDirectory}/foo. Setting this value to false will cause the generated sources to be written directly into the output directory, without creating a directory for the package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packageName (Default: generated)", 2);
                this.append(sb, "The package in which to generate classes. Classes are generated in the package specified, unless the packageNames parameter is used to override this value.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packageNames", 2);
                this.append(sb, "Map of namespace URIs to package names for generated classes.\nThis option can be used to override the packageName parameter (see above) for elements in specific namespaces. The mapping between namespace URIs and package names can be specifying any number of packageName elements within the packageNames element. For example:\n<packageNames>\n\u00a0\u00a0<packageName>\n\u00a0\u00a0\u00a0\u00a0<uri>http://example.com/service1</uri>\n\u00a0\u00a0\u00a0\u00a0<package>com.example.service1<package>\n\u00a0\u00a0</packageName>\n\u00a0\u00a0<packageName>\n\u00a0\u00a0\u00a0\u00a0<uri>http://example.com/service2</uri>\n\u00a0\u00a0\u00a0\u00a0<package>com.example.service2<package>\n\u00a0\u00a0</packageName>\n</packageNames>\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "parameterPrefix", 2);
                this.append(sb, "The prefix to use on generated parameter names.", 3);
                this.append(sb, "", 0);
                this.append(sb, "protocolFile", 2);
                this.append(sb, "The name of the file to generate that includes the protocol implementation; that is, the code that marshals values to and from XML.", 3);
                this.append(sb, "", 0);
                this.append(sb, "protocolPackage", 2);
                this.append(sb, "The package in which to generate the 'protocol' code; that is, the code that marshals values to and from XML. The generated code defines a package object for the named package. The package object defines implicit values required for using the scalaxb.toXML and scalaxb.fromXML functions. If unspecified, the protocol code is generated in the same package as the generated classes that define the values marshalled to and from XML.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "wrapContents", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "wsdlDirectory (Default: ${project.basedir}/src/main/wsdl)", 2);
                this.append(sb, "The directory containing the WSDL files. If the specified directory does not exist or is empty, then it is ignored.", 3);
                this.append(sb, "", 0);
                this.append(sb, "xsdDirectory (Default: ${project.basedir}/src/main/xsd)", 2);
                this.append(sb, "The directory containing the XSD files. If the specified directory does not exist or is empty, then it is ignored.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "scalaxb:help", 0);
            this.append(sb, "Display help information on scalaxb-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0scalaxb:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

