/*
 * Decompiled with CFR 0.152.
 */
package org.scalaxb.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.scalaxb.maven.ArgumentsBuilder;
import org.scalaxb.maven.PackageName;
import scala.collection.JavaConversions;
import scala.collection.Seq;
import scalaxb.compiler.CaseClassTooLong;
import scalaxb.compiler.Main;
import scalaxb.compiler.ReferenceNotFound;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalaxbMojo
extends AbstractMojo {
    private MavenProject project;
    private File xsdDirectory;
    private File wsdlDirectory;
    private File outputDirectory;
    private String packageName;
    private PackageName[] packageNames;
    private String classPrefix;
    private String parameterPrefix;
    private List<String> wrapContents;
    private boolean generateRuntime;
    private Integer chunkSize;
    private boolean packageDir;
    private String protocolFile;
    private String protocolPackage;
    private boolean laxAny;
    private String attributePrefix;
    private boolean verbose;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<String> schemaFiles = this.inputFiles(this.xsdDirectory, "xsd");
        List<String> wsdlFiles = this.inputFiles(this.wsdlDirectory, "wsdl");
        if (schemaFiles.isEmpty() && wsdlFiles.isEmpty()) {
            this.getLog().warn((CharSequence)"No XSD or WSDL files found: not running scalaxb");
        } else {
            ArrayList<String> inputFiles = new ArrayList<String>();
            inputFiles.addAll(wsdlFiles);
            inputFiles.addAll(schemaFiles);
            this.generateBindings(inputFiles);
        }
    }

    private void generateBindings(List<String> schemaFiles) throws MojoExecutionException, MojoFailureException {
        this.outputDirectory.mkdirs();
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.addAll(this.arguments());
        arguments.addAll(schemaFiles);
        this.invokeCompiler(arguments);
        this.getLog().debug((CharSequence)("Adding source root: " + this.outputDirectory.getAbsolutePath()));
        this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
    }

    private void invokeCompiler(List<String> arguments) throws MojoExecutionException, MojoFailureException {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)("Running in process: scalaxb " + ScalaxbMojo.argumentsToString(arguments)));
        }
        try {
            Main.start((Seq)JavaConversions.asScalaBuffer(arguments));
        }
        catch (ReferenceNotFound ex) {
            throw new MojoFailureException(ex.getMessage());
        }
        catch (CaseClassTooLong ex) {
            throw new MojoFailureException(ex.getMessage());
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error running scalaxb", ex);
        }
    }

    static String argumentsToString(List<String> arguments) {
        Pattern safe = Pattern.compile("[\\p{Alnum}:/=\\.-]*");
        StringBuilder str = new StringBuilder();
        for (String arg : arguments) {
            if (safe.matcher(arg).matches()) {
                str.append(arg);
            } else {
                String escapedArg = arg.replaceAll("'", "'\\\\''");
                str.append('\'').append(escapedArg).append('\'');
            }
            str.append(' ');
        }
        str.deleteCharAt(str.length() - 1);
        return str.toString();
    }

    Map<String, String> packageNameMap() {
        if (this.packageNames == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> names = new LinkedHashMap<String, String>();
        for (PackageName name : this.packageNames) {
            names.put(name.getUri(), name.getPackage());
        }
        return names;
    }

    private List<String> arguments() {
        List<String> args = new ArgumentsBuilder().flag("-v", this.verbose).flag("--package-dir", this.packageDir).param("-d", this.outputDirectory.getPath()).param("-p", this.packageName).map("-p:", this.packageNameMap()).param("--class-prefix", this.classPrefix).param("--param-prefix", this.parameterPrefix).param("--chunk-size", this.chunkSize).flag("--no-runtime", !this.generateRuntime).intersperse("--wrap-contents", this.wrapContents).param("--protocol-file", this.protocolFile).param("--protocol-package", this.protocolPackage).param("--attribute-prefix", this.attributePrefix).flag("--lax-any", this.laxAny).getArguments();
        return Collections.unmodifiableList(args);
    }

    List<String> inputFiles(File directory, String type) {
        if (!directory.exists()) {
            return Collections.emptyList();
        }
        DirectoryScanner ds = new DirectoryScanner();
        String[] includes = new String[]{"**\\*." + type};
        ds.setIncludes(includes);
        ds.setBasedir(directory);
        ds.scan();
        ArrayList<String> result = new ArrayList<String>();
        for (String xsdFile : ds.getIncludedFiles()) {
            result.add(new File(directory, xsdFile).getAbsolutePath());
        }
        Collections.sort(result);
        return result;
    }
}

