package scodec.protocols
package mpeg

import scalaz.{ \/, \/-, -\/ }
import \/.{ left, right }
import scalaz.stream.{ Process1, process1 }
import scodec.Err
import scodec.bits.BitVector

trait MpegError {
  def message: String
}

object MpegError {

  case class General(message: String) extends MpegError {
    override def toString = message
  }
  case class Decoding(data: BitVector, err: Err) extends MpegError {
    def message = s"error encountered when decoding: $err ${data.toHex}"
    override def toString = message
  }

  def joinErrors[A, B](p: Process1[A, MpegError \/ B]): Process1[MpegError \/ A, MpegError \/ B] =
    process1ext.conditionallyFeed(p, {
      case \/-(a) => left(a)
      case e @ -\/(_) => right(e)
    })

  def passErrors[A, B](p: Process1[A, B]): Process1[MpegError \/ A, MpegError \/ B] =
    process1.liftR(p)
}
