/*
 * Decompiled with CFR 0.152.
 */
package org.sculptor.maven.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractGeneratorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="src/main/java", required=true)
    protected File outletSrcOnceDir;
    @Parameter(defaultValue="src/main/resources", required=true)
    protected File outletResOnceDir;
    @Parameter(defaultValue="src/generated/java", required=true)
    protected File outletSrcDir;
    @Parameter(defaultValue="src/generated/resources", required=true)
    protected File outletResDir;
    @Parameter(defaultValue="src/main/webapp", required=true)
    protected File outletWebrootDir;
    @Parameter(defaultValue="src/test/java", required=true)
    protected File outletSrcTestOnceDir;
    @Parameter(defaultValue="src/test/resources", required=true)
    protected File outletResTestOnceDir;
    @Parameter(defaultValue="src/test/generated/java", required=true)
    protected File outletSrcTestDir;
    @Parameter(defaultValue="src/test/generated/resources", required=true)
    protected File outletResTestDir;
    @Parameter(defaultValue="src/site", required=true)
    protected File outletDocDir;
    @Parameter(defaultValue=".sculptor-status", required=true)
    private File statusFile;
    @Parameter(property="verbose", defaultValue="false")
    private boolean verbose;

    protected MavenProject getProject() {
        return this.project;
    }

    protected boolean isVerbose() {
        return this.verbose || this.getLog().isDebugEnabled();
    }

    protected File getStatusFile() {
        return this.statusFile.exists() ? this.statusFile : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateStatusFile(List<File> createdFiles) {
        boolean success;
        Properties statusProperties = new Properties();
        try {
            for (File createdFile : createdFiles) {
                try {
                    statusProperties.setProperty(this.getProjectRelativePath(createdFile), this.calculateChecksum(createdFile));
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)("Checksum calculation failed: " + e.getMessage()));
                }
            }
            FileWriter statusWriter = new FileWriter(this.statusFile);
            try {
                statusProperties.store(statusWriter, "Sculptor created the following " + createdFiles.size() + " files");
                success = true;
            }
            finally {
                statusWriter.close();
            }
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Updating status file failed: " + e.getMessage()));
            success = false;
        }
        return success;
    }

    protected Set<String> getGeneratedFiles() {
        Properties statusFileProps = this.getStatusProperties();
        if (statusFileProps != null) {
            return statusFileProps.stringPropertyNames();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getStatusProperties() {
        File statusFile = this.getStatusFile();
        if (statusFile != null) {
            Properties properties;
            Properties statusFileProps = new Properties();
            FileReader statusReader = new FileReader(statusFile);
            try {
                statusFileProps.load(statusReader);
                properties = statusFileProps;
            }
            catch (Throwable throwable) {
                try {
                    statusReader.close();
                    throw throwable;
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)("Reading status file failed: " + e.getMessage()));
                }
            }
            statusReader.close();
            return properties;
        }
        return null;
    }

    protected boolean deleteGeneratedFiles() {
        boolean success;
        this.cleanDirectory(this.outletSrcDir);
        this.cleanDirectory(this.outletResDir);
        this.cleanDirectory(this.outletSrcTestDir);
        this.cleanDirectory(this.outletResTestDir);
        Properties statusFileProps = this.getStatusProperties();
        if (statusFileProps == null || statusFileProps.isEmpty()) {
            success = true;
        } else {
            try {
                for (String fileName : statusFileProps.stringPropertyNames()) {
                    File imageFile;
                    boolean delete;
                    File file = new File(this.getProject().getBasedir(), fileName);
                    if (!file.exists()) continue;
                    if (fileName.startsWith(this.getProjectRelativePath(this.outletSrcOnceDir)) || fileName.startsWith(this.getProjectRelativePath(this.outletResOnceDir)) || fileName.startsWith(this.getProjectRelativePath(this.outletWebrootDir)) || fileName.startsWith(this.getProjectRelativePath(this.outletSrcTestOnceDir)) || fileName.startsWith(this.getProjectRelativePath(this.outletResTestOnceDir))) {
                        delete = this.calculateChecksum(file).equals(statusFileProps.getProperty(fileName));
                        if (!delete && (this.isVerbose() || this.getLog().isDebugEnabled())) {
                            this.getLog().info((CharSequence)("Keeping previously generated modified file: " + file));
                        }
                    } else {
                        delete = false;
                    }
                    if (!delete) continue;
                    if (this.isVerbose() || this.getLog().isDebugEnabled()) {
                        this.getLog().info((CharSequence)("Deleting previously generated file: " + file));
                    }
                    FileUtils.forceDelete((File)file);
                    if (!fileName.endsWith(".dot") || !(imageFile = new File(this.getProject().getBasedir(), fileName + ".png")).exists()) continue;
                    if (this.isVerbose() || this.getLog().isDebugEnabled()) {
                        this.getLog().info((CharSequence)("Deleting previously generated file: " + imageFile));
                    }
                    FileUtils.forceDelete((File)imageFile);
                }
                success = true;
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Reading status file failed: " + e.getMessage()));
                success = false;
            }
        }
        return success;
    }

    private void cleanDirectory(File dir) {
        if (this.isVerbose() || this.getLog().isDebugEnabled()) {
            this.getLog().info((CharSequence)("Deleting previously generated files in directory: " + dir.getPath()));
        }
        if (dir.exists()) {
            try {
                FileUtils.cleanDirectory((File)dir);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Cleaning directory failed: " + e.getMessage()));
            }
        }
    }

    protected String getProjectRelativePath(File file) {
        String prefix;
        String path = file.getAbsolutePath();
        if (path.startsWith(prefix = this.project.getBasedir().getAbsolutePath())) {
            path = path.substring(prefix.length() + 1);
        }
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        return path;
    }

    private String calculateChecksum(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        return DigestUtils.md5Hex((InputStream)is);
    }
}

