/*
 * Decompiled with CFR 0.152.
 */
package org.sculptor.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.sculptor.maven.plugin.AbstractGeneratorMojo;
import org.sculptor.maven.plugin.MavenLogOutputStream;

@Mojo(name="generate-images", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public class GraphvizMojo
extends AbstractGeneratorMojo {
    @Parameter(property="sculptor.graphviz.command", defaultValue="dot")
    private String command;
    @Parameter(property="sculptor.graphviz.skip", defaultValue="false")
    private boolean skip;

    protected boolean isSkip() {
        return this.skip;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skipping creation of image files");
        } else {
            Set<String> changedDotFiles = this.getChangedDotFiles();
            if (changedDotFiles != null && !changedDotFiles.isEmpty() && !this.executeDot(changedDotFiles)) {
                throw new MojoExecutionException("Executing '" + this.command + "' command failed");
            }
        }
    }

    protected Set<String> getChangedDotFiles() {
        Set<String> generatedFiles = this.getGeneratedFiles();
        if (generatedFiles == null || generatedFiles.isEmpty()) {
            return null;
        }
        HashSet<String> changedDotFiles = new HashSet<String>();
        for (String generatedFile : generatedFiles) {
            if (!generatedFile.endsWith(".dot")) continue;
            File dotFile = new File(this.getProject().getBasedir(), generatedFile);
            File imageFile = new File(this.getProject().getBasedir(), generatedFile + ".png");
            if (imageFile.exists() && imageFile.lastModified() >= dotFile.lastModified()) continue;
            changedDotFiles.add(generatedFile);
        }
        if (changedDotFiles.size() == 1) {
            String fileName = (String)changedDotFiles.iterator().next();
            if (fileName.startsWith(this.project.getBasedir().getAbsolutePath())) {
                fileName = fileName.substring(this.project.getBasedir().getAbsolutePath().length() + 1);
            }
            String message = MessageFormat.format("\"{0}\" has been changed", fileName);
            this.getLog().info((CharSequence)message);
        } else if (changedDotFiles.size() > 1) {
            String message = MessageFormat.format("{0} dot files have been changed", changedDotFiles.size());
            this.getLog().info((CharSequence)message);
        } else {
            this.getLog().info((CharSequence)"Everything is up to date - no image generation is needed");
        }
        return changedDotFiles;
    }

    protected boolean executeDot(Set<String> dotFiles) throws MojoExecutionException {
        MavenLogOutputStream stdout = this.getStdoutStream();
        MavenLogOutputStream stderr = this.getStderrStream();
        Executor exec = this.getExecutor();
        exec.setWorkingDirectory(this.project.getBasedir());
        exec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)((Object)stdout), (OutputStream)((Object)stderr), System.in));
        try {
            int exitValue = exec.execute(this.getDotCommandLine(dotFiles));
            if (exitValue == 0 && stdout.getErrorCount() == 0) {
                return true;
            }
        }
        catch (ExecuteException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return false;
    }

    protected MavenLogOutputStream getStdoutStream() {
        return new MavenLogOutputStream(this.getLog());
    }

    protected MavenLogOutputStream getStderrStream() {
        return new MavenLogOutputStream(this.getLog(), true);
    }

    protected Executor getExecutor() {
        return new DefaultExecutor();
    }

    protected CommandLine getDotCommandLine(Set<String> generatedFiles) throws MojoExecutionException {
        CommandLine cl = new CommandLine(this.command);
        if (this.isVerbose()) {
            cl.addArgument("-v");
        }
        cl.addArgument("-Tpng");
        cl.addArgument("-O");
        for (String generatedFile : generatedFiles) {
            if (!generatedFile.endsWith(".dot")) continue;
            cl.addArgument(generatedFile);
        }
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Commandline: " + cl));
        }
        return cl;
    }
}

