/*
 * Decompiled with CFR 0.152.
 */
package org.sculptor.maven.plugin;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.sculptor.maven.plugin.AbstractGeneratorMojo;

@Mojo(name="clean", defaultPhase=LifecyclePhase.CLEAN, threadSafe=true)
public class CleanMojo
extends AbstractGeneratorMojo {
    @Parameter(property="sculptor.clean.skip", defaultValue="false")
    private boolean skip;

    protected boolean isSkip() {
        return this.skip;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skipping deletion of previously generated files");
        } else {
            this.deleteGeneratedFiles();
            File statusFile = this.getStatusFile();
            if (statusFile != null) {
                try {
                    FileUtils.forceDelete((File)statusFile);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Deleting status file failed", (Exception)e);
                }
                if (this.isVerbose()) {
                    this.getLog().info((CharSequence)("Deleted status file: " + statusFile));
                }
            }
        }
    }
}

