/*
 * Decompiled with CFR 0.152.
 */
package org.sculptor.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.sculptor.generator.SculptorGeneratorIssue;
import org.sculptor.generator.SculptorGeneratorResult;
import org.sculptor.generator.SculptorGeneratorRunner;
import org.sculptor.maven.plugin.AbstractGeneratorMojo;
import org.sculptor.maven.plugin.ResourceChildFirstURLClassLoader;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class GeneratorMojo
extends AbstractGeneratorMojo {
    protected static final String OUTPUT_SLOT_PATH_PREFIX = "outputSlot.path.";
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component
    private BuildContext buildContext;
    @Parameter(defaultValue="src/main/resources/model.btdesign", required=true)
    private String model;
    @Parameter
    private FileSet[] checkFileSets;
    @Parameter(property="sculptor.generator.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="sculptor.generator.force", defaultValue="false")
    private boolean force;
    @Parameter(property="sculptor.generator.clean", defaultValue="true")
    private boolean clean;
    @Parameter
    private Map<String, String> properties;

    protected File getModelFile() {
        return new File(this.project.getBasedir(), this.model);
    }

    protected boolean isSkip() {
        return this.skip;
    }

    protected boolean isForce() {
        return this.force;
    }

    protected boolean isClean() {
        return this.clean;
    }

    public final void execute() throws MojoExecutionException {
        Set<String> changedFiles;
        this.initMojoMultiValueParameters();
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skipping code generator execution");
            return;
        }
        File modelFile = this.getModelFile();
        if (!modelFile.exists() || !modelFile.isFile()) {
            throw new MojoExecutionException("Model file '" + this.model + "' specified in <model/> does not exists");
        }
        if (this.isForce()) {
            this.getLog().info((CharSequence)"Forced code generator execution");
            changedFiles = null;
        } else {
            changedFiles = this.getChangedFiles();
        }
        if (changedFiles == null || !changedFiles.isEmpty()) {
            if (this.isClean()) {
                this.deleteGeneratedFiles();
            } else {
                this.getLog().info((CharSequence)"Automatic cleanup disabled - keeping previously generated files");
            }
            if (!this.executeGenerator()) {
                throw new MojoExecutionException("Sculptor code generator failed");
            }
        }
        this.extendProjectCompileRootsAndResources();
    }

    protected void initMojoMultiValueParameters() {
        if (this.checkFileSets == null) {
            FileSet defaultFileSet = new FileSet();
            defaultFileSet.setDirectory(this.project.getBasedir() + "/src/main/resources");
            defaultFileSet.addInclude("*.btdesign");
            this.checkFileSets = new FileSet[]{defaultFileSet};
        }
    }

    protected void extendProjectCompileRootsAndResources() throws MojoExecutionException {
        if (this.project != null) {
            try {
                this.extendCompileSourceRoots();
                this.extendResources(this.outletResDir, false);
                this.extendResources(this.outletResOnceDir, false);
                this.extendResources(this.outletResTestDir, true);
                this.extendResources(this.outletResTestOnceDir, true);
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Could not extend the projects compile paths", ex);
            }
        }
    }

    private void extendCompileSourceRoots() {
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Adding compile source directory '" + this.outletSrcDir + "'"));
        }
        this.project.addCompileSourceRoot(this.outletSrcDir.getAbsolutePath());
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Adding compile source directory '" + this.outletSrcOnceDir + "'"));
        }
        this.project.addCompileSourceRoot(this.outletSrcOnceDir.getAbsolutePath());
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Adding test compile source directory '" + this.outletSrcTestDir + "'"));
        }
        this.project.addTestCompileSourceRoot(this.outletSrcTestDir.getAbsolutePath());
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Adding test compile source directory '" + this.outletSrcTestOnceDir + "'"));
        }
        this.project.addTestCompileSourceRoot(this.outletSrcTestOnceDir.getAbsolutePath());
    }

    private void extendResources(File resourceDir, boolean isTest) {
        List resources = isTest ? this.project.getTestResources() : this.project.getResources();
        for (Resource resource : resources) {
            if (!resource.getDirectory().equalsIgnoreCase(resourceDir.getAbsolutePath())) continue;
            return;
        }
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Adding resource directory '" + resourceDir + "'"));
        }
        Resource resource = new Resource();
        resource.setDirectory(resourceDir.getAbsolutePath());
        resources.add(resource);
    }

    protected Set<String> getChangedFiles() {
        File statusFile = this.getStatusFile();
        if (statusFile == null) {
            return null;
        }
        long statusFileLastModified = statusFile.lastModified();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Last code generator execution: " + df.format(new Date(statusFileLastModified))));
        }
        ArrayList<File> filesToCheck = new ArrayList<File>();
        filesToCheck.add(new File(this.project.getBasedir(), "pom.xml"));
        FileSet generatorFileSet = new FileSet();
        generatorFileSet.setDirectory(this.project.getBasedir() + "/src/main/resources/generator");
        generatorFileSet.addInclude("*");
        filesToCheck.addAll(this.toFileList(generatorFileSet));
        for (FileSet fs : this.checkFileSets) {
            filesToCheck.addAll(this.toFileList(fs));
        }
        HashSet<String> changedFiles = new HashSet<String>();
        for (File checkFile : filesToCheck) {
            boolean isModified;
            if (!checkFile.isAbsolute()) {
                checkFile = new File(this.project.getBasedir(), checkFile.getPath());
            }
            boolean bl = isModified = checkFile.lastModified() > statusFileLastModified;
            if (isModified) {
                changedFiles.add(checkFile.getAbsolutePath());
            }
            if (!this.isVerbose()) continue;
            this.getLog().info((CharSequence)("File '" + checkFile.getAbsolutePath() + "': " + (isModified ? "outdated" : "up-to-date") + " (" + " " + df.format(new Date(checkFile.lastModified())) + ")"));
        }
        if (changedFiles.size() == 1) {
            String fileName = (String)changedFiles.iterator().next();
            if (fileName.startsWith(this.project.getBasedir().getAbsolutePath())) {
                fileName = fileName.substring(this.project.getBasedir().getAbsolutePath().length() + 1);
            }
            String message = MessageFormat.format("\"{0}\" has been modified since last generator run at {1}", fileName, df.format(new Date(statusFileLastModified)));
            this.getLog().info((CharSequence)message);
        } else if (changedFiles.size() > 1) {
            String message = MessageFormat.format("{0} checked resources have been modified since last generator run at {1}", changedFiles.size(), df.format(new Date(statusFileLastModified)));
            this.getLog().info((CharSequence)message);
        } else {
            this.getLog().info((CharSequence)"Everything is up-to-date - no generator run is needed");
        }
        return changedFiles;
    }

    protected boolean executeGenerator() throws MojoExecutionException {
        ArrayList<Object> classpathEntries = new ArrayList<Object>();
        classpathEntries.addAll(this.project.getResources());
        classpathEntries.add(this.project.getBuild().getOutputDirectory());
        this.extendPluginClasspath(classpathEntries);
        Properties generatorProperties = new Properties();
        if (this.properties != null) {
            for (String key : this.properties.keySet()) {
                generatorProperties.setProperty(key, this.properties.get(key));
            }
        }
        generatorProperties.setProperty("outputSlot.path.TO_SRC", this.outletSrcOnceDir.toString());
        generatorProperties.setProperty("outputSlot.path.TO_RESOURCES", this.outletResOnceDir.toString());
        generatorProperties.setProperty("outputSlot.path.TO_GEN_SRC", this.outletSrcDir.toString());
        generatorProperties.setProperty("outputSlot.path.TO_GEN_RESOURCES", this.outletResDir.toString());
        generatorProperties.setProperty("outputSlot.path.TO_WEBROOT", this.outletWebrootDir.toString());
        generatorProperties.setProperty("outputSlot.path.TO_SRC_TEST", this.outletSrcTestOnceDir.toString());
        generatorProperties.setProperty("outputSlot.path.TO_RESOURCES_TEST", this.outletResTestOnceDir.toString());
        generatorProperties.setProperty("outputSlot.path.TO_GEN_SRC_TEST", this.outletSrcTestDir.toString());
        generatorProperties.setProperty("outputSlot.path.TO_GEN_RESOURCES_TEST", this.outletResTestDir.toString());
        generatorProperties.setProperty("outputSlot.path.TO_DOC", this.outletDocDir.toString());
        List<File> generatedFiles = this.doRunGenerator(generatorProperties);
        if (generatedFiles != null) {
            if (this.isVerbose()) {
                for (File generatedFile : generatedFiles) {
                    this.getLog().info((CharSequence)("Generated: " + this.getProjectRelativePath(generatedFile)));
                }
            }
            this.updateStatusFile(generatedFiles);
            if (generatedFiles.size() > 0) {
                this.refreshEclipseWorkspace();
            }
            this.getLog().info((CharSequence)("Generated " + generatedFiles.size() + " files"));
            return true;
        }
        this.getLog().error((CharSequence)"Executing generator workflow failed");
        return false;
    }

    private void refreshEclipseWorkspace() {
        this.buildContext.refresh(this.outletSrcOnceDir);
        this.buildContext.refresh(this.outletResOnceDir);
        this.buildContext.refresh(this.outletSrcDir);
        this.buildContext.refresh(this.outletResDir);
        this.buildContext.refresh(this.outletWebrootDir);
        this.buildContext.refresh(this.outletSrcTestOnceDir);
        this.buildContext.refresh(this.outletResTestOnceDir);
        this.buildContext.refresh(this.outletSrcTestDir);
        this.buildContext.refresh(this.outletResTestDir);
        this.buildContext.refresh(this.outletDocDir);
    }

    protected List<File> doRunGenerator(Properties generatorProperties) {
        SculptorGeneratorResult result = SculptorGeneratorRunner.run((String)this.getModelFile().toString(), (Properties)generatorProperties);
        for (SculptorGeneratorIssue issue : result.getIssues()) {
            switch (issue.getSeverity()) {
                case ERROR: {
                    if (issue.getThrowable() != null) {
                        this.getLog().error((CharSequence)issue.getMessage(), issue.getThrowable());
                        break;
                    }
                    this.getLog().error((CharSequence)issue.getMessage());
                    break;
                }
                case WARNING: {
                    this.getLog().warn((CharSequence)issue.getMessage());
                    break;
                }
                case INFO: {
                    this.getLog().info((CharSequence)issue.getMessage());
                }
            }
        }
        return result.getStatus() == SculptorGeneratorResult.Status.SUCCESS ? result.getGeneratedFiles() : null;
    }

    public void extendPluginClasspath(List<Object> classpathEntries) throws MojoExecutionException {
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        for (Object classpathEntry : classpathEntries) {
            if (classpathEntry instanceof Resource) {
                File resourceFile = new File(((Resource)classpathEntry).getDirectory());
                if (!resourceFile.exists()) continue;
                this.getLog().debug((CharSequence)("Adding resource to plugin classpath: " + resourceFile.getPath()));
                try {
                    urls.add(resourceFile.toURI().toURL());
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            }
            if (classpathEntry instanceof String) {
                File path = new File((String)classpathEntry);
                if (!path.exists()) continue;
                this.getLog().debug((CharSequence)("Adding path to plugin classpath: " + path.getPath()));
                try {
                    urls.add(path.toURI().toURL());
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            }
            throw new IllegalArgumentException("Unsupported classpathentry: " + classpathEntry);
        }
        ResourceChildFirstURLClassLoader classLoader = new ResourceChildFirstURLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        this.getLog().debug((CharSequence)("Setting new context classloader '" + classLoader + "': " + urls));
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    private List<File> toFileList(FileSet fileSet) {
        File directory = new File(fileSet.getDirectory());
        String includes = this.toCommaSeparatedString(fileSet.getIncludes());
        String excludes = this.toCommaSeparatedString(fileSet.getExcludes());
        try {
            return FileUtils.getFiles((File)directory, (String)includes, (String)excludes);
        }
        catch (IllegalStateException e) {
            this.getLog().warn((CharSequence)(e.getMessage() + ". Ignoring fileset."));
        }
        catch (IOException e) {
            this.getLog().warn((Throwable)e);
        }
        return Collections.emptyList();
    }

    private String toCommaSeparatedString(Collection<String> strings) {
        StringBuilder sb = new StringBuilder();
        for (String string : strings) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(string);
        }
        return sb.toString();
    }
}

