/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium.grid;

import com.thoughtworks.selenium.grid.HttpParameters;
import com.thoughtworks.selenium.grid.Response;
import java.io.IOException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpClient {
    private static final Log logger = LogFactory.getLog(HttpClient.class);
    private final org.apache.commons.httpclient.HttpClient client;

    public HttpClient(org.apache.commons.httpclient.HttpClient client) {
        this.client = client;
    }

    public HttpClient() {
        this(new org.apache.commons.httpclient.HttpClient());
    }

    public Response get(String url) throws IOException {
        return this.request((HttpMethod)new GetMethod(url));
    }

    public Response post(String url, HttpParameters parameters) throws IOException {
        return this.request((HttpMethod)this.buildPostMethod(url, parameters));
    }

    protected PostMethod buildPostMethod(String url, HttpParameters parameters) {
        PostMethod postMethod = new PostMethod(url);
        postMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; ; charset=UTF-8");
        for (String name : parameters.names()) {
            postMethod.setParameter(name, parameters.get(name));
        }
        return postMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response request(HttpMethod method) throws IOException {
        try {
            int statusCode = this.client.executeMethod(method);
            String body = new String(method.getResponseBody(), "utf-8");
            logger.info((Object)("Remote Control replied with '" + statusCode + " / '" + body + "'"));
            Response response = new Response(statusCode, body);
            return response;
        }
        finally {
            method.releaseConnection();
        }
    }
}

