/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium.grid;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IOHelper {
    private static final Log LOGGER = LogFactory.getLog(IOHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream in, Writer out, int copyBufferSize) throws IOException {
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(in);
            IOHelper.copyStream(reader, out, copyBufferSize);
        }
        catch (Throwable throwable) {
            IOHelper.close(reader);
            throw throwable;
        }
        IOHelper.close(reader);
        out.flush();
    }

    public static void copyStream(Reader in, Writer out, int copyBufferSize) throws IOException {
        int bytesRead;
        char[] buffer = new char[copyBufferSize];
        while (in.ready() && (bytesRead = in.read(buffer)) >= 0) {
            out.write(buffer, 0, bytesRead);
        }
        out.flush();
    }

    public static void close(InputStream is) {
        if (null != is) {
            try {
                is.close();
            }
            catch (IOException e) {
                LOGGER.info((Object)("Ignoring exception while closing input stream '" + is + "'"), (Throwable)e);
            }
        }
    }

    public static void close(Reader reader) {
        if (null != reader) {
            try {
                reader.close();
            }
            catch (IOException e) {
                LOGGER.info((Object)("Ignoring exception while closing reader '" + reader + "'"), (Throwable)e);
            }
        }
    }

    public static void close(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                LOGGER.info((Object)("Ignoring exception while closing writer stream '" + writer + "'"), (Throwable)e);
            }
        }
    }

    public static void close(OutputStream outputStream) {
        if (null != outputStream) {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                LOGGER.info((Object)("Ignoring exception while closing input stream '" + outputStream + "'"), (Throwable)e);
            }
        }
    }

    public static void close(Socket socket) {
        if (null != socket) {
            try {
                socket.close();
            }
            catch (IOException e) {
                LOGGER.info((Object)("Ignoring exception while closing input stream '" + socket + "'"), (Throwable)e);
            }
        }
    }
}

