/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium.grid.configuration;

import com.thoughtworks.selenium.grid.IOHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;

public class ResourceLocator {
    private final Class root;
    private static final int COPY_BUFFER_SIZE = 1024;

    public ResourceLocator(Class root) {
        this.root = root;
    }

    public String retrieveContent(String resourcePath) {
        String string;
        StringWriter writer = new StringWriter();
        InputStream inputStream = null;
        try {
            URL resource = this.root.getResource(resourcePath);
            if (null == resource) {
                throw new IllegalStateException("Could not find '" + resourcePath + "' in classpath. Root is " + this.root);
            }
            inputStream = resource.openStream();
            IOHelper.copyStream(inputStream, (Writer)writer, 1024);
            string = writer.toString();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOHelper.close(writer);
                IOHelper.close(inputStream);
                throw throwable;
            }
        }
        IOHelper.close(writer);
        IOHelper.close(inputStream);
        return string;
    }
}

