/*
 * Decompiled with CFR 0.152.
 */
package org.skife.waffles;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.AttachedArtifact;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public class MyMojo
extends AbstractMojo {
    private MavenProject project;
    private String flags = "";
    private String programFile = null;
    private String classifier;

    public void execute() throws MojoExecutionException {
        try {
            ArrayList<File> files = new ArrayList<File>();
            if (this.shouldProcess(this.project.getArtifact())) {
                files.add(this.project.getArtifact().getFile());
            }
            for (Object item : this.project.getAttachedArtifacts()) {
                AttachedArtifact artifact = (AttachedArtifact)item;
                if (!this.shouldProcess((Artifact)artifact)) continue;
                files.add(artifact.getFile());
            }
            if (files.isEmpty()) {
                throw new MojoExecutionException("Could not find any jars to make executable");
            }
            for (File file : files) {
                this.makeExecutable(file);
            }
            if (this.programFile != null && !this.programFile.matches("\\s+")) {
                for (File file : files) {
                    File dir = file.getParentFile();
                    File exec = new File(dir, this.programFile);
                    FileUtils.copyFile((File)file, (File)exec);
                    Runtime.getRuntime().exec("chmod +x " + exec.getAbsolutePath());
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException((Object)e, "FAILURE!", e.getMessage());
        }
    }

    private boolean shouldProcess(Artifact artifact) {
        this.getLog().debug((CharSequence)("Considering " + artifact));
        if (artifact == null) {
            return false;
        }
        if (!artifact.getType().equals("jar")) {
            return false;
        }
        return this.classifier == null || this.classifier.equals(artifact.getClassifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeExecutable(File file) throws IOException {
        this.getLog().debug((CharSequence)("Making " + file.getAbsolutePath() + " executable"));
        File tmp = File.createTempFile("waffles", ".tmp");
        try {
            FileUtils.rename((File)file, (File)tmp);
            FileOutputStream out = new FileOutputStream(file);
            FileInputStream in = new FileInputStream(tmp);
            out.write(("#!/bin/sh\n\nexec java " + this.flags + " -jar \"$0\" \"$@\"\n\n").getBytes("ASCII"));
            IOUtil.copy((InputStream)in, (OutputStream)out);
            in.close();
            out.close();
            Runtime.getRuntime().exec("chmod +x " + file.getAbsolutePath());
        }
        finally {
            tmp.delete();
        }
    }
}

