/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.edi;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.daffodil.japi.DataProcessor;
import org.apache.daffodil.japi.ValidationMode;
import org.smooks.api.ApplicationContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.resource.config.Parameter;
import org.smooks.cartridges.dfdl.DataProcessorFactory;
import org.smooks.cartridges.dfdl.DfdlSchema;

public class EdiDataProcessorFactory
extends DataProcessorFactory {
    @Inject
    protected ApplicationContext applicationContext;

    public DataProcessor createDataProcessor() {
        try {
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("{http://www.ibm.com/dfdl/EDI/Format}SegmentTerm", (String)this.resourceConfig.getParameterValue("segmentTerminator", String.class, (Object)"'%NL;%WSP*; '%WSP*;"));
            variables.put("{http://www.ibm.com/dfdl/EDI/Format}FieldSep", (String)this.resourceConfig.getParameterValue("dataElementSeparator", String.class, (Object)"+"));
            variables.put("{http://www.ibm.com/dfdl/EDI/Format}CompositeSep", (String)this.resourceConfig.getParameterValue("compositeDataElementSeparator", String.class, (Object)":"));
            variables.put("{http://www.ibm.com/dfdl/EDI/Format}EscapeChar", (String)this.resourceConfig.getParameterValue("escapeCharacter", String.class, (Object)"?"));
            variables.put("{http://www.ibm.com/dfdl/EDI/Format}RepeatSep", (String)this.resourceConfig.getParameterValue("repetitionSeparator", String.class, (Object)"*"));
            variables.put("{http://www.ibm.com/dfdl/EDI/Format}DecimalSep", (String)this.resourceConfig.getParameterValue("decimalSign", String.class, (Object)"."));
            variables.put("{http://www.ibm.com/dfdl/EDI/Format}GroupingSep", (String)this.resourceConfig.getParameterValue("triadSeparator", String.class, (Object)","));
            List variableParameters = this.resourceConfig.getParameters("variables");
            if (variableParameters != null) {
                for (Parameter variableParameter : variableParameters) {
                    Map.Entry variable = (Map.Entry)variableParameter.getValue();
                    variables.put((String)variable.getKey(), (String)variable.getValue());
                }
            }
            return this.doCreateDataProcessor(variables);
        }
        catch (Throwable t) {
            throw new SmooksConfigException(t);
        }
    }

    protected DataProcessor doCreateDataProcessor(Map<String, String> variables) throws URISyntaxException {
        DfdlSchema dfdlSchema = new DfdlSchema(new URI(this.schemaUri), variables, ValidationMode.valueOf((String)((String)this.resourceConfig.getParameterValue("validationMode", String.class, (Object)"Off"))), Boolean.parseBoolean((String)this.resourceConfig.getParameterValue("cacheOnDisk", String.class, (Object)"false")), Boolean.parseBoolean((String)this.resourceConfig.getParameterValue("debugging", String.class, (Object)"false")), null);
        return this.compileOrGet(dfdlSchema);
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

