/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.xml;

import java.io.IOException;
import java.util.Collection;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.smooks.assertion.AssertArgument;
import org.smooks.support.ClassUtil;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class XsdValidator {
    public static final String SCHEMA_FACTORY = XsdValidator.class.getName() + ".SchemaFactory";
    private SchemaFactory installedSchemaFactory;
    private LSResourceResolver schemaSourceResolver;
    private ErrorHandler errorHandler;
    private Schema schema;

    public void setSchemaFactory(SchemaFactory installedSchemaFactory) {
        this.installedSchemaFactory = installedSchemaFactory;
    }

    public void setSchemaSourceResolver(LSResourceResolver schemaSourceResolver) throws SAXException {
        this.assertSchemaNotInitialized();
        SchemaFactory schemaFactory = this.newSchemaFactory();
        this.schemaSourceResolver = schemaSourceResolver;
        this.schema = schemaFactory.newSchema();
    }

    public void setXSDSources(Collection<Source> xsdSources) throws SAXException {
        this.assertSchemaNotInitialized();
        AssertArgument.isNotNullAndNotEmpty(xsdSources, "xsdSources");
        Source[] xsdSourcesArray = xsdSources.toArray(new Source[0]);
        SchemaFactory schemaFactory = this.newSchemaFactory();
        this.schema = schemaFactory.newSchema(xsdSourcesArray);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void validate(Source source) throws SAXException, IOException {
        AssertArgument.isNotNull(source, "source");
        if (this.schema == null) {
            throw new IllegalStateException("Invalid call to validate.  XSD sources not set.");
        }
        Validator validator = this.schema.newValidator();
        if (this.schemaSourceResolver != null) {
            validator.setResourceResolver(this.schemaSourceResolver);
        }
        if (this.errorHandler != null) {
            validator.setErrorHandler(this.errorHandler);
        }
        validator.validate(source);
    }

    private void assertSchemaNotInitialized() {
        if (this.schema != null) {
            throw new IllegalStateException("Schema already initialised.");
        }
    }

    private SchemaFactory newSchemaFactory() {
        if (this.installedSchemaFactory != null) {
            return this.installedSchemaFactory;
        }
        String schemaFactoryClass = System.getProperty(SCHEMA_FACTORY);
        if (schemaFactoryClass != null) {
            try {
                return (SchemaFactory)ClassUtil.forName(schemaFactoryClass, this.getClass()).newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to create an instance of SchemaFactory '" + schemaFactoryClass + "'.", e);
            }
        }
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            schemaFactory.setProperty("http://apache.org/xml/properties/security-manager", null);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return schemaFactory;
    }
}

