/*-
 * ========================LICENSE_START=================================
 * Core
 * %%
 * Copyright (C) 2020 Smooks
 * %%
 * Licensed under the terms of the Apache License Version 2.0, or
 * the GNU Lesser General Public License version 3.0 or later.
 *
 * SPDX-License-Identifier: Apache-2.0 OR LGPL-3.0-or-later
 *
 * ======================================================================
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * ======================================================================
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * =========================LICENSE_END==================================
 */
package org.smooks.engine.delivery.sax.ng;

import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.delivery.ContentDeliveryConfig;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.api.Registry;
import org.smooks.api.resource.visitor.sax.ng.AfterVisitor;
import org.smooks.api.resource.visitor.sax.ng.BeforeVisitor;
import org.smooks.api.resource.visitor.sax.ng.ChildrenVisitor;
import org.smooks.engine.delivery.AbstractFilterProvider;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.engine.delivery.interceptor.InterceptorVisitorChainFactory;
import org.smooks.api.delivery.event.ConfigBuilderEvent;
import org.smooks.engine.delivery.event.DefaultConfigBuilderEvent;
import org.smooks.engine.lookup.InterceptorVisitorFactoryLookup;
import org.smooks.engine.lookup.NamespaceManagerLookup;

import java.util.List;
import java.util.Map;

public class SaxNgFilterProvider extends AbstractFilterProvider {

    @Override
    public ContentDeliveryConfig createContentDeliveryConfig(final List<ContentHandlerBinding<Visitor>> visitorBindings, final Registry registry, Map<String, List<ResourceConfig>> resourceConfigTable, final List<ConfigBuilderEvent> configBuilderEvents) {
        final SaxNgContentDeliveryConfig saxNgContentDeliveryConfig = new SaxNgContentDeliveryConfig();
        final InterceptorVisitorChainFactory interceptorVisitorChainFactory = registry.lookup(new InterceptorVisitorFactoryLookup());

        for (ContentHandlerBinding<Visitor> visitorBinding : visitorBindings) {
            visitorBinding.getResourceConfig().getSelectorPath().setNamespaces(registry.lookup(new NamespaceManagerLookup()));

            if (visitorBinding.getContentHandler() instanceof BeforeVisitor || visitorBinding.getContentHandler() instanceof AfterVisitor) {
                final ContentHandlerBinding<Visitor> interceptorChain = interceptorVisitorChainFactory.createInterceptorChain(visitorBinding);
                final String selector = interceptorChain.getResourceConfig().getSelectorPath().getTargetElement();
                final Visitor interceptorChainVisitor = interceptorChain.getContentHandler();
                if (interceptorChainVisitor instanceof BeforeVisitor && visitBeforeAnnotationsOK(visitorBinding.getContentHandler())) {
                    saxNgContentDeliveryConfig.getBeforeVisitorSelectorTable().put(selector, interceptorChain.getResourceConfig(), (BeforeVisitor) interceptorChainVisitor);
                    if (interceptorChainVisitor instanceof ChildrenVisitor) {
                        saxNgContentDeliveryConfig.getChildVisitorSelectorTable().put(selector, interceptorChain.getResourceConfig(), (ChildrenVisitor) interceptorChainVisitor);
                    }
                }
                if (interceptorChainVisitor instanceof AfterVisitor && visitAfterAnnotationsOK(visitorBinding.getContentHandler())) {
                    saxNgContentDeliveryConfig.getAfterVisitorSelectorTable().put(selector, interceptorChain.getResourceConfig(), (AfterVisitor) interceptorChainVisitor);
                    if (!(interceptorChainVisitor instanceof BeforeVisitor) && interceptorChainVisitor instanceof ChildrenVisitor) {
                        saxNgContentDeliveryConfig.getChildVisitorSelectorTable().put(selector, interceptorChain.getResourceConfig(), (ChildrenVisitor) interceptorChainVisitor);
                    }
                }
                configBuilderEvents.add(new DefaultConfigBuilderEvent(interceptorChain.getResourceConfig(), "Added as a SAX NG visitor."));
            }
        }
        
        saxNgContentDeliveryConfig.setRegistry(registry);
        saxNgContentDeliveryConfig.setResourceConfigs(resourceConfigTable);
        saxNgContentDeliveryConfig.getConfigBuilderEvents().addAll(configBuilderEvents);
        saxNgContentDeliveryConfig.assertSelectorsNotAccessingText();
        saxNgContentDeliveryConfig.addToExecutionLifecycleSets();
        
        return saxNgContentDeliveryConfig;
    }

    @Override
    public Boolean isProvider(List<ContentHandlerBinding<Visitor>> contentHandlerBindings) {
        return contentHandlerBindings.stream().filter(c -> c.getContentHandler() instanceof BeforeVisitor || c.getContentHandler() instanceof AfterVisitor).count() == contentHandlerBindings.size();
    }

    @Override
    public String getName() {
        return "SAX NG";
    }
}