/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.smooks.engine.delivery.sax.ng.org.apache.xerces.xs;

import org.smooks.engine.delivery.sax.ng.org.apache.xerces.xs.XSAnnotation;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.xs.XSModelGroup;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.xs.XSObject;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.xs.XSObjectList;

/**
 * This interface represents the Model Group Definition schema component.
 */
public interface XSModelGroupDefinition extends XSObject {
    /**
     * A model group. 
     */
    public XSModelGroup getModelGroup();

    /**
     * An annotation if it exists, otherwise <code>null</code>. If not null
     * then the first [annotation] from the sequence of annotations.
     */
    public XSAnnotation getAnnotation();

    /**
     * A sequence of [annotations] or an empty <code>XSObjectList</code>.
     */
    public XSObjectList getAnnotations();    
}
