/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.scanner.lib.internal.http.ScannerHttpClient;

class BootstrapIndexDownloader {
    private static final Logger LOG = LoggerFactory.getLogger(BootstrapIndexDownloader.class);
    private final ScannerHttpClient conn;

    BootstrapIndexDownloader(ScannerHttpClient conn) {
        this.conn = conn;
    }

    Collection<JarEntry> getIndex() {
        String index;
        try {
            LOG.debug("Get bootstrap index...");
            index = this.conn.callWebApi("/batch/index");
            LOG.debug("Get bootstrap completed");
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to get bootstrap index from server", e);
        }
        return this.parse(index);
    }

    private Collection<JarEntry> parse(String index) {
        String[] lines;
        ArrayList<JarEntry> entries = new ArrayList<JarEntry>();
        for (String line : lines = index.split("[\r\n]+")) {
            try {
                line = line.trim();
                String[] libAndHash = line.split("\\|");
                String filename = libAndHash[0];
                String hash = libAndHash[1];
                entries.add(new JarEntry(filename, hash));
            }
            catch (Exception e) {
                LOG.error("Failed bootstrap index response: {}", (Object)index);
                throw new IllegalStateException("Fail to parse entry in bootstrap index: " + line);
            }
        }
        return entries;
    }

    static class JarEntry {
        private String filename;
        private String hash;

        JarEntry(String filename, String hash) {
            this.filename = filename;
            this.hash = hash;
        }

        public String getFilename() {
            return this.filename;
        }

        public String getHash() {
            return this.hash;
        }
    }
}

