/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ClassloadRules {
    private final List<String> mask;
    private final List<String> unmask;

    public ClassloadRules(Set<String> maskRules, Set<String> unmaskRules) {
        this.mask = new ArrayList<String>(maskRules);
        this.unmask = new ArrayList<String>(unmaskRules);
    }

    public boolean canLoad(String className) {
        return this.unmaskSize(className) > this.maskSize(className);
    }

    private int maskSize(String className) {
        return ClassloadRules.findBestMatch(this.mask, className);
    }

    private int unmaskSize(String className) {
        return ClassloadRules.findBestMatch(this.unmask, className);
    }

    private static int findBestMatch(List<String> list, String name) {
        int bestMatch = -1;
        for (String s : list) {
            if (!name.startsWith(s) || s.length() <= bestMatch) continue;
            bestMatch = s.length();
        }
        return bestMatch;
    }
}

