/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib.internal;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.scanner.lib.Utils;

class TempCleaning {
    private static final Logger LOG = LoggerFactory.getLogger(TempCleaning.class);
    static final int ONE_DAY_IN_MILLISECONDS = 86400000;
    final Path tempDir;

    TempCleaning() {
        this(Paths.get(System.getProperty("java.io.tmpdir"), new String[0]));
    }

    TempCleaning(Path tempDir) {
        this.tempDir = tempDir;
    }

    void clean() {
        LOG.debug("Start temp cleaning...");
        long cutoff = System.currentTimeMillis() - 86400000L;
        try (Stream<Path> files = Files.list(this.tempDir);){
            files.filter(p -> p.getFileName().toString().startsWith("sonar-scanner-java-library-batch")).filter(p -> TempCleaning.lastModifiedTime(p) < cutoff).forEach(Utils::deleteQuietly);
            LOG.debug("Temp cleaning done");
        }
        catch (IOException e) {
            LOG.warn("Failed to clean files in {}", (Object)this.tempDir, (Object)e);
        }
    }

    private static long lastModifiedTime(Path file) {
        try {
            return Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            return System.currentTimeMillis();
        }
    }
}

