/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib.internal.http;

import java.io.InputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.KeyStore;
import java.security.Provider;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.X509TrustManager;
import nl.altindag.ssl.SSLFactory;
import nl.altindag.ssl.exception.GenericKeyStoreException;
import okhttp3.ConnectionSpec;
import okhttp3.CookieJar;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.JavaNetCookieJar;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.scanner.lib.internal.http.HttpConfig;
import org.sonarsource.scanner.lib.internal.http.ssl.CertificateStore;
import org.sonarsource.scanner.lib.internal.http.ssl.SslConfig;

public class OkHttpClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(OkHttpClientFactory.class);
    static final CookieManager COOKIE_MANAGER = new CookieManager();
    private static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    private static final JavaNetCookieJar COOKIE_JAR;

    private OkHttpClientFactory() {
    }

    static OkHttpClient create(HttpConfig httpConfig) {
        SSLFactory sslContext = OkHttpClientFactory.configureSsl(httpConfig.getSslConfig());
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder().connectTimeout(httpConfig.getConnectTimeout().toMillis(), TimeUnit.MILLISECONDS).readTimeout(httpConfig.getSocketTimeout().toMillis(), TimeUnit.MILLISECONDS).callTimeout(httpConfig.getResponseTimeout().toMillis(), TimeUnit.MILLISECONDS).cookieJar((CookieJar)COOKIE_JAR).sslSocketFactory(sslContext.getSslSocketFactory(), (X509TrustManager)sslContext.getTrustManager().orElseThrow());
        ConnectionSpec tls = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).allEnabledTlsVersions().allEnabledCipherSuites().build();
        okHttpClientBuilder.connectionSpecs(Arrays.asList(tls, ConnectionSpec.CLEARTEXT));
        if (httpConfig.getProxy() != null) {
            okHttpClientBuilder.proxy(httpConfig.getProxy());
        }
        if (StringUtils.isNotBlank((CharSequence)httpConfig.getProxyUser())) {
            okHttpClientBuilder.proxyAuthenticator((route, response) -> {
                if (response.request().header(PROXY_AUTHORIZATION) != null) {
                    return null;
                }
                if (407 == response.code()) {
                    String credential = Credentials.basic((String)httpConfig.getProxyUser(), (String)httpConfig.getProxyPassword(), (Charset)StandardCharsets.UTF_8);
                    return response.request().newBuilder().header(PROXY_AUTHORIZATION, credential).build();
                }
                return null;
            });
        }
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor(arg_0 -> ((Logger)LOG).debug(arg_0));
        logging.setLevel(HttpLoggingInterceptor.Level.BASIC);
        okHttpClientBuilder.addInterceptor((Interceptor)logging);
        return okHttpClientBuilder.build();
    }

    private static SSLFactory configureSsl(SslConfig sslConfig) {
        CertificateStore trustStoreConfig;
        CertificateStore keyStoreConfig;
        SSLFactory.Builder sslFactoryBuilder = SSLFactory.builder().withDefaultTrustMaterial().withSystemTrustMaterial();
        if (System.getProperties().containsKey("javax.net.ssl.keyStore")) {
            sslFactoryBuilder.withSystemPropertyDerivedIdentityMaterial();
        }
        if ((keyStoreConfig = sslConfig.getKeyStore()) != null && Files.exists(keyStoreConfig.getPath(), new LinkOption[0])) {
            sslFactoryBuilder.withIdentityMaterial(keyStoreConfig.getPath(), keyStoreConfig.getKeyStorePassword().toCharArray(), keyStoreConfig.getKeyStoreType());
        }
        if ((trustStoreConfig = sslConfig.getTrustStore()) != null && Files.exists(trustStoreConfig.getPath(), new LinkOption[0])) {
            KeyStore trustStore = OkHttpClientFactory.loadKeyStoreWithBouncyCastle(trustStoreConfig.getPath(), trustStoreConfig.getKeyStorePassword().toCharArray(), trustStoreConfig.getKeyStoreType());
            sslFactoryBuilder.withTrustMaterial(trustStore);
        }
        return sslFactoryBuilder.build();
    }

    public static KeyStore loadKeyStoreWithBouncyCastle(Path keystorePath, char[] keystorePassword, String keystoreType) {
        KeyStore keyStore;
        block8: {
            InputStream keystoreInputStream = Files.newInputStream(keystorePath, StandardOpenOption.READ);
            try {
                KeyStore keystore = KeyStore.getInstance(keystoreType, (Provider)new BouncyCastleProvider());
                keystore.load(keystoreInputStream, keystorePassword);
                keyStore = keystore;
                if (keystoreInputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (keystoreInputStream != null) {
                        try {
                            keystoreInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new GenericKeyStoreException((Throwable)e);
                }
            }
            keystoreInputStream.close();
        }
        return keyStore;
    }

    static {
        COOKIE_MANAGER.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        COOKIE_JAR = new JavaNetCookieJar((CookieHandler)COOKIE_MANAGER);
    }
}

