/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.rules;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.internal.apachecommons.lang.builder.ToStringBuilder;
import org.sonar.api.internal.google.common.base.Function;
import org.sonar.api.internal.google.common.collect.Lists;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.ActiveRuleParam;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleParam;
import org.sonar.api.rules.RulePriority;

public class ActiveRule
implements Cloneable {
    public static final String INHERITED = "INHERITED";
    public static final String OVERRIDES = "OVERRIDES";
    private Integer id;
    private Rule rule;
    private RulePriority severity;
    private RulesProfile rulesProfile;
    private List<ActiveRuleParam> activeRuleParams = new ArrayList<ActiveRuleParam>();
    private String inheritance;

    @Deprecated
    public ActiveRule() {
    }

    @Deprecated
    public ActiveRule(RulesProfile profile, Rule rule, RulePriority severity) {
        this.rule = rule;
        this.severity = severity == null && rule != null ? rule.getSeverity() : severity;
        this.rulesProfile = profile;
    }

    public Integer getId() {
        return this.id;
    }

    public String getInheritance() {
        return this.inheritance;
    }

    public void setInheritance(String s) {
        this.inheritance = s;
    }

    public boolean isInherited() {
        return StringUtils.equals(INHERITED, this.inheritance);
    }

    public boolean doesOverride() {
        return StringUtils.equals(OVERRIDES, this.inheritance);
    }

    @Deprecated
    public void setId(Integer id) {
        this.id = id;
    }

    public Rule getRule() {
        return this.rule;
    }

    @Deprecated
    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public RulePriority getSeverity() {
        return this.severity;
    }

    public void setSeverity(RulePriority severity) {
        this.severity = severity;
    }

    @Deprecated
    public RulePriority getPriority() {
        return this.severity;
    }

    @Deprecated
    public void setPriority(RulePriority priority) {
        this.severity = priority;
    }

    public RulesProfile getRulesProfile() {
        return this.rulesProfile;
    }

    @Deprecated
    public void setRulesProfile(RulesProfile rulesProfile) {
        this.rulesProfile = rulesProfile;
    }

    public List<ActiveRuleParam> getActiveRuleParams() {
        return this.activeRuleParams;
    }

    @Deprecated
    public void setActiveRuleParams(List<ActiveRuleParam> params) {
        this.activeRuleParams = params;
    }

    public ActiveRule setParameter(String key, String value) {
        RuleParam ruleParameter = this.rule.getParam(key);
        if (ruleParameter != null) {
            this.activeRuleParams.add(new ActiveRuleParam(this, ruleParameter, value));
        }
        return this;
    }

    public String getParameter(String key) {
        if (this.activeRuleParams != null) {
            for (ActiveRuleParam param : this.activeRuleParams) {
                if (!StringUtils.equals(key, param.getKey())) continue;
                return param.getValue();
            }
        }
        return null;
    }

    @Deprecated
    public String getPluginName() {
        return this.rule.getRepositoryKey();
    }

    public String getRepositoryKey() {
        return this.rule.getRepositoryKey();
    }

    public String getConfigKey() {
        return this.rule.getConfigKey();
    }

    public String getRuleKey() {
        return this.rule.getKey();
    }

    @CheckForNull
    @Deprecated
    public String getNoteData() {
        return null;
    }

    @CheckForNull
    @Deprecated
    public String getNoteUserLogin() {
        return null;
    }

    @CheckForNull
    @Deprecated
    public Date getNoteCreatedAt() {
        return null;
    }

    @CheckForNull
    @Deprecated
    public Date getNoteUpdatedAt() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActiveRule that = (ActiveRule)o;
        if (!this.rule.equals(that.rule)) {
            return false;
        }
        return !(this.rulesProfile == null ? that.rulesProfile != null : !this.rulesProfile.equals(that.rulesProfile));
    }

    public int hashCode() {
        int result = this.rule.hashCode();
        result = 31 * result + (this.rulesProfile != null ? this.rulesProfile.hashCode() : 0);
        return result;
    }

    public String toString() {
        return new ToStringBuilder(this).append("id", this.getId()).append("rule", this.rule).append("priority", (Object)this.severity).append("params", this.activeRuleParams).toString();
    }

    public Object clone() {
        final ActiveRule clone = new ActiveRule(this.getRulesProfile(), this.getRule(), this.getSeverity());
        clone.setInheritance(this.getInheritance());
        if (this.activeRuleParams != null && !this.activeRuleParams.isEmpty()) {
            clone.setActiveRuleParams(Lists.transform(this.activeRuleParams, new Function<ActiveRuleParam, ActiveRuleParam>(){

                @Override
                public ActiveRuleParam apply(ActiveRuleParam input) {
                    ActiveRuleParam activeRuleParamClone = (ActiveRuleParam)input.clone();
                    activeRuleParamClone.setActiveRule(clone);
                    return activeRuleParamClone;
                }
            }));
        }
        return clone;
    }

    public boolean isEnabled() {
        return this.getRule() != null && this.getRule().isEnabled() != false;
    }
}

