/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.web;

import java.util.Set;
import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.internal.google.common.collect.ImmutableSortedSet;

public final class FilterColumn {
    public static final String ASC = "ASC";
    public static final String DESC = "DESC";
    public static final Set<String> DIRECTIONS = ImmutableSortedSet.of("ASC", "DESC");
    private final String family;
    private final String key;
    private final String sortDirection;
    private final boolean variation;

    private FilterColumn(String family, String key, String sortDirection, boolean variation) {
        Preconditions.checkArgument(DIRECTIONS.contains(sortDirection), "Valid directions are %s, not '%s'", DIRECTIONS, sortDirection);
        this.family = family;
        this.key = key;
        this.sortDirection = sortDirection;
        this.variation = variation;
    }

    public static FilterColumn create(String family, String key, String sortDirection, boolean variation) {
        return new FilterColumn(family, key, sortDirection, variation);
    }

    public String getFamily() {
        return this.family;
    }

    public String getKey() {
        return this.key;
    }

    public String getSortDirection() {
        return this.sortDirection;
    }

    public boolean isVariation() {
        return this.variation;
    }
}

