/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.measures;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonar.api.batch.BatchSide;
import org.sonar.api.batch.InstantiationStrategy;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.internal.apachecommons.lang.builder.ReflectionToStringBuilder;
import org.sonar.api.internal.apachecommons.lang.builder.ToStringStyle;
import org.sonar.api.internal.google.common.base.Function;
import org.sonar.api.internal.google.common.base.Objects;
import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.internal.google.common.collect.Lists;
import org.sonar.api.measures.Formula;
import org.sonar.api.server.ServerSide;

@BatchSide
@InstantiationStrategy(value="PER_BATCH")
@ServerSide
@ComputeEngineSide
public class Metric<G extends Serializable>
implements Serializable,
org.sonar.api.batch.measure.Metric<G> {
    public static final int DEFAULT_DECIMAL_SCALE = 1;
    public static final int MAX_DECIMAL_SCALE = 5;
    public static final int DIRECTION_WORST = -1;
    public static final int DIRECTION_BETTER = 1;
    public static final int DIRECTION_NONE = 0;
    private Integer id;
    private transient Formula formula;
    private String key;
    private String description;
    private ValueType type;
    private Integer direction;
    private String domain;
    private String name;
    private Boolean qualitative = Boolean.FALSE;
    private Boolean userManaged = Boolean.FALSE;
    private Boolean enabled = Boolean.TRUE;
    private Double worstValue;
    private Double bestValue;
    private Boolean optimizedBestValue;
    private Boolean hidden = Boolean.FALSE;
    private Boolean deleteHistoricalData;
    private Integer decimalScale;

    private Metric(Builder builder) {
        this.key = builder.key;
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.direction = builder.direction;
        this.domain = builder.domain;
        this.qualitative = builder.qualitative;
        this.enabled = Boolean.TRUE;
        this.worstValue = builder.worstValue;
        this.optimizedBestValue = builder.optimizedBestValue;
        this.bestValue = builder.bestValue;
        this.hidden = builder.hidden;
        this.formula = builder.formula;
        this.userManaged = builder.userManaged;
        this.deleteHistoricalData = builder.deleteHistoricalData;
        this.decimalScale = builder.decimalScale;
    }

    @Deprecated
    public Metric() {
    }

    @Deprecated
    public Metric(String key) {
        this(key, ValueType.INT);
    }

    @Deprecated
    public Metric(String key, ValueType type) {
        this(key, key, key, type, -1, Boolean.FALSE, null, false);
    }

    @Deprecated
    public Metric(String key, String name, String description, ValueType type, Integer direction, Boolean qualitative, String domain) {
        this(key, name, description, type, direction, qualitative, domain, false);
    }

    private Metric(String key, String name, String description, ValueType type, Integer direction, Boolean qualitative, @Nullable String domain, boolean userManaged) {
        this.key = key;
        this.description = description;
        this.type = type;
        this.direction = direction;
        this.domain = domain;
        this.name = name;
        this.qualitative = qualitative;
        this.userManaged = userManaged;
        if (ValueType.PERCENT == this.type) {
            this.bestValue = direction == 1 ? 100.0 : 0.0;
            this.worstValue = direction == 1 ? 0.0 : 100.0;
            this.decimalScale = 1;
        } else if (ValueType.FLOAT == this.type) {
            this.decimalScale = 1;
        }
    }

    public Integer getId() {
        return this.id;
    }

    public Metric<G> setId(@Nullable Integer id) {
        this.id = id;
        return this;
    }

    @Deprecated
    public Formula getFormula() {
        return this.formula;
    }

    @Deprecated
    public Metric<G> setFormula(Formula formula) {
        this.formula = formula;
        return this;
    }

    public Boolean getQualitative() {
        return this.qualitative;
    }

    public Metric<G> setQualitative(Boolean qualitative) {
        this.qualitative = qualitative;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public Metric<G> setKey(String key) {
        this.key = key;
        return this;
    }

    public ValueType getType() {
        return this.type;
    }

    public Metric<G> setType(ValueType type) {
        this.type = type;
        return this;
    }

    @CheckForNull
    public String getDescription() {
        return this.description;
    }

    public Metric<G> setDescription(@Nullable String description) {
        this.description = description;
        return this;
    }

    public Boolean getUserManaged() {
        return this.userManaged;
    }

    public Metric<G> setUserManaged(Boolean userManaged) {
        this.userManaged = userManaged;
        return this;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Metric<G> setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Integer getDirection() {
        return this.direction;
    }

    public Metric<G> setDirection(Integer direction) {
        this.direction = direction;
        return this;
    }

    public String getDomain() {
        return this.domain;
    }

    public Metric<G> setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Metric<G> setName(String name) {
        this.name = name;
        return this;
    }

    public Double getWorstValue() {
        return this.worstValue;
    }

    @CheckForNull
    public Double getBestValue() {
        return this.bestValue;
    }

    public Metric<G> setWorstValue(@Nullable Double d) {
        this.worstValue = d;
        return this;
    }

    public Metric<G> setBestValue(@Nullable Double bestValue) {
        this.bestValue = bestValue;
        return this;
    }

    public boolean isNumericType() {
        return ValueType.INT.equals((Object)this.type) || ValueType.FLOAT.equals((Object)this.type) || ValueType.PERCENT.equals((Object)this.type) || ValueType.BOOL.equals((Object)this.type) || ValueType.MILLISEC.equals((Object)this.type) || ValueType.RATING.equals((Object)this.type) || ValueType.WORK_DUR.equals((Object)this.type);
    }

    public boolean isDataType() {
        return ValueType.DATA.equals((Object)this.type) || ValueType.DISTRIB.equals((Object)this.type);
    }

    public boolean isPercentageType() {
        return ValueType.PERCENT.equals((Object)this.type);
    }

    public Metric<G> setOptimizedBestValue(@Nullable Boolean b) {
        this.optimizedBestValue = b;
        return this;
    }

    @CheckForNull
    public Boolean isOptimizedBestValue() {
        return this.optimizedBestValue;
    }

    public Boolean isHidden() {
        return this.hidden;
    }

    public Metric<G> setHidden(Boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public Boolean getDeleteHistoricalData() {
        return this.deleteHistoricalData;
    }

    @CheckForNull
    public Integer getDecimalScale() {
        return this.decimalScale;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Metric)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Metric other = (Metric)obj;
        return this.key.equals(other.getKey());
    }

    public String toString() {
        return new ReflectionToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).toString();
    }

    public Metric<G> merge(Metric with) {
        this.description = with.description;
        this.domain = with.domain;
        this.enabled = with.enabled;
        this.qualitative = with.qualitative;
        this.worstValue = with.worstValue;
        this.bestValue = with.bestValue;
        this.optimizedBestValue = with.optimizedBestValue;
        this.direction = with.direction;
        this.key = with.key;
        this.type = with.type;
        this.name = with.name;
        this.userManaged = with.userManaged;
        this.hidden = with.hidden;
        this.deleteHistoricalData = with.deleteHistoricalData;
        return this;
    }

    @Override
    public String key() {
        return this.getKey();
    }

    @Override
    public Class<G> valueType() {
        return this.getType().valueType();
    }

    public static final class Builder {
        private String key;
        private ValueType type;
        private String name;
        private String description;
        private Integer direction = 0;
        private Boolean qualitative = Boolean.FALSE;
        private String domain = null;
        private Formula formula;
        private Double worstValue;
        private Double bestValue;
        private boolean optimizedBestValue = false;
        private boolean hidden = false;
        private boolean userManaged = false;
        private boolean deleteHistoricalData = false;
        private Integer decimalScale = null;

        public Builder(String key, String name, ValueType type) {
            Preconditions.checkArgument(StringUtils.isNotBlank(key), "Metric key can not be blank");
            Preconditions.checkArgument(StringUtils.isNotBlank(name), "Name of metric %s must be set", key);
            Preconditions.checkArgument(type != null, "Type of metric %s must be set", key);
            this.key = key;
            this.name = name;
            this.type = type;
        }

        public Builder setDescription(String d) {
            this.description = d;
            return this;
        }

        public Builder setDirection(Integer d) {
            this.direction = d;
            return this;
        }

        public Builder setQualitative(Boolean b) {
            this.qualitative = b;
            return this;
        }

        public Builder setDomain(String d) {
            this.domain = d;
            return this;
        }

        @Deprecated
        public Builder setFormula(Formula f) {
            this.formula = f;
            return this;
        }

        public Builder setWorstValue(Double d) {
            this.worstValue = d;
            return this;
        }

        public Builder setBestValue(Double d) {
            this.bestValue = d;
            return this;
        }

        public Builder setOptimizedBestValue(boolean b) {
            this.optimizedBestValue = b;
            return this;
        }

        public Builder setHidden(boolean b) {
            this.hidden = b;
            return this;
        }

        public Builder setUserManaged(boolean b) {
            this.userManaged = b;
            return this;
        }

        public Builder setDeleteHistoricalData(boolean b) {
            this.deleteHistoricalData = b;
            return this;
        }

        public Builder setDecimalScale(int scale) {
            Preconditions.checkArgument(scale >= 0, "Scale of decimal metric %s must be positive: %d", this.key, scale);
            Preconditions.checkArgument(scale <= 5, "Scale of decimal metric [%s] must be less than or equal %s: %s", this.key, 5, scale);
            this.decimalScale = scale;
            return this;
        }

        public <G extends Serializable> Metric<G> create() {
            if (ValueType.PERCENT == this.type) {
                this.bestValue = this.direction == 1 ? 100.0 : 0.0;
                this.worstValue = this.direction == 1 ? 0.0 : 100.0;
                this.decimalScale = Objects.firstNonNull(this.decimalScale, 1);
            } else if (ValueType.FLOAT == this.type) {
                this.decimalScale = Objects.firstNonNull(this.decimalScale, 1);
            }
            return new Metric(this);
        }
    }

    public static enum Level {
        OK("Green"),
        WARN("Orange"),
        ERROR("Red");

        private static final List<String> NAMES;
        private String colorName;

        private Level(String colorName) {
            this.colorName = colorName;
        }

        public String getColorName() {
            return this.colorName;
        }

        public static List<String> names() {
            return NAMES;
        }

        static {
            NAMES = Lists.transform(Arrays.asList(Level.values()), new Function<Level, String>(){

                @Override
                @Nonnull
                public String apply(@Nonnull Level level) {
                    return level.name();
                }
            });
        }
    }

    public static enum ValueType {
        INT(Integer.class),
        FLOAT(Double.class),
        PERCENT(Double.class),
        BOOL(Boolean.class),
        STRING(String.class),
        MILLISEC(Long.class),
        DATA(String.class),
        LEVEL(Level.class),
        DISTRIB(String.class),
        RATING(Integer.class),
        WORK_DUR(Long.class);

        private final Class valueClass;

        private ValueType(Class valueClass) {
            this.valueClass = valueClass;
        }

        private Class valueType() {
            return this.valueClass;
        }

        public static String[] names() {
            ValueType[] values = ValueType.values();
            String[] names = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                names[i] = values[i].name();
            }
            return names;
        }
    }
}

