/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.internal.google.common.base.Objects;
import org.sonar.api.internal.google.common.collect.Lists;
import org.sonar.api.resources.InputFile;

@Deprecated
public final class InputFileUtils {
    private InputFileUtils() {
    }

    public static List<File> toFiles(Collection<InputFile> inputFiles) {
        ArrayList<File> files = new ArrayList<File>();
        for (InputFile inputFile : inputFiles) {
            files.add(inputFile.getFile());
        }
        return files;
    }

    public static String getRelativeDirectory(InputFile inputFile) {
        String relativePath = inputFile.getRelativePath();
        if (StringUtils.contains(relativePath, "/")) {
            return StringUtils.substringBeforeLast(relativePath, "/");
        }
        return "";
    }

    public static InputFile create(File basedir, File file) {
        String relativePath = InputFileUtils.getRelativePath(basedir, file);
        if (relativePath != null) {
            return InputFileUtils.create(basedir, relativePath);
        }
        return null;
    }

    public static InputFile create(File basedir, String relativePath) {
        return new DefaultInputFile(basedir, relativePath);
    }

    public static List<InputFile> create(File basedir, Collection<File> files) {
        ArrayList<InputFile> inputFiles = new ArrayList<InputFile>();
        for (File file : files) {
            InputFile inputFile = InputFileUtils.create(basedir, file);
            if (inputFile == null) continue;
            inputFiles.add(inputFile);
        }
        return inputFiles;
    }

    static String getRelativePath(File basedir, File file) {
        ArrayList<String> stack = Lists.newArrayList(file.getName());
        for (File cursor = file.getParentFile(); cursor != null; cursor = cursor.getParentFile()) {
            if (basedir.equals(cursor)) {
                return StringUtils.join(stack, "/");
            }
            stack.add(0, cursor.getName());
        }
        return null;
    }

    static final class DefaultInputFile
    implements InputFile {
        private File basedir;
        private String relativePath;

        DefaultInputFile(File basedir, String relativePath) {
            this.basedir = basedir;
            this.relativePath = relativePath;
        }

        @Override
        public File getFileBaseDir() {
            return this.basedir;
        }

        @Override
        public File getFile() {
            return new File(this.basedir, this.relativePath);
        }

        @Override
        public InputStream getInputStream() throws FileNotFoundException {
            return new BufferedInputStream(new FileInputStream(this.getFile()));
        }

        @Override
        public String getRelativePath() {
            return this.relativePath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof DefaultInputFile) {
                DefaultInputFile that = (DefaultInputFile)o;
                return Objects.equal(this.basedir, that.basedir) && Objects.equal(this.relativePath, that.relativePath);
            }
            return false;
        }

        public int hashCode() {
            int result = this.basedir.hashCode();
            result = 31 * result + this.relativePath.hashCode();
            return result;
        }

        public String toString() {
            return String.format("%s -> %s", this.basedir.getAbsolutePath(), this.relativePath);
        }
    }
}

