/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.detector.original;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.sonar.duplications.detector.ContainsInComparator;
import org.sonar.duplications.index.CloneGroup;
import org.sonar.duplications.index.ClonePart;
import org.sonar.duplications.utils.SortedListsUtils;

final class Filter {
    private final List<CloneGroup> filtered = new LinkedList<CloneGroup>();

    Filter() {
    }

    public List<CloneGroup> getResult() {
        return this.filtered;
    }

    public void add(CloneGroup current) {
        Iterator<CloneGroup> i = this.filtered.iterator();
        while (i.hasNext()) {
            CloneGroup earlier = i.next();
            if (Filter.containsIn(current, earlier)) {
                return;
            }
            if (!Filter.containsIn(earlier, current)) continue;
            i.remove();
        }
        this.filtered.add(current);
    }

    static boolean containsIn(CloneGroup first, CloneGroup second) {
        if (first.getCloneUnitLength() > second.getCloneUnitLength()) {
            return false;
        }
        List<ClonePart> firstParts = first.getCloneParts();
        List<ClonePart> secondParts = second.getCloneParts();
        return SortedListsUtils.contains(secondParts, firstParts, new ContainsInComparator(second.getCloneUnitLength(), first.getCloneUnitLength())) && SortedListsUtils.contains(firstParts, secondParts, ContainsInComparator.RESOURCE_ID_COMPARATOR);
    }
}

