/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.scan.filesystem;

import java.util.ArrayList;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.config.Settings;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.internal.google.common.collect.ObjectArrays;

@ScannerSide
public class FileExclusions {
    private final Settings settings;

    public FileExclusions(Settings settings) {
        this.settings = settings;
    }

    public String[] sourceInclusions() {
        return this.inclusions("sonar.inclusions");
    }

    public String[] testInclusions() {
        return this.inclusions("sonar.test.inclusions");
    }

    private String[] inclusions(String propertyKey) {
        String[] patterns = FileExclusions.sanitize(this.settings.getStringArray(propertyKey));
        ArrayList<String> list = new ArrayList<String>();
        for (String pattern : patterns) {
            if ("**/*".equals(pattern) || "file:**/*".equals(pattern)) continue;
            list.add(pattern);
        }
        return list.toArray(new String[list.size()]);
    }

    public String[] sourceExclusions() {
        return this.exclusions("sonar.global.exclusions", "sonar.exclusions");
    }

    public String[] testExclusions() {
        return this.exclusions("sonar.global.test.exclusions", "sonar.test.exclusions");
    }

    private String[] exclusions(String globalExclusionsProperty, String exclusionsProperty) {
        String[] globalExclusions = this.settings.getStringArray(globalExclusionsProperty);
        String[] exclusions = this.settings.getStringArray(exclusionsProperty);
        return FileExclusions.sanitize(ObjectArrays.concat(globalExclusions, exclusions, String.class));
    }

    private static String[] sanitize(String[] patterns) {
        for (int i = 0; i < patterns.length; ++i) {
            patterns[i] = StringUtils.trim(patterns[i]);
        }
        return patterns;
    }
}

