/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.index;

import org.sonar.duplications.CodeFragment;

public class ClonePart
implements CodeFragment {
    private final String resourceId;
    private final int startUnit;
    private final int startLine;
    private final int endLine;
    private int hash;

    public ClonePart(String resourceId, int startUnit, int startLine, int endLine) {
        this.resourceId = resourceId;
        this.startUnit = startUnit;
        this.startLine = startLine;
        this.endLine = endLine;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public int getUnitStart() {
        return this.startUnit;
    }

    @Override
    public int getStartLine() {
        return this.startLine;
    }

    @Override
    public int getEndLine() {
        return this.endLine;
    }

    public int getLines() {
        return this.endLine - this.startLine + 1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClonePart) {
            ClonePart another = (ClonePart)obj;
            return another.resourceId.equals(this.resourceId) && another.startLine == this.startLine && another.endLine == this.endLine && another.startUnit == this.startUnit;
        }
        return false;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = this.resourceId.hashCode();
            h = 31 * h + this.startLine;
            h = 31 * h + this.endLine;
            this.hash = h = 31 * h + this.startUnit;
        }
        return h;
    }

    public String toString() {
        return "'" + this.resourceId + "':[" + this.startUnit + "|" + this.startLine + "-" + this.endLine + "]";
    }
}

