/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.web;

import java.util.Set;
import org.sonar.api.internal.google.common.base.Joiner;
import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.internal.google.common.collect.ImmutableSortedSet;

public final class Criterion {
    private static final String METRIC_FAMILY = "metric";
    private static final String QUALIFIER_FAMILY = "qualifier";
    public static final String EQ = "eq";
    public static final String GT = "gt";
    public static final String GTE = "gte";
    public static final String LT = "lt";
    public static final String LTE = "lte";
    public static final Set<String> OPERATORS = ImmutableSortedSet.of("eq", "gt", "gte", "lt", "lte");
    private final String family;
    private final String key;
    private final String operator;
    private final Float value;
    private final String textValue;
    private final boolean variation;

    private Criterion(String family, String key, String operator, Float value, String textValue, boolean variation) {
        Preconditions.checkArgument(OPERATORS.contains(operator), "Valid operators are %s, not '%s'", OPERATORS, operator);
        this.family = family;
        this.key = key;
        this.operator = operator;
        this.value = value;
        this.textValue = textValue;
        this.variation = variation;
    }

    public static Criterion create(String family, String key, String operator, Float value, boolean variation) {
        return new Criterion(family, key, operator, value, null, variation);
    }

    public static Criterion create(String family, String key, String operator, String textValue, boolean variation) {
        return new Criterion(family, key, operator, null, textValue, variation);
    }

    public static Criterion createForMetric(String key, String operator, Float value, boolean variation) {
        return new Criterion(METRIC_FAMILY, key, operator, value, null, variation);
    }

    public static Criterion createForMetric(String key, String operator, String textValue, boolean variation) {
        return new Criterion(METRIC_FAMILY, key, operator, null, textValue, variation);
    }

    public static Criterion createForQualifier(Object ... values) {
        return new Criterion(QUALIFIER_FAMILY, null, EQ, null, Joiner.on(',').join(values), false);
    }

    public String getFamily() {
        return this.family;
    }

    public String getKey() {
        return this.key;
    }

    public String getOperator() {
        return this.operator;
    }

    public Float getValue() {
        return this.value;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public boolean isVariation() {
        return this.variation;
    }
}

