/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.statement;

import java.util.ArrayList;
import java.util.List;
import org.sonar.duplications.statement.Statement;
import org.sonar.duplications.statement.matcher.TokenMatcher;
import org.sonar.duplications.token.Token;
import org.sonar.duplications.token.TokenQueue;

public final class StatementChannel {
    private final TokenMatcher[] tokenMatchers;
    private final boolean blackHole;

    private StatementChannel(boolean blackHole, TokenMatcher ... tokenMatchers) {
        if (tokenMatchers == null || tokenMatchers.length == 0) {
            throw new IllegalArgumentException();
        }
        this.blackHole = blackHole;
        this.tokenMatchers = tokenMatchers;
    }

    public static StatementChannel create(TokenMatcher ... tokenMatchers) {
        return new StatementChannel(false, tokenMatchers);
    }

    public static StatementChannel createBlackHole(TokenMatcher ... tokenMatchers) {
        return new StatementChannel(true, tokenMatchers);
    }

    public boolean consume(TokenQueue tokenQueue, List<Statement> output) {
        ArrayList<Token> matchedTokenList = new ArrayList<Token>();
        for (TokenMatcher tokenMatcher : this.tokenMatchers) {
            if (tokenMatcher.matchToken(tokenQueue, matchedTokenList)) continue;
            tokenQueue.pushForward(matchedTokenList);
            return false;
        }
        if (!this.blackHole && !matchedTokenList.isEmpty()) {
            output.add(new Statement(matchedTokenList));
        }
        return true;
    }
}

