/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.rule;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.api.utils.FieldUtils2;
import org.sonar.api.utils.SonarException;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

public class Checks<C> {
    private final ActiveRules activeRules;
    private final String repository;
    private final Map<RuleKey, C> checkByRule = new HashMap<RuleKey, C>();
    private final Map<C, RuleKey> ruleByCheck = new IdentityHashMap<C, RuleKey>();

    Checks(ActiveRules activeRules, String repository) {
        this.activeRules = activeRules;
        this.repository = repository;
    }

    @CheckForNull
    public C of(RuleKey ruleKey) {
        return this.checkByRule.get(ruleKey);
    }

    public Collection<C> all() {
        return this.checkByRule.values();
    }

    @CheckForNull
    public RuleKey ruleKey(C check) {
        return this.ruleByCheck.get(check);
    }

    private void add(RuleKey ruleKey, C obj) {
        this.checkByRule.put(ruleKey, obj);
        this.ruleByCheck.put(obj, ruleKey);
    }

    public Checks<C> addAnnotatedChecks(Object ... checkClassesOrObjects) {
        return this.addAnnotatedChecks((Iterable)Arrays.asList(checkClassesOrObjects));
    }

    @Deprecated
    public Checks<C> addAnnotatedChecks(Collection checkClassesOrObjects) {
        return this.addAnnotatedChecks((Iterable)checkClassesOrObjects);
    }

    public Checks<C> addAnnotatedChecks(Iterable checkClassesOrObjects) {
        String engineKey;
        HashMap checksByEngineKey = new HashMap();
        for (Object checkClassesOrObject : checkClassesOrObjects) {
            engineKey = Checks.annotatedEngineKey(checkClassesOrObject);
            if (engineKey == null) continue;
            checksByEngineKey.put(engineKey, checkClassesOrObject);
        }
        for (ActiveRule activeRule : this.activeRules.findByRepository(this.repository)) {
            engineKey = StringUtils.defaultIfBlank(activeRule.templateRuleKey(), activeRule.ruleKey().rule());
            Object checkClassesOrObject = checksByEngineKey.get(engineKey);
            if (checkClassesOrObject == null) continue;
            Object obj = Checks.instantiate(activeRule, checkClassesOrObject);
            this.add(activeRule.ruleKey(), obj);
        }
        return this;
    }

    private static String annotatedEngineKey(Object annotatedClassOrObject) {
        String key = null;
        Rule ruleAnnotation = AnnotationUtils.getAnnotation(annotatedClassOrObject, Rule.class);
        if (ruleAnnotation != null) {
            key = ruleAnnotation.key();
        }
        Class clazz = annotatedClassOrObject.getClass();
        if (annotatedClassOrObject instanceof Class) {
            clazz = (Class)annotatedClassOrObject;
        }
        return StringUtils.defaultIfEmpty(key, clazz.getCanonicalName());
    }

    private static Object instantiate(ActiveRule activeRule, Object checkClassOrInstance) {
        try {
            Object check = checkClassOrInstance;
            if (check instanceof Class) {
                check = ((Class)checkClassOrInstance).newInstance();
            }
            Checks.configureFields(activeRule, check);
            return check;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw Checks.failToInstantiateCheck(activeRule, checkClassOrInstance, e);
        }
    }

    private static RuntimeException failToInstantiateCheck(ActiveRule activeRule, Object checkClassOrInstance, Exception e) {
        throw new IllegalStateException(String.format("Fail to instantiate class %s for rule %s", checkClassOrInstance, activeRule.ruleKey()), e);
    }

    private static void configureFields(ActiveRule activeRule, Object check) {
        for (Map.Entry<String, String> param : activeRule.params().entrySet()) {
            Field field = Checks.getField(check, param.getKey());
            if (field == null) {
                throw new IllegalStateException(String.format("The field '%s' does not exist or is not annotated with @RuleProperty in the class %s", param.getKey(), check.getClass().getName()));
            }
            if (!StringUtils.isNotBlank(param.getValue())) continue;
            Checks.configureField(check, field, param.getValue());
        }
    }

    @CheckForNull
    private static Field getField(Object check, String key) {
        List<Field> fields = FieldUtils2.getFields(check.getClass(), true);
        for (Field field : fields) {
            RuleProperty propertyAnnotation = field.getAnnotation(RuleProperty.class);
            if (propertyAnnotation == null || !StringUtils.equals(key, field.getName()) && !StringUtils.equals(key, propertyAnnotation.key())) continue;
            return field;
        }
        return null;
    }

    private static void configureField(Object check, Field field, String value) {
        block13: {
            try {
                field.setAccessible(true);
                if (field.getType().equals(String.class)) {
                    field.set(check, value);
                    break block13;
                }
                if (Integer.TYPE == field.getType()) {
                    field.setInt(check, Integer.parseInt(value));
                    break block13;
                }
                if (Short.TYPE == field.getType()) {
                    field.setShort(check, Short.parseShort(value));
                    break block13;
                }
                if (Long.TYPE == field.getType()) {
                    field.setLong(check, Long.parseLong(value));
                    break block13;
                }
                if (Double.TYPE == field.getType()) {
                    field.setDouble(check, Double.parseDouble(value));
                    break block13;
                }
                if (Boolean.TYPE == field.getType()) {
                    field.setBoolean(check, Boolean.parseBoolean(value));
                    break block13;
                }
                if (Byte.TYPE == field.getType()) {
                    field.setByte(check, Byte.parseByte(value));
                    break block13;
                }
                if (Integer.class == field.getType()) {
                    field.set(check, Integer.parseInt(value));
                    break block13;
                }
                if (Long.class == field.getType()) {
                    field.set(check, Long.parseLong(value));
                    break block13;
                }
                if (Double.class == field.getType()) {
                    field.set(check, Double.parseDouble(value));
                    break block13;
                }
                if (Boolean.class == field.getType()) {
                    field.set(check, Boolean.parseBoolean(value));
                    break block13;
                }
                throw new SonarException("The type of the field " + field + " is not supported: " + field.getType());
            }
            catch (IllegalAccessException e) {
                throw new SonarException("Can not set the value of the field " + field + " in the class: " + check.getClass().getName(), e);
            }
        }
    }
}

