/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.test.lexer;

import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import java.util.List;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

class HasCommentMatcher
extends BaseMatcher<List<Token>> {
    private final String commentValue;
    private final int commentLine;
    private final boolean originalValue;

    HasCommentMatcher(String commentValue) {
        this(commentValue, -1);
    }

    HasCommentMatcher(String commentValue, boolean originalValue) {
        this(commentValue, -1, originalValue);
    }

    public HasCommentMatcher(String commentValue, int commentLine) {
        this(commentValue, commentLine, false);
    }

    public HasCommentMatcher(String commentValue, int commentLine, boolean originalValue) {
        this.commentValue = commentValue;
        this.commentLine = commentLine;
        this.originalValue = originalValue;
    }

    public boolean matches(Object obj) {
        if (!(obj instanceof List)) {
            return false;
        }
        List tokens = (List)obj;
        for (Token token : tokens) {
            for (Trivia trivia : token.getTrivia()) {
                String value;
                if (!trivia.isComment() || !(value = this.originalValue ? trivia.getToken().getOriginalValue() : trivia.getToken().getValue()).equals(this.commentValue) || this.commentLine > -1 && trivia.getToken().getLine() != this.commentLine) continue;
                return true;
            }
        }
        return false;
    }

    public void describeTo(Description desc) {
        if (this.originalValue) {
            desc.appendText("Comment('" + this.commentValue + "')");
        } else {
            desc.appendText("OriginalComment('" + this.commentValue + "')");
        }
    }
}

