/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.toolkit;

import com.sonar.sslr.api.Token;
import java.util.HashMap;
import java.util.Map;

public class LineOffsets {
    private static final String NEWLINE_REGEX = "(\r)?\n|\r";
    private final Map<Integer, Integer> lineOffsets = new HashMap<Integer, Integer>();
    private final int endOffset;

    public LineOffsets(String code) {
        int currentOffset = 0;
        String[] lines = code.split(NEWLINE_REGEX, -1);
        for (int line = 1; line <= lines.length; ++line) {
            this.lineOffsets.put(line, currentOffset);
            currentOffset += lines[line - 1].length() + 1;
        }
        this.endOffset = currentOffset - 1;
    }

    public int getStartOffset(Token token) {
        return this.getOffset(token.getLine(), token.getColumn());
    }

    public int getEndOffset(Token token) {
        String[] tokenLines = token.getOriginalValue().split(NEWLINE_REGEX, -1);
        int tokenLastLine = token.getLine() + tokenLines.length - 1;
        int tokenLastLineColumn = (tokenLines.length > 1 ? 0 : token.getColumn()) + tokenLines[tokenLines.length - 1].length();
        return this.getOffset(tokenLastLine, tokenLastLineColumn);
    }

    public int getOffset(int line, int column) {
        if (line < 1) {
            throw new IllegalArgumentException();
        }
        if (column < 0) {
            throw new IllegalArgumentException();
        }
        if (this.lineOffsets.containsKey(line)) {
            return Math.min(this.lineOffsets.get(line) + column, this.endOffset);
        }
        return this.endOffset;
    }
}

