/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.toolkit;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.sonar.sslr.toolkit.ValidationCallback;

public class Validators {
    private static final CharsetValidator CHARSET_VALIDATOR = new CharsetValidator();
    private static final BooleanValidator BOOLEAN_VALIDATOR = new BooleanValidator();

    private Validators() {
    }

    public static ValidationCallback charsetValidator() {
        return CHARSET_VALIDATOR;
    }

    public static ValidationCallback integerRangeValidator(int lowerBound, int upperBound) {
        return new IntegerRangeValidator(lowerBound, upperBound);
    }

    public static ValidationCallback booleanValidator() {
        return BOOLEAN_VALIDATOR;
    }

    private static class BooleanValidator
    implements ValidationCallback {
        private BooleanValidator() {
        }

        @Override
        public String validate(String newValueCandidate) {
            return !"false".equals(newValueCandidate) && !"true".equals(newValueCandidate) ? "Must be either \"true\" or \"false\": " + newValueCandidate : "";
        }
    }

    private static class IntegerRangeValidator
    implements ValidationCallback {
        private final int lowerBound;
        private final int upperBound;

        public IntegerRangeValidator(int lowerBound, int upperBound) {
            if (lowerBound > upperBound) {
                throw new IllegalArgumentException("lowerBound(" + lowerBound + ") <= upperBound(" + upperBound + ")");
            }
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
        }

        @Override
        public String validate(String newValueCandidate) {
            try {
                int value = Integer.parseInt(newValueCandidate);
                if (value < this.lowerBound || value > this.upperBound) {
                    return this.getErrorMessage(value);
                }
                return "";
            }
            catch (NumberFormatException e) {
                return "Not an integer: " + newValueCandidate;
            }
        }

        private String getErrorMessage(int value) {
            String errorMessage = this.lowerBound == this.upperBound ? "Must be equal to " + this.lowerBound + ": " + value : (this.upperBound == Integer.MAX_VALUE ? (this.lowerBound == 0 ? "Must be positive or 0: " + value : (this.lowerBound == 1 ? "Must be strictly positive: " + value : "Must be greater or equal to " + this.lowerBound + ": " + value)) : (this.lowerBound == Integer.MIN_VALUE ? (this.upperBound == 0 ? "Must be negative or 0: " + value : (this.upperBound == -1 ? "Must be strictly negative: " + value : "Must be lower or equal to " + this.upperBound + ": " + value)) : "Must be between " + this.lowerBound + " and " + this.upperBound + ": " + value));
            return errorMessage;
        }
    }

    private static class CharsetValidator
    implements ValidationCallback {
        private CharsetValidator() {
        }

        @Override
        public String validate(String newValueCandidate) {
            try {
                Charset.forName(newValueCandidate);
                return "";
            }
            catch (IllegalCharsetNameException e) {
                return "Illegal charset: " + e.getMessage();
            }
            catch (UnsupportedCharsetException e) {
                return "Unsupported charset: " + e.getMessage();
            }
        }
    }
}

