/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.toolkit;

import java.util.Objects;
import org.sonar.sslr.toolkit.ValidationCallback;

public class ConfigurationProperty {
    private static final ValidationCallback NO_VALIDATION = new ValidationCallback(){

        @Override
        public String validate(String newValueCandidate) {
            return "";
        }
    };
    private final String name;
    private final String description;
    private String value;
    private final ValidationCallback validationCallback;

    public ConfigurationProperty(String name, String description, String defaultValue) {
        this(name, description, defaultValue, NO_VALIDATION);
    }

    public ConfigurationProperty(String name, String description, String defaultValue, ValidationCallback validationCallback) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(description);
        Objects.requireNonNull(defaultValue);
        Objects.requireNonNull(validationCallback);
        String errorMessage = validationCallback.validate(defaultValue);
        if (!"".equals(errorMessage)) {
            throw new IllegalArgumentException("The default value \"" + defaultValue + "\" did not pass validation: " + errorMessage);
        }
        this.name = name;
        this.description = description;
        this.validationCallback = validationCallback;
        this.value = defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String validate(String newValueCandidate) {
        return this.validationCallback.validate(newValueCandidate);
    }

    public void setValue(String value) {
        String errorMessage = this.validate(value);
        if (!"".equals(errorMessage)) {
            throw new IllegalArgumentException("The value \"" + value + "\" did not pass validation: " + errorMessage);
        }
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}

