/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.correlation;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.ExtractOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.ForwardOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.ScriptOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.optimizer.correlation.AbstractCorrelationProcCtx;
import org.apache.hadoop.hive.ql.parse.OpParseContext;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;

public final class CorrelationUtilities {
    protected static boolean isExisted(ExprNodeDesc expr, List<ExprNodeDesc> columns) {
        for (ExprNodeDesc thisExpr : columns) {
            if (thisExpr == null || !thisExpr.isSame(expr)) continue;
            return true;
        }
        return false;
    }

    protected static String getColumnName(Map<String, ExprNodeDesc> opColumnExprMap, ExprNodeDesc expr) {
        for (Map.Entry<String, ExprNodeDesc> entry : opColumnExprMap.entrySet()) {
            ExprNodeDesc thisExpr = entry.getValue();
            if (thisExpr == null || !thisExpr.isSame(expr)) continue;
            return entry.getKey();
        }
        return null;
    }

    protected static boolean hasGroupingSet(ReduceSinkOperator cRS) throws SemanticException {
        GroupByOperator cGBYm = CorrelationUtilities.getSingleParent(cRS, GroupByOperator.class);
        return cGBYm != null && ((GroupByDesc)cGBYm.getConf()).isGroupingSetsPresent();
    }

    protected static Operator<?> getSingleParent(Operator<?> operator, boolean throwException) throws SemanticException {
        List<Operator<OperatorDesc>> parents = operator.getParentOperators();
        if (parents != null && parents.size() == 1) {
            return parents.get(0);
        }
        if (throwException) {
            if (parents == null) {
                throw new SemanticException("Operator " + operator.getName() + " (ID: " + operator.getIdentifier() + ") does not have any parent, but we expect 1 parent.");
            }
            if (parents.size() > 1) {
                throw new SemanticException("Operator " + operator.getName() + " (ID: " + operator.getIdentifier() + ") has " + parents.size() + " parents, but we expect 1 parent.");
            }
        }
        return null;
    }

    protected static Operator<?> getSingleParent(Operator<?> operator) throws SemanticException {
        return CorrelationUtilities.getSingleParent(operator, false);
    }

    protected static Operator<?> getSingleChild(Operator<?> operator, boolean throwException) throws SemanticException {
        List<Operator<OperatorDesc>> children = operator.getChildOperators();
        if (children != null && children.size() == 1) {
            return children.get(0);
        }
        if (throwException) {
            if (children == null) {
                throw new SemanticException("Operator " + operator.getName() + " (ID: " + operator.getIdentifier() + ") does not have any parent, but we expect 1 parent.");
            }
            if (children.size() > 1) {
                throw new SemanticException("Operator " + operator.getName() + " (ID: " + operator.getIdentifier() + ") has " + children.size() + " parents, but we expect 1 parent.");
            }
        }
        return null;
    }

    protected static Operator<?> getSingleChild(Operator<?> operator) throws SemanticException {
        return CorrelationUtilities.getSingleChild(operator, false);
    }

    protected static <T> T getSingleChild(Operator<?> operator, Class<T> type) throws SemanticException {
        Operator<?> parent = CorrelationUtilities.getSingleChild(operator);
        return (T)(type.isInstance(parent) ? parent : null);
    }

    protected static <T> T getSingleParent(Operator<?> operator, Class<T> type) throws SemanticException {
        Operator<?> parent = CorrelationUtilities.getSingleParent(operator);
        return (T)(type.isInstance(parent) ? parent : null);
    }

    protected static Operator<?> getStartForGroupBy(ReduceSinkOperator cRS) throws SemanticException {
        ReduceSinkOperator parent = CorrelationUtilities.getSingleParent(cRS);
        return parent instanceof GroupByOperator ? parent : cRS;
    }

    protected static boolean[] getSortedTags(JoinOperator joinOp) {
        boolean[] result = new boolean[joinOp.getParentOperators().size()];
        for (int tag = 0; tag < result.length; ++tag) {
            result[tag] = CorrelationUtilities.isSortedTag(joinOp, tag);
        }
        return result;
    }

    protected static boolean isSortedTag(JoinOperator joinOp, int tag) {
        block5: for (JoinCondDesc cond : ((JoinDesc)joinOp.getConf()).getConds()) {
            switch (cond.getType()) {
                case 1: {
                    if (cond.getRight() != tag) continue block5;
                    return false;
                }
                case 2: {
                    if (cond.getLeft() != tag) continue block5;
                    return false;
                }
                case 3: {
                    if (cond.getLeft() != tag && cond.getRight() != tag) continue block5;
                    return false;
                }
            }
        }
        return true;
    }

    protected static int indexOf(ExprNodeDesc cexpr, ExprNodeDesc[] pexprs, Operator child, Operator[] parents, boolean[] sorted) throws SemanticException {
        for (int tag = 0; tag < parents.length; ++tag) {
            if (!sorted[tag] || !pexprs[tag].isSame(ExprNodeDescUtils.backtrack(cexpr, child, parents[tag]))) continue;
            return tag;
        }
        return -1;
    }

    protected static <T extends Operator<?>> T findPossibleParent(Operator<?> start, Class<T> target, boolean trustScript) throws SemanticException {
        Operator[] parents = CorrelationUtilities.findPossibleParents(start, target, (boolean)trustScript);
        return (T)(parents != null && parents.length == 1 ? parents[0] : null);
    }

    protected static <T extends Operator<?>> T[] findPossibleParents(Operator<?> start, Class<T> target, boolean trustScript) throws SemanticException {
        Operator<?> cursor = CorrelationUtilities.getSingleParent(start);
        while (cursor != null) {
            if (target.isAssignableFrom(cursor.getClass())) {
                Operator[] array = (Operator[])Array.newInstance(target, 1);
                array[0] = cursor;
                return array;
            }
            if (cursor instanceof JoinOperator) {
                return CorrelationUtilities.findParents((JoinOperator)((JoinOperator)cursor), target);
            }
            if (cursor instanceof ScriptOperator && !trustScript) {
                return null;
            }
            if (!(cursor instanceof SelectOperator || cursor instanceof FilterOperator || cursor instanceof ExtractOperator || cursor instanceof ForwardOperator || cursor instanceof ScriptOperator || cursor instanceof ReduceSinkOperator)) {
                return null;
            }
            cursor = CorrelationUtilities.getSingleParent(cursor);
        }
        return null;
    }

    protected static <T extends Operator<?>> T[] findParents(JoinOperator join, Class<T> target) throws SemanticException {
        List<Operator<OperatorDesc>> parents = join.getParentOperators();
        Operator[] result = (Operator[])Array.newInstance(target, parents.size());
        for (int tag = 0; tag < result.length; ++tag) {
            Operator<OperatorDesc> cursor = parents.get(tag);
            while (cursor != null) {
                if (target.isAssignableFrom(cursor.getClass())) {
                    result[tag] = cursor;
                    break;
                }
                cursor = CorrelationUtilities.getSingleParent(cursor);
            }
            if (result[tag] != null) continue;
            throw new IllegalStateException("failed to find " + target.getSimpleName() + " from " + join + " on tag " + tag);
        }
        return result;
    }

    protected static TableScanOperator findTableScanOperator(Operator<? extends OperatorDesc> startPoint) {
        Operator<OperatorDesc> thisOp = startPoint.getParentOperators().get(0);
        while (true) {
            if (thisOp.getName().equals(ReduceSinkOperator.getOperatorName())) {
                return null;
            }
            if (thisOp.getName().equals(TableScanOperator.getOperatorName())) {
                return (TableScanOperator)thisOp;
            }
            if (thisOp.getParentOperators() == null) break;
            thisOp = thisOp.getParentOperators().get(0);
        }
        return null;
    }

    public static List<ReduceSinkOperator> findSiblingReduceSinkOperators(ReduceSinkOperator op) throws SemanticException {
        ArrayList<ReduceSinkOperator> siblingRSs = new ArrayList<ReduceSinkOperator>();
        Operator<?> child = CorrelationUtilities.getSingleChild(op, true);
        for (Operator<OperatorDesc> parent : child.getParentOperators()) {
            if (parent instanceof ReduceSinkOperator) {
                siblingRSs.add((ReduceSinkOperator)parent);
                continue;
            }
            throw new SemanticException("An sibling of a ReduceSinkOperatpr is not aReduceSinkOperatpr.");
        }
        return siblingRSs;
    }

    public static List<Operator<? extends OperatorDesc>> findSiblingOperators(Operator<? extends OperatorDesc> op) throws SemanticException {
        Operator<?> child = CorrelationUtilities.getSingleChild(op, true);
        return child.getParentOperators();
    }

    protected static SelectOperator replaceReduceSinkWithSelectOperator(ReduceSinkOperator childRS, ParseContext context, AbstractCorrelationProcCtx procCtx) throws SemanticException {
        SelectOperator select = CorrelationUtilities.replaceOperatorWithSelect(childRS, context, procCtx);
        ((SelectDesc)select.getConf()).setOutputColumnNames(((ReduceSinkDesc)childRS.getConf()).getOutputValueColumnNames());
        ((SelectDesc)select.getConf()).setColList(((ReduceSinkDesc)childRS.getConf()).getValueCols());
        return select;
    }

    protected static SelectOperator replaceOperatorWithSelect(Operator<?> operator, ParseContext context, AbstractCorrelationProcCtx procCtx) throws SemanticException {
        RowResolver inputRR = context.getOpParseCtx().get(operator).getRowResolver();
        SelectDesc select = new SelectDesc(null, null);
        Operator<?> parent = CorrelationUtilities.getSingleParent(operator);
        Operator<?> child = CorrelationUtilities.getSingleChild(operator);
        parent.getChildOperators().clear();
        SelectOperator sel = (SelectOperator)CorrelationUtilities.putOpInsertMap(OperatorFactory.getAndMakeChild(select, new RowSchema(inputRR.getColumnInfos()), parent), inputRR, context);
        sel.setColumnExprMap(operator.getColumnExprMap());
        sel.setChildOperators(operator.getChildOperators());
        for (Operator<OperatorDesc> ch : operator.getChildOperators()) {
            ch.replaceParent(operator, sel);
        }
        if (child instanceof ExtractOperator) {
            CorrelationUtilities.removeOperator(child, CorrelationUtilities.getSingleChild(child), sel, context);
            procCtx.addRemovedOperator(child);
        }
        operator.setChildOperators(null);
        operator.setParentOperators(null);
        procCtx.addRemovedOperator(operator);
        return sel;
    }

    protected static void removeReduceSinkForGroupBy(ReduceSinkOperator cRS, GroupByOperator cGBYr, ParseContext context, AbstractCorrelationProcCtx procCtx) throws SemanticException {
        Operator<?> parent = CorrelationUtilities.getSingleParent(cRS);
        if (parent instanceof GroupByOperator) {
            GroupByOperator cGBYm = (GroupByOperator)parent;
            ((GroupByDesc)cGBYr.getConf()).setKeys(ExprNodeDescUtils.backtrack(ExprNodeDescUtils.backtrack(((GroupByDesc)cGBYr.getConf()).getKeys(), cGBYr, cRS), cRS, cGBYm));
            ((GroupByDesc)cGBYr.getConf()).setAggregators(((GroupByDesc)cGBYm.getConf()).getAggregators());
            for (AggregationDesc aggr : ((GroupByDesc)cGBYm.getConf()).getAggregators()) {
                aggr.setMode(GenericUDAFEvaluator.Mode.COMPLETE);
            }
            cGBYr.setColumnExprMap(cGBYm.getColumnExprMap());
            cGBYr.setSchema(cGBYm.getSchema());
            RowResolver resolver = context.getOpParseCtx().get(cGBYm).getRowResolver();
            context.getOpParseCtx().get(cGBYr).setRowResolver(resolver);
        } else {
            ((GroupByDesc)cGBYr.getConf()).setKeys(ExprNodeDescUtils.backtrack(((GroupByDesc)cGBYr.getConf()).getKeys(), cGBYr, cRS));
            for (AggregationDesc aggr : ((GroupByDesc)cGBYr.getConf()).getAggregators()) {
                aggr.setParameters(ExprNodeDescUtils.backtrack(aggr.getParameters(), cGBYr, cRS));
            }
            Map<String, ExprNodeDesc> oldMap = cGBYr.getColumnExprMap();
            RowResolver oldRR = context.getOpParseCtx().get(cGBYr).getRowResolver();
            HashMap<String, ExprNodeDesc> newMap = new HashMap<String, ExprNodeDesc>();
            RowResolver newRR = new RowResolver();
            ArrayList<String> outputCols = ((GroupByDesc)cGBYr.getConf()).getOutputColumnNames();
            for (int i = 0; i < outputCols.size(); ++i) {
                String colName = (String)outputCols.get(i);
                String[] nm = oldRR.reverseLookup(colName);
                ColumnInfo colInfo = oldRR.get(nm[0], nm[1]);
                newRR.put(nm[0], nm[1], colInfo);
                ExprNodeDesc colExpr = ExprNodeDescUtils.backtrack(oldMap.get(colName), cGBYr, cRS);
                if (colExpr == null) continue;
                newMap.put(colInfo.getInternalName(), colExpr);
            }
            cGBYr.setColumnExprMap(newMap);
            cGBYr.setSchema(new RowSchema(newRR.getColumnInfos()));
            context.getOpParseCtx().get(cGBYr).setRowResolver(newRR);
        }
        ((GroupByDesc)cGBYr.getConf()).setMode(GroupByDesc.Mode.COMPLETE);
        CorrelationUtilities.removeOperator(cRS, cGBYr, parent, context);
        procCtx.addRemovedOperator(cRS);
        if (parent instanceof GroupByOperator) {
            CorrelationUtilities.removeOperator(parent, cGBYr, CorrelationUtilities.getSingleParent(parent), context);
            procCtx.addRemovedOperator(cGBYr);
        }
    }

    protected static void isNullOperator(Operator<?> operator) throws SemanticException {
        if (operator == null) {
            throw new SemanticException("Operator " + operator.getName() + " (ID: " + operator.getIdentifier() + ") is null.");
        }
    }

    protected static void insertOperatorBetween(Operator<?> newOperator, Operator<?> parent, Operator<?> child) throws SemanticException {
        CorrelationUtilities.isNullOperator(newOperator);
        CorrelationUtilities.isNullOperator(parent);
        CorrelationUtilities.isNullOperator(child);
        if (parent != CorrelationUtilities.getSingleParent(child)) {
            throw new SemanticException("Operator " + parent.getName() + " (ID: " + parent.getIdentifier() + ") is not the only parent of Operator " + child.getName() + " (ID: " + child.getIdentifier() + ")");
        }
        if (child != CorrelationUtilities.getSingleChild(parent)) {
            throw new SemanticException("Operator " + child.getName() + " (ID: " + child.getIdentifier() + ") is not the only child of Operator " + parent.getName() + " (ID: " + parent.getIdentifier() + ")");
        }
        newOperator.setParentOperators(Utilities.makeList(parent));
        newOperator.setChildOperators(Utilities.makeList(child));
        child.setParentOperators(Utilities.makeList(newOperator));
        parent.setChildOperators(Utilities.makeList(newOperator));
    }

    protected static void removeOperator(Operator<?> target, Operator<?> child, Operator<?> parent, ParseContext context) {
        for (Operator<OperatorDesc> aparent : target.getParentOperators()) {
            aparent.replaceChild(target, child);
        }
        for (Operator<OperatorDesc> achild : target.getChildOperators()) {
            achild.replaceParent(target, parent);
        }
        target.setChildOperators(null);
        target.setParentOperators(null);
        context.getOpParseCtx().remove(target);
    }

    protected static Operator<? extends Serializable> putOpInsertMap(Operator<?> op, RowResolver rr, ParseContext context) {
        OpParseContext ctx = new OpParseContext(rr);
        context.getOpParseCtx().put(op, ctx);
        return op;
    }
}

