/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.ppr;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;

public class PartExprEvalUtils {
    public static synchronized Object evalExprWithPart(ExprNodeDesc expr, LinkedHashMap<String, String> partSpec, List<VirtualColumn> vcs, StructObjectInspector rowObjectInspector) throws HiveException {
        boolean hasVC = vcs != null && !vcs.isEmpty();
        Object[] rowWithPart = new Object[hasVC ? 3 : 2];
        ArrayList<String> partNames = new ArrayList<String>();
        ArrayList<String> partValues = new ArrayList<String>();
        ArrayList<ObjectInspector> partObjectInspectors = new ArrayList<ObjectInspector>();
        for (Map.Entry<String, String> entry : partSpec.entrySet()) {
            partNames.add(entry.getKey());
            partValues.add(entry.getValue());
            partObjectInspectors.add(PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        }
        StandardStructObjectInspector partObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(partNames, partObjectInspectors);
        rowWithPart[1] = partValues;
        ArrayList<StructObjectInspector> ois = new ArrayList<StructObjectInspector>(2);
        ois.add(rowObjectInspector);
        ois.add(partObjectInspector);
        if (hasVC) {
            ois.add(VirtualColumn.getVCSObjectInspector(vcs));
        }
        UnionStructObjectInspector rowWithPartObjectInspector = ObjectInspectorFactory.getUnionStructObjectInspector(ois);
        ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get(expr);
        ObjectInspector evaluateResultOI = evaluator.initialize(rowWithPartObjectInspector);
        Object evaluateResultO = evaluator.evaluate(rowWithPart);
        return ((PrimitiveObjectInspector)evaluateResultOI).getPrimitiveJavaObject(evaluateResultO);
    }

    public static synchronized ObjectPair<PrimitiveObjectInspector, ExprNodeEvaluator> prepareExpr(ExprNodeDesc expr, List<String> partNames) throws HiveException {
        ArrayList<ObjectInspector> partObjectInspectors = new ArrayList<ObjectInspector>();
        for (int i = 0; i < partNames.size(); ++i) {
            partObjectInspectors.add(PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        }
        StandardStructObjectInspector objectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(partNames, partObjectInspectors);
        ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get(expr);
        ObjectInspector evaluateResultOI = evaluator.initialize(objectInspector);
        return ObjectPair.create((PrimitiveObjectInspector)evaluateResultOI, evaluator);
    }

    public static synchronized Object evaluateExprOnPart(ObjectPair<PrimitiveObjectInspector, ExprNodeEvaluator> pair, Object partColValues) throws HiveException {
        return pair.getFirst().getPrimitiveJavaObject(pair.getSecond().evaluate(partColValues));
    }
}

