/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.PlanUtils;

@Explain(displayName="Partition specification")
public class PartitionSpec {
    private final Map<String, PredicateSpec> partSpec = new LinkedHashMap<String, PredicateSpec>();

    public void addPredicate(String key, String operator, String value) {
        this.partSpec.put(key, new PredicateSpec(operator, value));
    }

    public boolean existsKey(String key) {
        return this.partSpec.get(key) != null;
    }

    public String toString() {
        StringBuilder filterString = new StringBuilder();
        int count = 0;
        for (Map.Entry<String, PredicateSpec> entry : this.partSpec.entrySet()) {
            if (count > 0) {
                filterString.append(" AND ");
            }
            filterString.append(entry.getKey() + " " + entry.getValue().toString());
            ++count;
        }
        return filterString.toString();
    }

    public Map<String, String> getPartSpecWithoutOperator() {
        LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
        for (Map.Entry<String, PredicateSpec> entry : this.partSpec.entrySet()) {
            partSpec.put(entry.getKey(), PlanUtils.stripQuotes(entry.getValue().getValue()));
        }
        return partSpec;
    }

    public boolean isNonEqualityOperator() {
        for (PredicateSpec predSpec : this.partSpec.values()) {
            if (predSpec.operator.equals("=")) continue;
            return true;
        }
        return false;
    }

    private class PredicateSpec {
        private String operator;
        private String value;

        public PredicateSpec() {
        }

        public PredicateSpec(String operator, String value) {
            this.operator = operator;
            this.value = value;
        }

        public String getOperator() {
            return this.operator;
        }

        public String getValue() {
            return this.value;
        }

        public void setOperator(String operator) {
            this.operator = operator;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return (this.operator.equals("!=") ? "<>" : this.operator) + " " + this.value;
        }
    }
}

