/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.udf.UDFBaseNumericOp;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;

@Description(name="%", value="a _FUNC_ b - Returns the remainder when dividing a by b")
public class UDFOPMod
extends UDFBaseNumericOp {
    @Override
    public ByteWritable evaluate(ByteWritable a, ByteWritable b) {
        if (a == null || b == null) {
            return null;
        }
        this.byteWritable.set((byte)(a.get() % b.get()));
        return this.byteWritable;
    }

    @Override
    public ShortWritable evaluate(ShortWritable a, ShortWritable b) {
        if (a == null || b == null) {
            return null;
        }
        this.shortWritable.set((short)(a.get() % b.get()));
        return this.shortWritable;
    }

    @Override
    public IntWritable evaluate(IntWritable a, IntWritable b) {
        if (a == null || b == null) {
            return null;
        }
        this.intWritable.set(a.get() % b.get());
        return this.intWritable;
    }

    @Override
    public LongWritable evaluate(LongWritable a, LongWritable b) {
        if (a == null || b == null) {
            return null;
        }
        this.longWritable.set(a.get() % b.get());
        return this.longWritable;
    }

    @Override
    public FloatWritable evaluate(FloatWritable a, FloatWritable b) {
        if (a == null || b == null) {
            return null;
        }
        this.floatWritable.set(a.get() % b.get());
        return this.floatWritable;
    }

    @Override
    public DoubleWritable evaluate(DoubleWritable a, DoubleWritable b) {
        if (a == null || b == null) {
            return null;
        }
        this.doubleWritable.set(a.get() % b.get());
        return this.doubleWritable;
    }

    @Override
    public HiveDecimalWritable evaluate(HiveDecimalWritable a, HiveDecimalWritable b) {
        if (a == null || b == null) {
            return null;
        }
        HiveDecimal av = a.getHiveDecimal();
        HiveDecimal bv = b.getHiveDecimal();
        if (bv.compareTo(HiveDecimal.ZERO) == 0) {
            return null;
        }
        try {
            this.decimalWritable.set(av.remainder(bv));
        }
        catch (NumberFormatException e) {
            return null;
        }
        return this.decimalWritable;
    }
}

