/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.ptf;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.PTFOperator;
import org.apache.hadoop.hive.ql.exec.PTFPartition;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.PTFInvocationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.plan.PTFDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.ptf.TableFunctionEvaluator;
import org.apache.hadoop.hive.ql.udf.ptf.TableFunctionResolver;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

public class WindowingTableFunction
extends TableFunctionEvaluator {
    @Override
    public void execute(PTFPartition.PTFPartitionIterator<Object> pItr, PTFPartition outP) throws HiveException {
        ArrayList<List> oColumns = new ArrayList<List>();
        PTFPartition iPart = pItr.getPartition();
        StructObjectInspector inputOI = iPart.getOutputOI();
        PTFDesc.WindowTableFunctionDef wTFnDef = (PTFDesc.WindowTableFunctionDef)this.getTableDef();
        PTFInvocationSpec.Order order = wTFnDef.getOrder().getExpressions().get(0).getOrder();
        for (PTFDesc.WindowFunctionDef wFn : wTFnDef.getWindowFunctions()) {
            boolean processWindow = this.processWindow(wFn);
            pItr.reset();
            if (!processWindow) {
                GenericUDAFEvaluator fEval = wFn.getWFnEval();
                Object[] objectArray = new Object[wFn.getArgs() == null ? 0 : wFn.getArgs().size()];
                GenericUDAFEvaluator.AggregationBuffer aggBuffer = fEval.getNewAggregationBuffer();
                while (pItr.hasNext()) {
                    Object row = pItr.next();
                    int i = 0;
                    if (wFn.getArgs() != null) {
                        for (PTFDesc.PTFExpressionDef arg : wFn.getArgs()) {
                            objectArray[i++] = arg.getExprEvaluator().evaluate(row);
                        }
                    }
                    fEval.aggregate(aggBuffer, objectArray);
                }
                SameList<Object> out = fEval.evaluate(aggBuffer);
                if (!wFn.isPivotResult()) {
                    out = new SameList<Object>(iPart.size(), out);
                }
                oColumns.add(out);
                continue;
            }
            oColumns.add(this.executeFnwithWindow(this.getQueryDef(), wFn, iPart, order));
        }
        for (int i = 0; i < iPart.size(); ++i) {
            ArrayList<Object> oRow = new ArrayList<Object>();
            Object iRow = iPart.getAt(i);
            for (int j = 0; j < oColumns.size(); ++j) {
                oRow.add(((List)oColumns.get(j)).get(i));
            }
            for (StructField structField : inputOI.getAllStructFieldRefs()) {
                oRow.add(inputOI.getStructFieldData(iRow, structField));
            }
            outP.append(oRow);
        }
    }

    private boolean processWindow(PTFDesc.WindowFunctionDef wFn) {
        PTFDesc.WindowFrameDef frame = wFn.getWindowFrame();
        if (frame == null) {
            return false;
        }
        return frame.getStart().getAmt() != WindowingSpec.BoundarySpec.UNBOUNDED_AMOUNT || frame.getEnd().getAmt() != WindowingSpec.BoundarySpec.UNBOUNDED_AMOUNT;
    }

    ArrayList<Object> executeFnwithWindow(PTFDesc ptfDesc, PTFDesc.WindowFunctionDef wFnDef, PTFPartition iPart, PTFInvocationSpec.Order order) throws HiveException {
        ArrayList<Object> vals = new ArrayList<Object>();
        GenericUDAFEvaluator fEval = wFnDef.getWFnEval();
        Object[] args = new Object[wFnDef.getArgs() == null ? 0 : wFnDef.getArgs().size()];
        for (int i = 0; i < iPart.size(); ++i) {
            GenericUDAFEvaluator.AggregationBuffer aggBuffer = fEval.getNewAggregationBuffer();
            Range rng = this.getRange(wFnDef, i, iPart, order);
            PTFPartition.PTFPartitionIterator<Object> rItr = rng.iterator();
            PTFOperator.connectLeadLagFunctionsToPartition(ptfDesc, rItr);
            while (rItr.hasNext()) {
                Object row = rItr.next();
                int j = 0;
                if (wFnDef.getArgs() != null) {
                    for (PTFDesc.PTFExpressionDef arg : wFnDef.getArgs()) {
                        args[j++] = arg.getExprEvaluator().evaluate(row);
                    }
                }
                fEval.aggregate(aggBuffer, args);
            }
            Object out = fEval.evaluate(aggBuffer);
            out = ObjectInspectorUtils.copyToStandardObject(out, wFnDef.getOI());
            vals.add(out);
        }
        return vals;
    }

    Range getRange(PTFDesc.WindowFunctionDef wFnDef, int currRow, PTFPartition p, PTFInvocationSpec.Order order) throws HiveException {
        int end;
        int start;
        PTFDesc.BoundaryDef startB = wFnDef.getWindowFrame().getStart();
        PTFDesc.BoundaryDef endB = wFnDef.getWindowFrame().getEnd();
        boolean rowFrame = true;
        if (startB instanceof PTFDesc.ValueBoundaryDef || endB instanceof PTFDesc.ValueBoundaryDef) {
            rowFrame = false;
        }
        if (rowFrame) {
            start = this.getRowBoundaryStart(startB, currRow);
            end = this.getRowBoundaryEnd(endB, currRow, p);
        } else {
            ValueBoundaryScanner vbs = startB instanceof PTFDesc.ValueBoundaryDef ? ValueBoundaryScanner.getScanner((PTFDesc.ValueBoundaryDef)startB, order) : ValueBoundaryScanner.getScanner((PTFDesc.ValueBoundaryDef)endB, order);
            vbs.reset(startB);
            start = vbs.computeStart(currRow, p);
            vbs.reset(endB);
            end = vbs.computeEnd(currRow, p);
        }
        start = start < 0 ? 0 : start;
        end = end > p.size() ? p.size() : end;
        return new Range(start, end, p);
    }

    int getRowBoundaryStart(PTFDesc.BoundaryDef b, int currRow) throws HiveException {
        WindowingSpec.Direction d = b.getDirection();
        int amt = b.getAmt();
        switch (d) {
            case PRECEDING: {
                if (amt == WindowingSpec.BoundarySpec.UNBOUNDED_AMOUNT) {
                    return 0;
                }
                return currRow - amt;
            }
            case CURRENT: {
                return currRow;
            }
            case FOLLOWING: {
                return currRow + amt;
            }
        }
        throw new HiveException("Unknown Start Boundary Direction: " + (Object)((Object)d));
    }

    int getRowBoundaryEnd(PTFDesc.BoundaryDef b, int currRow, PTFPartition p) throws HiveException {
        WindowingSpec.Direction d = b.getDirection();
        int amt = b.getAmt();
        switch (d) {
            case PRECEDING: {
                if (amt == 0) {
                    return currRow + 1;
                }
                return currRow - amt;
            }
            case CURRENT: {
                return currRow + 1;
            }
            case FOLLOWING: {
                if (amt == WindowingSpec.BoundarySpec.UNBOUNDED_AMOUNT) {
                    return p.size();
                }
                return currRow + amt + 1;
            }
        }
        throw new HiveException("Unknown End Boundary Direction: " + (Object)((Object)d));
    }

    public static class SameList<E>
    extends AbstractList<E> {
        int sz;
        E val;

        public SameList(int sz, E val) {
            this.sz = sz;
            this.val = val;
        }

        @Override
        public E get(int index) {
            return this.val;
        }

        @Override
        public int size() {
            return this.sz;
        }
    }

    public static class StringValueBoundaryScanner
    extends ValueBoundaryScanner {
        public StringValueBoundaryScanner(PTFDesc.BoundaryDef bndDef, PTFInvocationSpec.Order order, PTFDesc.PTFExpressionDef expressionDef) {
            super(bndDef, order, expressionDef);
        }

        @Override
        public boolean isGreater(Object v1, Object v2, int amt) {
            String s1 = PrimitiveObjectInspectorUtils.getString(v1, (PrimitiveObjectInspector)this.expressionDef.getOI());
            String s2 = PrimitiveObjectInspectorUtils.getString(v2, (PrimitiveObjectInspector)this.expressionDef.getOI());
            return s1 != null && s2 != null && s1.compareTo(s2) > 0;
        }

        @Override
        public boolean isEqual(Object v1, Object v2) {
            String s1 = PrimitiveObjectInspectorUtils.getString(v1, (PrimitiveObjectInspector)this.expressionDef.getOI());
            String s2 = PrimitiveObjectInspectorUtils.getString(v2, (PrimitiveObjectInspector)this.expressionDef.getOI());
            return s1 == null && s2 == null || s1.equals(s2);
        }
    }

    public static class DoubleValueBoundaryScanner
    extends ValueBoundaryScanner {
        public DoubleValueBoundaryScanner(PTFDesc.BoundaryDef bndDef, PTFInvocationSpec.Order order, PTFDesc.PTFExpressionDef expressionDef) {
            super(bndDef, order, expressionDef);
        }

        @Override
        public boolean isGreater(Object v1, Object v2, int amt) {
            double d2;
            double d1 = PrimitiveObjectInspectorUtils.getDouble(v1, (PrimitiveObjectInspector)this.expressionDef.getOI());
            return d1 - (d2 = PrimitiveObjectInspectorUtils.getDouble(v2, (PrimitiveObjectInspector)this.expressionDef.getOI())) > (double)amt;
        }

        @Override
        public boolean isEqual(Object v1, Object v2) {
            double d2;
            double d1 = PrimitiveObjectInspectorUtils.getDouble(v1, (PrimitiveObjectInspector)this.expressionDef.getOI());
            return d1 == (d2 = PrimitiveObjectInspectorUtils.getDouble(v2, (PrimitiveObjectInspector)this.expressionDef.getOI()));
        }
    }

    public static class LongValueBoundaryScanner
    extends ValueBoundaryScanner {
        public LongValueBoundaryScanner(PTFDesc.BoundaryDef bndDef, PTFInvocationSpec.Order order, PTFDesc.PTFExpressionDef expressionDef) {
            super(bndDef, order, expressionDef);
        }

        @Override
        public boolean isGreater(Object v1, Object v2, int amt) {
            long l2;
            long l1 = PrimitiveObjectInspectorUtils.getLong(v1, (PrimitiveObjectInspector)this.expressionDef.getOI());
            return l1 - (l2 = PrimitiveObjectInspectorUtils.getLong(v2, (PrimitiveObjectInspector)this.expressionDef.getOI())) > (long)amt;
        }

        @Override
        public boolean isEqual(Object v1, Object v2) {
            long l2;
            long l1 = PrimitiveObjectInspectorUtils.getLong(v1, (PrimitiveObjectInspector)this.expressionDef.getOI());
            return l1 == (l2 = PrimitiveObjectInspectorUtils.getLong(v2, (PrimitiveObjectInspector)this.expressionDef.getOI()));
        }
    }

    static abstract class ValueBoundaryScanner {
        PTFDesc.BoundaryDef bndDef;
        PTFInvocationSpec.Order order;
        PTFDesc.PTFExpressionDef expressionDef;

        public ValueBoundaryScanner(PTFDesc.BoundaryDef bndDef, PTFInvocationSpec.Order order, PTFDesc.PTFExpressionDef expressionDef) {
            this.bndDef = bndDef;
            this.order = order;
            this.expressionDef = expressionDef;
        }

        public void reset(PTFDesc.BoundaryDef bndDef) {
            this.bndDef = bndDef;
        }

        protected int computeStart(int rowIdx, PTFPartition p) throws HiveException {
            switch (this.bndDef.getDirection()) {
                case PRECEDING: {
                    return this.computeStartPreceding(rowIdx, p);
                }
                case CURRENT: {
                    return this.computeStartCurrentRow(rowIdx, p);
                }
            }
            return this.computeStartFollowing(rowIdx, p);
        }

        protected int computeStartPreceding(int rowIdx, PTFPartition p) throws HiveException {
            int amt = this.bndDef.getAmt();
            if (amt == WindowingSpec.BoundarySpec.UNBOUNDED_AMOUNT) {
                return 0;
            }
            Object sortKey = this.computeValue(p.getAt(rowIdx));
            if (sortKey == null) {
                if (this.order == PTFInvocationSpec.Order.ASC) {
                    return 0;
                }
                while (sortKey == null && rowIdx >= 0) {
                    if (--rowIdx < 0) continue;
                    sortKey = this.computeValue(p.getAt(rowIdx));
                }
                return rowIdx + 1;
            }
            Object rowVal = sortKey;
            int r = rowIdx;
            if (this.order == PTFInvocationSpec.Order.DESC) {
                while (r >= 0 && !this.isGreater(rowVal, sortKey, amt)) {
                    if (--r < 0) continue;
                    rowVal = this.computeValue(p.getAt(r));
                }
                return r + 1;
            }
            while (r >= 0 && !this.isGreater(sortKey, rowVal, amt)) {
                if (--r < 0) continue;
                rowVal = this.computeValue(p.getAt(r));
            }
            return r + 1;
        }

        protected int computeStartCurrentRow(int rowIdx, PTFPartition p) throws HiveException {
            Object sortKey = this.computeValue(p.getAt(rowIdx));
            if (sortKey == null) {
                while (sortKey == null && rowIdx >= 0) {
                    if (--rowIdx < 0) continue;
                    sortKey = this.computeValue(p.getAt(rowIdx));
                }
                return rowIdx + 1;
            }
            Object rowVal = sortKey;
            int r = rowIdx;
            while (r >= 0 && this.isEqual(rowVal, sortKey)) {
                if (--r < 0) continue;
                rowVal = this.computeValue(p.getAt(r));
            }
            return r + 1;
        }

        protected int computeStartFollowing(int rowIdx, PTFPartition p) throws HiveException {
            Object sortKey;
            int amt = this.bndDef.getAmt();
            Object rowVal = sortKey = this.computeValue(p.getAt(rowIdx));
            int r = rowIdx;
            if (sortKey == null) {
                if (this.order == PTFInvocationSpec.Order.DESC) {
                    return p.size();
                }
                while (r < p.size() && rowVal == null) {
                    if (++r >= p.size()) continue;
                    rowVal = this.computeValue(p.getAt(r));
                }
                return r;
            }
            if (this.order == PTFInvocationSpec.Order.DESC) {
                while (r < p.size() && !this.isGreater(sortKey, rowVal, amt)) {
                    if (++r >= p.size()) continue;
                    rowVal = this.computeValue(p.getAt(r));
                }
                return r;
            }
            while (r < p.size() && !this.isGreater(rowVal, sortKey, amt)) {
                if (++r >= p.size()) continue;
                rowVal = this.computeValue(p.getAt(r));
            }
            return r;
        }

        protected int computeEnd(int rowIdx, PTFPartition p) throws HiveException {
            switch (this.bndDef.getDirection()) {
                case PRECEDING: {
                    return this.computeEndPreceding(rowIdx, p);
                }
                case CURRENT: {
                    return this.computeEndCurrentRow(rowIdx, p);
                }
            }
            return this.computeEndFollowing(rowIdx, p);
        }

        protected int computeEndPreceding(int rowIdx, PTFPartition p) throws HiveException {
            int amt = this.bndDef.getAmt();
            Object sortKey = this.computeValue(p.getAt(rowIdx));
            if (sortKey == null) {
                if (this.order == PTFInvocationSpec.Order.DESC) {
                    return p.size();
                }
                return 0;
            }
            Object rowVal = sortKey;
            int r = rowIdx;
            if (this.order == PTFInvocationSpec.Order.DESC) {
                while (r >= 0 && !this.isGreater(rowVal, sortKey, amt)) {
                    if (--r < 0) continue;
                    rowVal = this.computeValue(p.getAt(r));
                }
                return r + 1;
            }
            while (r >= 0 && !this.isGreater(sortKey, rowVal, amt)) {
                if (--r < 0) continue;
                rowVal = this.computeValue(p.getAt(r));
            }
            return r + 1;
        }

        protected int computeEndCurrentRow(int rowIdx, PTFPartition p) throws HiveException {
            Object sortKey = this.computeValue(p.getAt(rowIdx));
            if (sortKey == null) {
                while (sortKey == null && rowIdx < p.size()) {
                    if (++rowIdx >= p.size()) continue;
                    sortKey = this.computeValue(p.getAt(rowIdx));
                }
                return rowIdx;
            }
            Object rowVal = sortKey;
            int r = rowIdx;
            while (r < p.size() && this.isEqual(sortKey, rowVal)) {
                if (++r >= p.size()) continue;
                rowVal = this.computeValue(p.getAt(r));
            }
            return r;
        }

        protected int computeEndFollowing(int rowIdx, PTFPartition p) throws HiveException {
            Object sortKey;
            int amt = this.bndDef.getAmt();
            if (amt == WindowingSpec.BoundarySpec.UNBOUNDED_AMOUNT) {
                return p.size();
            }
            Object rowVal = sortKey = this.computeValue(p.getAt(rowIdx));
            int r = rowIdx;
            if (sortKey == null) {
                if (this.order == PTFInvocationSpec.Order.DESC) {
                    return p.size();
                }
                while (r < p.size() && rowVal == null) {
                    if (++r >= p.size()) continue;
                    rowVal = this.computeValue(p.getAt(r));
                }
                return r;
            }
            if (this.order == PTFInvocationSpec.Order.DESC) {
                while (r < p.size() && !this.isGreater(sortKey, rowVal, amt)) {
                    if (++r >= p.size()) continue;
                    rowVal = this.computeValue(p.getAt(r));
                }
                return r;
            }
            while (r < p.size() && !this.isGreater(rowVal, sortKey, amt)) {
                if (++r >= p.size()) continue;
                rowVal = this.computeValue(p.getAt(r));
            }
            return r;
        }

        public Object computeValue(Object row) throws HiveException {
            Object o = this.expressionDef.getExprEvaluator().evaluate(row);
            return ObjectInspectorUtils.copyToStandardObject(o, this.expressionDef.getOI());
        }

        public abstract boolean isGreater(Object var1, Object var2, int var3);

        public abstract boolean isEqual(Object var1, Object var2);

        public static ValueBoundaryScanner getScanner(PTFDesc.ValueBoundaryDef vbDef, PTFInvocationSpec.Order order) throws HiveException {
            PrimitiveObjectInspector pOI = (PrimitiveObjectInspector)vbDef.getOI();
            switch (pOI.getPrimitiveCategory()) {
                case BYTE: 
                case INT: 
                case LONG: 
                case SHORT: 
                case TIMESTAMP: {
                    return new LongValueBoundaryScanner(vbDef, order, vbDef.getExpressionDef());
                }
                case DOUBLE: 
                case FLOAT: {
                    return new DoubleValueBoundaryScanner(vbDef, order, vbDef.getExpressionDef());
                }
                case STRING: {
                    return new StringValueBoundaryScanner(vbDef, order, vbDef.getExpressionDef());
                }
            }
            throw new HiveException(String.format("Internal Error: attempt to setup a Window for datatype %s", new Object[]{pOI.getPrimitiveCategory()}));
        }
    }

    static class Range {
        int start;
        int end;
        PTFPartition p;

        public Range(int start, int end, PTFPartition p) {
            this.start = start;
            this.end = end;
            this.p = p;
        }

        public PTFPartition.PTFPartitionIterator<Object> iterator() {
            return this.p.range(this.start, this.end);
        }
    }

    public static class WindowingTableFunctionResolver
    extends TableFunctionResolver {
        private transient StructObjectInspector wdwProcessingOutputOI;

        public StructObjectInspector getWdwProcessingOutputOI() {
            return this.wdwProcessingOutputOI;
        }

        public void setWdwProcessingOutputOI(StructObjectInspector wdwProcessingOutputOI) {
            this.wdwProcessingOutputOI = wdwProcessingOutputOI;
        }

        @Override
        protected TableFunctionEvaluator createEvaluator(PTFDesc ptfDesc, PTFDesc.PartitionedTableFunctionDef tDef) {
            return new WindowingTableFunction();
        }

        @Override
        public void setupOutputOI() throws SemanticException {
            this.setOutputOI(this.wdwProcessingOutputOI);
        }

        @Override
        public void initializeOutputOI() throws HiveException {
            this.setupOutputOI();
        }

        @Override
        public boolean transformsRawInput() {
            return false;
        }

        @Override
        public boolean carryForwardNames() {
            return true;
        }

        @Override
        public ArrayList<String> getOutputColumnNames() {
            return null;
        }
    }
}

