/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector.primitive;

import java.util.Arrays;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableBinaryObjectInspector;
import org.apache.hadoop.io.BytesWritable;

public class JavaBinaryObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements SettableBinaryObjectInspector {
    JavaBinaryObjectInspector() {
        super(PrimitiveObjectInspectorUtils.binaryTypeEntry);
    }

    public byte[] copyObject(Object o) {
        if (null == o) {
            return null;
        }
        byte[] incoming = (byte[])o;
        byte[] outgoing = new byte[incoming.length];
        System.arraycopy(incoming, 0, outgoing, 0, incoming.length);
        return outgoing;
    }

    @Override
    public BytesWritable getPrimitiveWritableObject(Object o) {
        return o == null ? null : new BytesWritable((byte[])o);
    }

    @Override
    public byte[] getPrimitiveJavaObject(Object o) {
        return (byte[])o;
    }

    public byte[] set(Object o, byte[] bb) {
        return bb == null ? null : Arrays.copyOf(bb, bb.length);
    }

    public byte[] set(Object o, BytesWritable bw) {
        return bw == null ? null : LazyUtils.createByteArray(bw);
    }

    public byte[] create(byte[] bb) {
        return bb == null ? null : Arrays.copyOf(bb, bb.length);
    }

    public byte[] create(BytesWritable bw) {
        return bw == null ? null : LazyUtils.createByteArray(bw);
    }
}

