/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.Stat;
import org.apache.hadoop.hive.ql.exec.TerminalOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.HivePartitioner;
import org.apache.hadoop.hive.ql.io.StatsProvidingRecordWriter;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveFatalException;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.SkewedColumnPositionPair;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.stats.StatsCollectionTaskIndependent;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SubStructObjectInspector;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.ReflectionUtils;

public class FileSinkOperator
extends TerminalOperator<FileSinkDesc>
implements Serializable {
    protected transient HashMap<String, FSPaths> valToPaths;
    protected transient int numDynParts;
    protected transient List<String> dpColNames;
    protected transient DynamicPartitionCtx dpCtx;
    protected transient boolean isCompressed;
    protected transient Path parent;
    protected transient HiveOutputFormat<?, ?> hiveOutputFormat;
    protected transient Path specPath;
    protected transient String childSpecPathDynLinkedPartitions;
    protected transient int dpStartCol;
    protected transient List<String> dpVals;
    protected transient List<Object> dpWritables;
    protected transient RecordWriter[] rowOutWriters;
    protected transient int maxPartitions;
    protected transient ListBucketingCtx lbCtx;
    protected transient boolean isSkewedStoredAsSubDirectories;
    protected transient boolean statsCollectRawDataSize;
    private transient boolean[] statsFromRecordWriter;
    private transient boolean isCollectRWStats;
    private transient FSPaths prevFsp;
    private transient FSPaths fpaths;
    private transient ObjectInspector keyOI;
    private transient List<Object> keyWritables;
    private transient List<String> keys;
    private transient int numKeyColToRead;
    private static final long serialVersionUID = 1L;
    protected transient FileSystem fs;
    protected transient Serializer serializer;
    protected transient LongWritable row_count;
    private transient boolean isNativeTable = true;
    private transient ExprNodeEvaluator[] partitionEval;
    protected transient int totalFiles;
    private transient int numFiles;
    protected transient boolean multiFileSpray;
    protected final transient Map<Integer, Integer> bucketMap = new HashMap<Integer, Integer>();
    private transient ObjectInspector[] partitionObjectInspectors;
    protected transient HivePartitioner<HiveKey, Object> prtner;
    protected final transient HiveKey key = new HiveKey();
    private transient Configuration hconf;
    protected transient FSPaths fsp;
    protected transient boolean bDynParts;
    private transient SubStructObjectInspector subSetOI;
    private transient int timeOut;
    private transient long lastProgressReport = System.currentTimeMillis();
    protected transient boolean autoDelete = false;
    protected transient JobConf jc;
    Class<? extends Writable> outputClass;
    String taskId;
    protected boolean filesCreated = false;
    protected Writable recordValue;

    private void initializeSpecPath() {
        if (!((FileSinkDesc)this.conf).isLinkedFileSink() || this.dpCtx == null) {
            this.specPath = ((FileSinkDesc)this.conf).getDirName();
            this.childSpecPathDynLinkedPartitions = null;
            return;
        }
        this.specPath = ((FileSinkDesc)this.conf).getParentDir();
        this.childSpecPathDynLinkedPartitions = ((FileSinkDesc)this.conf).getDirName().getName();
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        try {
            this.hconf = hconf;
            this.filesCreated = false;
            this.isNativeTable = !((FileSinkDesc)this.conf).getTableInfo().isNonNative();
            this.multiFileSpray = ((FileSinkDesc)this.conf).isMultiFileSpray();
            this.totalFiles = ((FileSinkDesc)this.conf).getTotalFiles();
            this.numFiles = ((FileSinkDesc)this.conf).getNumFiles();
            this.dpCtx = ((FileSinkDesc)this.conf).getDynPartCtx();
            this.lbCtx = ((FileSinkDesc)this.conf).getLbCtx();
            this.prevFsp = null;
            this.fsp = null;
            this.valToPaths = new HashMap();
            this.taskId = Utilities.getTaskId(hconf);
            this.initializeSpecPath();
            this.fs = this.specPath.getFileSystem(hconf);
            this.hiveOutputFormat = ((FileSinkDesc)this.conf).getTableInfo().getOutputFileFormatClass().newInstance();
            this.isCompressed = ((FileSinkDesc)this.conf).getCompressed();
            this.parent = Utilities.toTempPath(((FileSinkDesc)this.conf).getDirName());
            this.statsCollectRawDataSize = ((FileSinkDesc)this.conf).isStatsCollectRawDataSize();
            this.statsFromRecordWriter = new boolean[this.numFiles];
            this.serializer = (Serializer)((FileSinkDesc)this.conf).getTableInfo().getDeserializerClass().newInstance();
            this.serializer.initialize(null, ((FileSinkDesc)this.conf).getTableInfo().getProperties());
            this.outputClass = this.serializer.getSerializedClass();
            this.timeOut = hconf.getInt("mapred.healthChecker.script.timeout", 600000) / 2;
            this.jc = hconf instanceof JobConf ? (JobConf)hconf : new JobConf(hconf);
            if (this.multiFileSpray) {
                this.partitionEval = new ExprNodeEvaluator[((FileSinkDesc)this.conf).getPartitionCols().size()];
                int i = 0;
                for (ExprNodeDesc e : ((FileSinkDesc)this.conf).getPartitionCols()) {
                    this.partitionEval[i++] = ExprNodeEvaluatorFactory.get(e);
                }
                this.partitionObjectInspectors = FileSinkOperator.initEvaluators(this.partitionEval, this.outputObjInspector);
                this.prtner = (HivePartitioner)ReflectionUtils.newInstance((Class)this.jc.getPartitionerClass(), null);
            }
            this.row_count = new LongWritable();
            if (this.dpCtx != null) {
                this.dpSetup();
            }
            if (this.lbCtx != null) {
                this.lbSetup();
            }
            int numPart = 0;
            int numBuck = 0;
            if (((FileSinkDesc)this.conf).getPartitionCols() != null && !((FileSinkDesc)this.conf).getPartitionCols().isEmpty()) {
                numPart = ((FileSinkDesc)this.conf).getPartitionCols().size();
            }
            if (((FileSinkDesc)this.conf).getDpSortState().equals((Object)FileSinkDesc.DPSortState.PARTITION_BUCKET_SORTED)) {
                numBuck = 1;
            }
            this.numKeyColToRead = numPart + numBuck;
            this.keys = Lists.newArrayListWithCapacity((int)this.numKeyColToRead);
            this.keyWritables = Lists.newArrayListWithCapacity((int)this.numKeyColToRead);
            if (!this.bDynParts) {
                this.fsp = new FSPaths(this.specPath);
                if (!this.isSkewedStoredAsSubDirectories) {
                    this.valToPaths.put("", this.fsp);
                }
            }
            this.initializeChildren(hconf);
        }
        catch (HiveException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HiveException(e);
        }
    }

    private void lbSetup() {
        this.isSkewedStoredAsSubDirectories = this.lbCtx == null ? false : this.lbCtx.isSkewedStoredAsDir();
    }

    private void dpSetup() {
        this.bDynParts = false;
        this.numDynParts = this.dpCtx.getNumDPCols();
        this.dpColNames = this.dpCtx.getDPColNames();
        this.maxPartitions = this.dpCtx.getMaxPartitionsPerNode();
        assert (this.numDynParts == this.dpColNames.size()) : "number of dynamic paritions should be the same as the size of DP mapping";
        if (this.dpColNames != null && this.dpColNames.size() > 0) {
            this.bDynParts = true;
            assert (this.inputObjInspectors.length == 1) : "FileSinkOperator should have 1 parent, but it has " + this.inputObjInspectors.length;
            StructObjectInspector soi = (StructObjectInspector)this.inputObjInspectors[0];
            List fieldOI = soi.getAllStructFieldRefs();
            ArrayList<ObjectInspector> newFieldsOI = new ArrayList<ObjectInspector>();
            ArrayList<String> newFieldsName = new ArrayList<String>();
            this.dpStartCol = 0;
            for (StructField sf : fieldOI) {
                String fn = sf.getFieldName();
                if (this.dpCtx.getInputToDPCols().containsKey(fn)) continue;
                newFieldsOI.add(sf.getFieldObjectInspector());
                newFieldsName.add(sf.getFieldName());
                ++this.dpStartCol;
            }
            assert (newFieldsOI.size() > 0) : "new Fields ObjectInspector is empty";
            this.subSetOI = new SubStructObjectInspector(soi, 0, this.dpStartCol);
            this.dpVals = new ArrayList<String>(this.numDynParts);
            this.dpWritables = new ArrayList<Object>(this.numDynParts);
        }
    }

    protected void createBucketFiles(FSPaths fsp) throws HiveException {
        try {
            int filesIdx = 0;
            HashSet<Integer> seenBuckets = new HashSet<Integer>();
            for (int idx = 0; idx < this.totalFiles; ++idx) {
                if (this.getExecContext() != null && this.getExecContext().getFileId() != null) {
                    this.LOG.info((Object)"replace taskId from execContext ");
                    this.taskId = Utilities.replaceTaskIdFromFilename(this.taskId, this.getExecContext().getFileId());
                    this.LOG.info((Object)("new taskId: FS " + this.taskId));
                    assert (!this.multiFileSpray);
                    assert (this.totalFiles == 1);
                }
                if (this.multiFileSpray) {
                    int bucketNum;
                    int reducerIdx;
                    int currReducer;
                    this.key.setHashCode(idx);
                    int numReducers = this.totalFiles / this.numFiles;
                    if (numReducers > 1 && (currReducer = Integer.valueOf(Utilities.getTaskIdFromFilename(Utilities.getTaskId(this.hconf))).intValue()) != (reducerIdx = this.prtner.getPartition((Object)this.key, null, numReducers)) || seenBuckets.contains(bucketNum = this.prtner.getBucket(this.key, null, this.totalFiles))) continue;
                    seenBuckets.add(bucketNum);
                    this.bucketMap.put(bucketNum, filesIdx);
                    this.taskId = Utilities.replaceTaskIdFromFilename(Utilities.getTaskId(this.hconf), bucketNum);
                }
                this.createBucketForFileIdx(fsp, filesIdx);
                ++filesIdx;
            }
            assert (filesIdx == this.numFiles);
            if (this.isNativeTable) {
                this.autoDelete = this.fs.deleteOnExit(fsp.outPaths[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HiveException(e);
        }
        this.filesCreated = true;
    }

    protected void createBucketForFileIdx(FSPaths fsp, int filesIdx) throws HiveException {
        try {
            if (this.isNativeTable) {
                fsp.finalPaths[filesIdx] = fsp.getFinalPath(this.taskId, fsp.tmpPath, null);
                this.LOG.info((Object)("Final Path: FS " + fsp.finalPaths[filesIdx]));
                fsp.outPaths[filesIdx] = fsp.getTaskOutPath(this.taskId);
                this.LOG.info((Object)("Writing to temp file: FS " + fsp.outPaths[filesIdx]));
            } else {
                fsp.finalPaths[filesIdx] = fsp.outPaths[filesIdx] = this.specPath;
            }
            String extension = Utilities.getFileExtension(this.jc, this.isCompressed, this.hiveOutputFormat);
            fsp.finalPaths[filesIdx] = !this.bDynParts && !this.isSkewedStoredAsSubDirectories ? fsp.getFinalPath(this.taskId, this.parent, extension) : fsp.getFinalPath(this.taskId, fsp.tmpPath, extension);
            this.LOG.info((Object)("New Final Path: FS " + fsp.finalPaths[filesIdx]));
            if (this.isNativeTable) {
                this.autoDelete = this.fs.deleteOnExit(fsp.outPaths[filesIdx]);
            }
            Utilities.copyTableJobPropertiesToConf(((FileSinkDesc)this.conf).getTableInfo(), this.jc);
            fsp.outWriters[filesIdx] = HiveFileFormatUtils.getHiveRecordWriter(this.jc, ((FileSinkDesc)this.conf).getTableInfo(), this.outputClass, (FileSinkDesc)this.conf, fsp.outPaths[filesIdx], this.reporter);
            this.statsFromRecordWriter[filesIdx] = fsp.outWriters[filesIdx] instanceof StatsProvidingRecordWriter;
            if (this.reporter != null) {
                this.reporter.incrCounter(HiveConf.getVar((Configuration)this.hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVECOUNTERGROUP), "CREATED_FILES", 1L);
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    protected boolean updateProgress() {
        if (this.reporter != null && System.currentTimeMillis() - this.lastProgressReport > (long)this.timeOut) {
            this.reporter.progress();
            this.lastProgressReport = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        String lbDirName = null;
        String string = lbDirName = this.lbCtx == null ? null : this.generateListBucketingDirName(row);
        if (!this.bDynParts && !this.filesCreated) {
            if (lbDirName != null) {
                FSPaths fsp2 = this.lookupListBucketingPaths(lbDirName);
            } else {
                this.createBucketFiles(this.fsp);
            }
        }
        try {
            this.updateProgress();
            assert (this.inputObjInspectors[0].getCategory() == ObjectInspector.Category.STRUCT) : "input object inspector is not struct";
            if (this.bDynParts) {
                this.dpVals.clear();
                this.dpWritables.clear();
                ObjectInspectorUtils.partialCopyToStandardObject(this.dpWritables, (Object)row, (int)this.dpStartCol, (int)this.numDynParts, (StructObjectInspector)((StructObjectInspector)this.inputObjInspectors[0]), (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                for (Object o : this.dpWritables) {
                    if (o == null || o.toString().length() == 0) {
                        this.dpVals.add(this.dpCtx.getDefaultPartitionName());
                        continue;
                    }
                    this.dpVals.add(o.toString());
                }
                this.recordValue = this.serializer.serialize(row, (ObjectInspector)this.subSetOI);
                if (((FileSinkDesc)this.conf).getDpSortState().equals((Object)FileSinkDesc.DPSortState.NONE)) {
                    this.fpaths = this.getDynOutPaths(this.dpVals, lbDirName);
                }
            } else {
                this.fpaths = lbDirName != null ? this.lookupListBucketingPaths(lbDirName) : this.fsp;
                this.recordValue = this.serializer.serialize(row, this.inputObjInspectors[0]);
            }
            this.rowOutWriters = this.fpaths.outWriters;
            this.isCollectRWStats = this.areAllTrue(this.statsFromRecordWriter);
            if (((FileSinkDesc)this.conf).isGatherStats() && !this.isCollectRWStats) {
                SerDeStats stats;
                if (this.statsCollectRawDataSize && (stats = this.serializer.getSerDeStats()) != null) {
                    this.fpaths.stat.addToStat("rawDataSize", stats.getRawDataSize());
                }
                this.fpaths.stat.addToStat("numRows", 1L);
            }
            RecordWriter rowOutWriter = null;
            if (this.row_count != null) {
                this.row_count.set(this.row_count.get() + 1L);
            }
            if (!this.multiFileSpray) {
                rowOutWriter = this.rowOutWriters[0];
            } else {
                int keyHashCode = 0;
                for (int i = 0; i < this.partitionEval.length; ++i) {
                    Object o = this.partitionEval[i].evaluate(row);
                    keyHashCode = keyHashCode * 31 + ObjectInspectorUtils.hashCode((Object)o, (ObjectInspector)this.partitionObjectInspectors[i]);
                }
                this.key.setHashCode(keyHashCode);
                int bucketNum = this.prtner.getBucket(this.key, null, this.totalFiles);
                int idx = this.bucketMap.get(bucketNum);
                rowOutWriter = this.rowOutWriters[idx];
            }
            rowOutWriter.write(this.recordValue);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        catch (SerDeException e) {
            throw new HiveException(e);
        }
    }

    private boolean areAllTrue(boolean[] statsFromRW) {
        for (boolean b : statsFromRW) {
            if (b) continue;
            return false;
        }
        return true;
    }

    protected FSPaths lookupListBucketingPaths(String lbDirName) throws HiveException {
        FSPaths fsp2 = this.valToPaths.get(lbDirName);
        if (fsp2 == null) {
            fsp2 = this.createNewPaths(lbDirName);
        }
        return fsp2;
    }

    private FSPaths createNewPaths(String dirName) throws HiveException {
        FSPaths fsp2 = new FSPaths(this.specPath);
        if (this.childSpecPathDynLinkedPartitions != null) {
            fsp2.tmpPath = new Path(fsp2.tmpPath, dirName + "/" + this.childSpecPathDynLinkedPartitions);
            fsp2.taskOutputTempPath = new Path(fsp2.taskOutputTempPath, dirName + "/" + this.childSpecPathDynLinkedPartitions);
        } else {
            fsp2.tmpPath = new Path(fsp2.tmpPath, dirName);
            fsp2.taskOutputTempPath = new Path(fsp2.taskOutputTempPath, dirName);
        }
        if (!((FileSinkDesc)this.conf).getDpSortState().equals((Object)FileSinkDesc.DPSortState.PARTITION_BUCKET_SORTED)) {
            this.createBucketFiles(fsp2);
            this.valToPaths.put(dirName, fsp2);
        }
        return fsp2;
    }

    protected String generateListBucketingDirName(Object row) {
        if (!this.isSkewedStoredAsSubDirectories) {
            return null;
        }
        String lbDirName = null;
        ArrayList standObjs = new ArrayList();
        List<String> skewedCols = this.lbCtx.getSkewedColNames();
        List<List<String>> allSkewedVals = this.lbCtx.getSkewedColValues();
        ArrayList<String> skewedValsCandidate = null;
        Map<List<String>, String> locationMap = this.lbCtx.getLbLocationMap();
        ObjectInspectorUtils.copyToStandardObject(standObjs, (Object)row, (StructObjectInspector)((StructObjectInspector)this.inputObjInspectors[0]), (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        assert (standObjs.size() >= skewedCols.size()) : "The row has less number of columns than no. of skewed column.";
        skewedValsCandidate = new ArrayList<String>(skewedCols.size());
        for (SkewedColumnPositionPair posPair : this.lbCtx.getRowSkewedIndex()) {
            skewedValsCandidate.add(posPair.getSkewColPosition(), standObjs.get(posPair.getTblColPosition()).toString());
        }
        if (allSkewedVals.contains(skewedValsCandidate)) {
            lbDirName = FileUtils.makeListBucketingDirName(skewedCols, skewedValsCandidate);
            locationMap.put(skewedValsCandidate, lbDirName);
        } else {
            lbDirName = FileUtils.makeDefaultListBucketingDirName(skewedCols, (String)this.lbCtx.getDefaultDirName());
            List<String> defaultKey = Arrays.asList(this.lbCtx.getDefaultKey());
            if (!locationMap.containsKey(defaultKey)) {
                locationMap.put(defaultKey, lbDirName);
            }
        }
        return lbDirName;
    }

    protected FSPaths getDynOutPaths(List<String> row, String lbDirName) throws HiveException {
        FSPaths fp;
        String dpDir = this.getDynPartDirectory(row, this.dpColNames, this.numDynParts);
        String pathKey = null;
        if (dpDir != null) {
            FSPaths fsp2;
            pathKey = dpDir = this.appendToSource(lbDirName, dpDir);
            if (((FileSinkDesc)this.conf).getDpSortState().equals((Object)FileSinkDesc.DPSortState.PARTITION_BUCKET_SORTED)) {
                String buckNum = row.get(row.size() - 1);
                this.taskId = Utilities.replaceTaskIdFromFilename(Utilities.getTaskId(this.hconf), buckNum);
                pathKey = this.appendToSource(this.taskId, dpDir);
            }
            if ((fsp2 = this.valToPaths.get(pathKey)) == null) {
                if (this.valToPaths.size() > this.maxPartitions) {
                    throw new HiveFatalException(ErrorMsg.DYNAMIC_PARTITIONS_TOO_MANY_PER_NODE_ERROR.getErrorCodedMsg() + "Maximum was set to: " + this.maxPartitions);
                }
                if (!((FileSinkDesc)this.conf).getDpSortState().equals((Object)FileSinkDesc.DPSortState.NONE) && this.prevFsp != null) {
                    SerDeStats stats;
                    RecordWriter outWriter;
                    this.prevFsp.closeWriters(false);
                    if (((FileSinkDesc)this.conf).isGatherStats() && this.isCollectRWStats && (outWriter = this.prevFsp.outWriters[0]) != null && (stats = ((StatsProvidingRecordWriter)outWriter).getStats()) != null) {
                        this.prevFsp.stat.addToStat("rawDataSize", stats.getRawDataSize());
                        this.prevFsp.stat.addToStat("numRows", stats.getRowCount());
                    }
                    this.prevFsp.outWriters[0] = null;
                    this.prevFsp = null;
                }
                fsp2 = this.createNewPaths(dpDir);
                if (this.prevFsp == null) {
                    this.prevFsp = fsp2;
                }
                if (((FileSinkDesc)this.conf).getDpSortState().equals((Object)FileSinkDesc.DPSortState.PARTITION_BUCKET_SORTED)) {
                    this.createBucketForFileIdx(fsp2, 0);
                    this.valToPaths.put(pathKey, fsp2);
                }
            }
            fp = fsp2;
        } else {
            fp = this.fsp;
        }
        return fp;
    }

    private String appendToSource(String appendDir, String srcDir) {
        StringBuilder builder = new StringBuilder(srcDir);
        srcDir = appendDir == null ? srcDir : builder.append("/").append(appendDir).toString();
        return srcDir;
    }

    private String getDynPartDirectory(List<String> row, List<String> dpColNames, int numDynParts) {
        assert (row.size() == numDynParts && numDynParts == dpColNames.size()) : "data length is different from num of DP columns";
        return FileUtils.makePartName(dpColNames, row);
    }

    @Override
    public void startGroup() throws HiveException {
        if (!((FileSinkDesc)this.conf).getDpSortState().equals((Object)FileSinkDesc.DPSortState.NONE)) {
            this.keyOI = this.getGroupKeyObjectInspector();
            this.keys.clear();
            this.keyWritables.clear();
            ObjectInspectorUtils.partialCopyToStandardObject(this.keyWritables, (Object)this.getGroupKeyObject(), (int)0, (int)this.numKeyColToRead, (StructObjectInspector)((StructObjectInspector)this.keyOI), (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            for (Object o : this.keyWritables) {
                if (o == null || o.toString().length() == 0) {
                    this.keys.add(this.dpCtx.getDefaultPartitionName());
                    continue;
                }
                this.keys.add(o.toString());
            }
            this.fpaths = this.getDynOutPaths(this.keys, null);
        }
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        if (!this.bDynParts && !this.filesCreated) {
            this.createBucketFiles(this.fsp);
        }
        this.lastProgressReport = System.currentTimeMillis();
        if (!abort) {
            for (FSPaths fsp : this.valToPaths.values()) {
                fsp.closeWriters(abort);
                if (((FileSinkDesc)this.conf).isGatherStats() && this.isCollectRWStats) {
                    for (int idx = 0; idx < fsp.outWriters.length; ++idx) {
                        SerDeStats stats;
                        RecordWriter outWriter = fsp.outWriters[idx];
                        if (outWriter == null || (stats = ((StatsProvidingRecordWriter)outWriter).getStats()) == null) continue;
                        fsp.stat.addToStat("rawDataSize", stats.getRawDataSize());
                        fsp.stat.addToStat("numRows", stats.getRowCount());
                    }
                }
                if (!this.isNativeTable) continue;
                fsp.commit(this.fs);
            }
            if (((FileSinkDesc)this.conf).isGatherStats()) {
                this.publishStats();
            }
        } else {
            for (FSPaths fsp : this.valToPaths.values()) {
                fsp.abortWriters(this.fs, abort, !this.autoDelete && this.isNativeTable);
            }
        }
        this.prevFsp = null;
        this.fsp = null;
    }

    @Override
    public String getName() {
        return FileSinkOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "FS";
    }

    @Override
    public void jobCloseOp(Configuration hconf, boolean success) throws HiveException {
        try {
            if (this.conf != null && this.isNativeTable) {
                Path specPath = ((FileSinkDesc)this.conf).getDirName();
                DynamicPartitionCtx dpCtx = ((FileSinkDesc)this.conf).getDynPartCtx();
                if (((FileSinkDesc)this.conf).isLinkedFileSink() && dpCtx != null) {
                    specPath = ((FileSinkDesc)this.conf).getParentDir();
                }
                Utilities.mvFileToFinalPath(specPath, hconf, success, this.LOG, dpCtx, (FileSinkDesc)this.conf, this.reporter);
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        super.jobCloseOp(hconf, success);
    }

    @Override
    public OperatorType getType() {
        return OperatorType.FILESINK;
    }

    @Override
    public void augmentPlan() {
        PlanUtils.configureOutputJobPropertiesForStorageHandler(((FileSinkDesc)this.getConf()).getTableInfo());
    }

    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
        if (this.hiveOutputFormat == null) {
            try {
                if (((FileSinkDesc)this.getConf()).getTableInfo().getJobProperties() != null) {
                    if (((FileSinkDesc)this.getConf()).getTableInfo().getJobProperties().get("hive.passthrough.storagehandler.of") != null) {
                        job.set("hive.passthrough.storagehandler.of", ((FileSinkDesc)this.getConf()).getTableInfo().getJobProperties().get("hive.passthrough.storagehandler.of"));
                        this.hiveOutputFormat = (HiveOutputFormat)ReflectionUtils.newInstance(((FileSinkDesc)this.conf).getTableInfo().getOutputFileFormatClass(), (Configuration)job);
                    } else {
                        this.hiveOutputFormat = ((FileSinkDesc)this.conf).getTableInfo().getOutputFileFormatClass().newInstance();
                    }
                } else {
                    this.hiveOutputFormat = ((FileSinkDesc)this.conf).getTableInfo().getOutputFileFormatClass().newInstance();
                }
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
        Utilities.copyTableJobPropertiesToConf(((FileSinkDesc)this.conf).getTableInfo(), job);
        if (((FileSinkDesc)this.conf).getTableInfo().isNonNative()) {
            try {
                this.hiveOutputFormat.checkOutputSpecs(ignored, job);
            }
            catch (NoSuchMethodError e) {
                this.LOG.warn((Object)"HiveOutputFormat should implement checkOutputSpecs() method`");
            }
        }
    }

    private void publishStats() throws HiveException {
        boolean isStatsReliable = ((FileSinkDesc)this.conf).isStatsReliable();
        StatsPublisher statsPublisher = Utilities.getStatsPublisher(this.jc);
        if (statsPublisher == null) {
            this.LOG.error((Object)"StatsPublishing error: StatsPublisher is not initialized.");
            if (isStatsReliable) {
                throw new HiveException(ErrorMsg.STATSPUBLISHER_NOT_OBTAINED.getErrorCodedMsg());
            }
            return;
        }
        if (!statsPublisher.connect(this.hconf)) {
            this.LOG.error((Object)"StatsPublishing error: cannot connect to database");
            if (isStatsReliable) {
                throw new HiveException(ErrorMsg.STATSPUBLISHER_CONNECTION_ERROR.getErrorCodedMsg());
            }
            return;
        }
        String taskID = Utilities.getTaskIdFromFilename(Utilities.getTaskId(this.hconf));
        String spSpec = ((FileSinkDesc)this.conf).getStaticSpec();
        int maxKeyLength = ((FileSinkDesc)this.conf).getMaxStatsKeyPrefixLength();
        boolean taskIndependent = statsPublisher instanceof StatsCollectionTaskIndependent;
        for (Map.Entry<String, FSPaths> entry : this.valToPaths.entrySet()) {
            String prefix;
            String fspKey = entry.getKey();
            FSPaths fspValue = entry.getValue();
            if (((FileSinkDesc)this.conf).getDpSortState().equals((Object)FileSinkDesc.DPSortState.PARTITION_BUCKET_SORTED)) {
                taskID = Utilities.getTaskIdFromFilename(fspKey);
                fspKey = fspKey.split(taskID)[0];
            }
            String[] split = this.splitKey(fspKey);
            String dpSpec = split[0];
            String lbSpec = split[1];
            String postfix = null;
            if (taskIndependent) {
                prefix = ((FileSinkDesc)this.conf).getTableInfo().getTableName();
            } else {
                prefix = ((FileSinkDesc)this.conf).getStatsAggPrefix();
                postfix = Utilities.join(lbSpec, taskID);
            }
            prefix = Utilities.join(prefix, spSpec, dpSpec);
            prefix = Utilities.getHashedStatsPrefix(prefix, maxKeyLength);
            String key = Utilities.join(prefix, postfix);
            HashMap<String, String> statsToPublish = new HashMap<String, String>();
            for (String statType : fspValue.stat.getStoredStats()) {
                statsToPublish.put(statType, Long.toString(fspValue.stat.getStat(statType)));
            }
            if (statsPublisher.publishStat(key, statsToPublish) || !isStatsReliable) continue;
            throw new HiveException(ErrorMsg.STATSPUBLISHER_PUBLISHING_ERROR.getErrorCodedMsg());
        }
        if (!statsPublisher.closeConnection() && isStatsReliable) {
            throw new HiveException(ErrorMsg.STATSPUBLISHER_CLOSING_ERROR.getErrorCodedMsg());
        }
    }

    private String[] splitKey(String fspKey) {
        if (!fspKey.isEmpty() && this.isSkewedStoredAsSubDirectories) {
            for (String dir : this.lbCtx.getSkewedValuesDirNames()) {
                int index = fspKey.indexOf(dir);
                if (index < 0) continue;
                return new String[]{fspKey.substring(0, index), fspKey.substring(index + 1)};
            }
        }
        return new String[]{fspKey, null};
    }

    public class FSPaths
    implements Cloneable {
        Path tmpPath;
        Path taskOutputTempPath;
        Path[] outPaths;
        Path[] finalPaths;
        RecordWriter[] outWriters;
        Stat stat;

        public FSPaths() {
        }

        public FSPaths(Path specPath) {
            this.tmpPath = Utilities.toTempPath(specPath);
            this.taskOutputTempPath = Utilities.toTaskTempPath(specPath);
            this.outPaths = new Path[FileSinkOperator.this.numFiles];
            this.finalPaths = new Path[FileSinkOperator.this.numFiles];
            this.outWriters = new RecordWriter[FileSinkOperator.this.numFiles];
            this.stat = new Stat();
        }

        public Path getTaskOutPath(String taskId) {
            return new Path(this.taskOutputTempPath, Utilities.toTempPath(taskId));
        }

        public Path getFinalPath(String taskId, Path tmpPath, String extension) {
            if (extension != null) {
                return new Path(tmpPath, taskId + extension);
            }
            return new Path(tmpPath, taskId);
        }

        public void setOutWriters(RecordWriter[] out) {
            this.outWriters = out;
        }

        public RecordWriter[] getOutWriters() {
            return this.outWriters;
        }

        public void closeWriters(boolean abort) throws HiveException {
            for (int idx = 0; idx < this.outWriters.length; ++idx) {
                if (this.outWriters[idx] == null) continue;
                try {
                    this.outWriters[idx].close(abort);
                    FileSinkOperator.this.updateProgress();
                    continue;
                }
                catch (IOException e) {
                    throw new HiveException(e);
                }
            }
        }

        private void commit(FileSystem fs) throws HiveException {
            for (int idx = 0; idx < this.outPaths.length; ++idx) {
                try {
                    if ((FileSinkOperator.this.bDynParts || FileSinkOperator.this.isSkewedStoredAsSubDirectories) && !fs.exists(this.finalPaths[idx].getParent())) {
                        fs.mkdirs(this.finalPaths[idx].getParent());
                    }
                    if (!fs.rename(this.outPaths[idx], this.finalPaths[idx])) {
                        throw new HiveException("Unable to rename output from: " + this.outPaths[idx] + " to: " + this.finalPaths[idx]);
                    }
                    FileSinkOperator.this.updateProgress();
                    continue;
                }
                catch (IOException e) {
                    throw new HiveException("Unable to rename output from: " + this.outPaths[idx] + " to: " + this.finalPaths[idx], e);
                }
            }
        }

        public void abortWriters(FileSystem fs, boolean abort, boolean delete) throws HiveException {
            for (int idx = 0; idx < this.outWriters.length; ++idx) {
                if (this.outWriters[idx] == null) continue;
                try {
                    this.outWriters[idx].close(abort);
                    if (delete) {
                        fs.delete(this.outPaths[idx], true);
                    }
                    FileSinkOperator.this.updateProgress();
                    continue;
                }
                catch (IOException e) {
                    throw new HiveException(e);
                }
            }
        }

        public Stat getStat() {
            return this.stat;
        }
    }

    public static interface RecordWriter {
        public void write(Writable var1) throws IOException;

        public void close(boolean var1) throws IOException;
    }
}

